/***************************************************************************
    file	         : kb_layout.h
    copyright            : (C) 1999,2000,2001,2002,2003 by Mike Richardson
			   (C) 2000,2001,2002,2003 by theKompany.com
			   (C) 2001,2002,2003 by John Dean
    license              : This file is released under the terms of
                           the GNU General Public License, version 2. The
                           copyright holders retain the right to release
                           this code under diffenent non-exclusive licences.
    email                : mike@quaking.demon.co.uk                                     
 ***************************************************************************/

#ifndef	_KB_LAYOUT_H
#define	_KB_LAYOUT_H

#include	"libkbase_exports.h"

#include	<qlist.h>

#include	"kb_location.h"

/*  KBLayout								*/
/*  --------								*/
/*  This class is used at the top-most node in parsed documents, such	*/
/*  as forms and reports. It coordinates stuff like control positioning	*/
/*  and cut-and-paste.							*/

class	LIBKBASE_API	KBLayout
{
	KBNode		*parent		;	/* Document root	*/
#if	! __KB_RUNTIME
	QList<KBSizer>	sizerList	;	/* Active sizers	*/
#endif
	bool		dData		;	/* Data changed		*/
	bool		dDesign		;	/* Design changed	*/
	bool		design		;	/* Design mode		*/
	KBaseGUI	*currGUI  	;	/* Currently active GUI	*/

	KBItem		*unMorphedItem	;
	uint		unMorphedDRow	;

	void	setGUIEnables	()	;

public	:

	inline	KBLayout
		(	KBNode	*parent
		)
		:
		parent	(parent)
	{
		dData		= false ;
		dDesign		= false	;
		design		= false	;
		currGUI		= 0	;
		unMorphedItem	= 0	;
		unMorphedDRow	= 0	;
	}

#if	! __KB_RUNTIME
	/* Methods directly related to currently selected sizers. We	*/
	/* keep track of those selected, with the head of the list	*/
	/* being the active sizer.					*/
	void		initSizer       ()			 ;
	void		releaseSizer    ()			 ;
	void		dropSizer       (KBSizer *)		 ;
	KBLimit		addSizer	(KBSizer *, bool = true) ;

	/* The layout class is passed control movements when tracking,	*/
	/* so that these can be passed on to all selected sizers.	*/
	void		trackMove       (int, int,  bool)	 ;

	QRect		newCtrlRect     (KBObject *, Qt::ButtonState, QRect) ;

	void		doCtrlAlign     (KB::CtrlAlign)		 ;
	void		snapToGrid	() ;

	void		doCut		() ;
	void		doCopy		() ;
	void		doSaveComponent	(KBLocation  &) ;
	void		doPaste		() ;
	void		doMultiProp	() ;
	void		doSingleProp	() ;
	void		clear		(bool)		;
#endif
	void		setChanged	(bool = true)	;

	cchar		*getChanged	(bool)	;

	inline	void	setGUI		(KBaseGUI *g)
	{
		currGUI	= g ;
	}

	/* Similarly keep track of a currently unmorphed control, if	*/
	/* any, so that we will have at most one visible at a time if	*/
	/* any controls are morphing.					*/
	void		setUnMorphedItem(KBItem *, uint)	 ;
}	;

#endif	// _KB_LAYOUT_H
