/***************************************************************************
    file	         : kb_memo.h
    copyright            : (C) 1999,2000,2001,2002,2003 by Mike Richardson
			   (C) 2000,2001,2002,2003 by theKompany.com
			   (C) 2001,2002,2003 by John Dean
    license              : This file is released under the terms of
                           the GNU General Public License, version 2. The
                           copyright holders retain the right to release
                           this code under diffenent non-exclusive licences.
    email                : mike@quaking.demon.co.uk                                     
 ***************************************************************************/

#ifndef	_KB_MEMO_H
#define	_KB_MEMO_H

#include	"libkbase_exports.h"

#include	"tktextmanager.h"

#include	"kb_classes.h"
#include	"kb_item.h"
#include	"kb_attrframe.h"



/*  KBMemo								*/
/*  ------								*/
/*  This class is used to represent a memo field in forms and reports	*/
/*  (ie., a multiple line edit box).					*/

class LIBKBASE_API	KBMemo : public KBItem
{
	KBAttrStr	fgcolor	    ;	/* Foreground (text) colour	*/
	KBAttrStr	bgcolor	    ;	/* Background colour		*/
	KBAttrFrame	frame	    ;	/* Frame style			*/
	KBAttrStr	font	    ; 	/* Report font			*/
	KBAttrBool	nullOK	    ;	/* Is empty field OK		*/
	KBAttrStr	hilite	    ;	/* Text highlight scheme	*/
	KBAttrBool	wrap	    ;	/* Text wrapping		*/
	KBAttrStr	wrapChars   ;	/* Wrapping characters		*/
	KBAttrBool	m_emptyNull ;	/* Treat empty fields as null	*/
	KBEvent		onChange    ;

	KBReport	*report	    ;

	bool			doCheckValid	(const QString &, bool) ;

protected :

	virtual	KBControl	*makeCtrl	(uint)	  ;

#if	! __KB_RUNTIME
	virtual	bool		propertyDlg	(cchar *) ;
#endif

public	:

	KBMemo	(KBNode  *, const QDict<QString> &, bool * = 0) ;
	KBMemo	(KBNode  *, KBMemo *) ;
virtual~KBMemo	() ;

	virtual	KBNode		*replicate	(KBNode *) ;
	virtual	KBValue		getValue	(uint)	   ;

	bool			checkValid	(const QString &, bool) ;
	void			userChange	(uint)	   ;

	inline	bool	isWrapping ()
	{
		return	wrap.getBoolValue() ;
	}

	static	TKTextEditorManager	*getManager	() ;
}	;



#if	! __KB_RUNTIME
extern LIBKBASE_API	bool	memoPropDlg
			(	KBMemo		*,
				cchar		*,
				QList<KBAttr>	&,
				cchar		* = 0
			)	;
#endif
#endif	// _KB_MEMO_H
