/***************************************************************************
    file	         : kb_node.h
    copyright            : (C) 1999,2000,2001,2002,2003 by Mike Richardson
			   (C) 2000,2001,2002,2003 by theKompany.com
			   (C) 2001,2002,2003 by John Dean
    license              : This file is released under the terms of
                           the GNU General Public License, version 2. The
                           copyright holders retain the right to release
                           this code under diffenent non-exclusive licences.
    email                : mike@quaking.demon.co.uk                                     
 ***************************************************************************/

#ifndef	_KB_NODE_H
#define	_KB_NODE_H

#include	"libkbase_exports.h"

#include	<qobject.h>
#include	<qlist.h>
#include	<qdict.h>
#include	<qstring.h>

#include	"kb_classes.h"
#include	"kb_type.h"
#include	"kb_value.h"
#include	"kb_attr.h"



/*  KBNode								*/
/*  ----------								*/
/*  This is the base class for the set of classes used to represent	*/
/*  nodes in the XML parse tree.					*/

class LIBKBASE_API	KBNode : public QObject
{
	Q_OBJECT

	KBNode		*parent		;	/* Parent node		*/
	QString		element		;	/* Node type		*/
	KBError		lError		;	/* Last error		*/
	KBNode		*root		;	/* Root of this tree	*/
	KBAttrStr	*m_attrNotes	;	/* Documentation	*/
	KB::ShowAs	showing		;	/* Showing mode		*/
	uint		attrCnt		;

protected :

	QList<KBAttr>	attribs		;	/* List of attributes	*/
	QList<KBNode>	children	;	/* List of child nodes	*/
	uint		flags		;	/* Miscellaneous flags	*/
	KBNodeMonitor	*monitor	;	/* Tree monitor entry	*/
	QList<KBSlot>	m_slotList	;	/* List of slots	*/

#if	! __KB_RUNTIME
	bool		propertyDlg	(cchar *, cchar * = 0) ;
#endif
	virtual	void	setMonitor  	(KBNodeMonitor *) ;

public	:

	KBNode	(KBNode  *, cchar  *, const QDict<QString> &) ;
	KBNode	(KBNode  *, cchar  *) ;
	KBNode	(KBNode  *, KBNode *) ;
virtual~KBNode	()		     ;


	void			addChild   	(KBNode *)	 	;

	/* Attribute methods: Attributes attach themselves to their	*/
	/* parent on creation, and detach on deletion. We also provide	*/
	/* arbitrary access for script code.				*/
	KBNodeMonitor	 	*addAttr    	(KBAttr *, uint &)	;
	void			remAttr	   	(KBAttr *)	 	;
	KBAttr 			*getAttr   	(const QString  &) 	;

	bool			setAttrVal 	(const QString  &, const QString &, bool = false, bool = false) ;
	QString			getAttrVal 	(const QString  &) 	;


	virtual	void		updateProps	()			;
	virtual	bool		write		(KBWriter *, QPoint, bool, int &, bool = false) ;

	inline	const QList<KBNode> &getChildren ()
	{
		return	children ;
	}
	inline	const QList<KBAttr> &getAttribs  ()
	{
		return	attribs	 ;
	}
	inline	const QList<KBSlot> &getSlots 	 ()
	{
		return	m_slotList ;
	}


	virtual	void		findAllParams	(QDict<KBParamSet> &) ;

	void			showMonitor	(QListView     *) ;
	void			showMonitor	(QListViewItem *) ;
	void			setMonitorSelect(bool)		  ;

#if	! __KB_RUNTIME
	bool			doMultiProp	(QList<KBNode> 	 &) ;
	void			setMultiProp	(KBNode *) ;
#endif

	/* Base methods. Some of these will be overridden by the	*/
	/* derived classes in order to handle class-specific actions.	*/
	virtual	void		startParse 	()	 	  ;
	virtual	KBNode		*endParse  	()	 	  ;
	virtual	KBNode		*replicate 	(KBNode *)	  ;
	virtual	KBNode		*replicateBelow (KBNode *)	  ;
	virtual	void		showAs 		(KB::ShowAs)	  ;
	virtual	void		remChild   	(KBNode *)	  ;
	virtual	void		printNode  	(QString &,int)	  ;
	virtual	void		applyDialog	()		  ;
	virtual	void		prepare		()		  ;


	/* Common access to protected stuff ...				*/
	inline	KBNode		*getRoot	() { return root    ; }
	inline	KBNode		*getParent	() { return parent  ; }
	inline	const QString	&getElement	() { return element ; }

	inline	KB::ShowAs	isShowing	()
	{
		return	showing ;
	}
	inline	bool		showingDesign	()
	{
#if	__KB_RUNTIME
		return	false	;
#else
		return	showing == KB::ShowAsDesign ;
#endif
	}
	inline	bool		showingData	()
	{
		return	showing == KB::ShowAsData   ;
	}

	inline	uint		getFlags	() { return flags   ; }

	inline	KBLayout	*getLayout	() { return root->isLayout () ; }
	inline	KBDocRoot	*getDocRoot	() { return root->isDocRoot() ; }
	inline	KBForm		*getForm	() { return root->isForm   () ; }
	inline	KBReport	*getReport	() { return root->isReport () ; }


	/* The folloing methods are are used to test if a node is	*/
	/* is actually an instance of a specific type. Individual	*/
	/* derived classes will define instance for their themselves,	*/
	/* eg., "KBScript" will define "isScript" which will return	*/
	/* "this".							*/
	virtual	KBParam		*isParam	() { return 0 ; }
	virtual	KBModule	*isModule	() { return 0 ; }
	virtual	KBScript	*isScript	() { return 0 ; }
	virtual	KBConfig	*isConfig	() { return 0 ; }
	virtual	KBOverride	*isOverride	() { return 0 ; }
	virtual	KBImport	*isImport	() { return 0 ; }
	virtual	KBQryBase	*isQryBase	() { return 0 ; }
	virtual	KBQryData	*isQryData	() { return 0 ; }
	virtual	KBQryTable	*isQryTable	() { return 0 ; }
	virtual	KBQryQuery	*isQryQuery	() { return 0 ; }
	virtual	KBQryNull	*isQryNull	() { return 0 ; }
	virtual	KBQrySQL	*isQrySQL	() { return 0 ; }
	virtual	KBQryDesign     *isQryDesign	() { return 0 ; }
	virtual	KBItem		*isItem		() { return 0 ; }
	virtual	KBObject	*isObject	() { return 0 ; }
	virtual	KBBlock		*isBlock	() { return 0 ; }
	virtual	KBFormBlock	*isFormBlock	() { return 0 ; }
	virtual	KBReportBlock	*isReportBlock	() { return 0 ; }
	virtual	KBFramer	*isFramer	() { return 0 ; }
	virtual	KBHeader	*isHeader	() { return 0 ; }
	virtual	KBFooter	*isFooter	() { return 0 ; }
	virtual	KBContainer	*isContainer	() { return 0 ; }
	virtual	KBComponent	*isComponent	() { return 0 ; }
	virtual	KBTabberPage	*isTabberPage	() { return 0 ; }
	virtual	KBTabber	*isTabber	() { return 0 ; }
	virtual	KBNavigator	*isNavigator	() { return 0 ; }
	virtual	KBForm		*isForm		() { return 0 ; }
	virtual	KBReport	*isReport	() { return 0 ; }
	virtual	KBRowMark	*isRowMark	() { return 0 ; }
	virtual	KBGrid		*isGrid		() { return 0 ; }
	virtual	KBHidden	*isHidden	() { return 0 ; }
	virtual	KBQuery		*isQuery	() { return 0 ; }
	virtual	KBTable		*isTable	() { return 0 ; }
	virtual	KBQryExpr	*isQryExpr	() { return 0 ; }
	virtual	KBDocRoot	*isDocRoot	() { return 0 ; }
	virtual	KBLayout	*isLayout	() { return 0 ; }

	virtual	KB::ObjType	objType		() ;

	/* Environment checking, ie., what soirt of document we are	*/
	/* in.								*/
	inline	bool	isFormDoc   ()
	{
		return	getRoot()->isForm  () != 0 ;
	}
	inline	bool	isReportDoc ()
	{
		return	getRoot()->isReport() != 0 ;
	}
	inline	bool	isQueryDoc ()
	{
		return	getRoot()->isQuery () != 0 ;
	}

	inline	void	setError
			(	const KBError	&e
			)
		{
			lError	= e ;
		}
	inline	void	setError
			(	KBError::EType	etype,
				const QString	&message,
				const QString	&details,
				cchar		*file,
				uint		lno
			)
		{
			lError	= KBError (etype, message, details, file, lno) ;
		}
	inline	void	setError
			(	KBError::EType	etype,
				const QString	&message,
				cchar		*file,
				uint		lno
			)
		{
			lError	= KBError (etype, message, "", file, lno) ;
		}

	inline	const	KBError	&lastError () { return lError ; }

	friend	class	KBBlock	 	;
	friend	class	KBForm	 	;
	friend	class	KBReport 	;
	friend	class	KBComponent	;
}	;


/*  CITER(Type,Ptr,Action)						*/
/*  This macro is provided for convenience. It generates code which	*/
/*  iterates over all children, doing "Action" for each child which is	*/
/*  of type "Type", where "Ptr" is the pointer at the child in the	*/
/*  action.								*/


#define	CITER(Type,Ptr,Action) \
	{	QListIterator<KBNode> __iter (KBNode::children) ;	\
		KBNode *__##Ptr ;					\
		KB##Type *Ptr ;						\
		while ((__##Ptr = __iter.current()) != 0)		\
		{	__iter += 1 ;					\
			if ((Ptr = __##Ptr->is##Type()) != 0)		\
			{	Action ;				\
			}						\
		}							\
	}

#endif	// _KB_NODE_H
