/***************************************************************************
    file	         : kb_override.h
    copyright            : (C) 1999,2000,2001,2002,2003 by Mike Richardson
			   (C) 2000,2001,2002,2003 by theKompany.com
			   (C) 2001,2002,2003 by John Dean
    license              : This file is released under the terms of
                           the GNU General Public License, version 2. The
                           copyright holders retain the right to release
                           this code under diffenent non-exclusive licences.
    email                : mike@quaking.demon.co.uk                                     
 ***************************************************************************/

#ifndef	__KB_OVERRIDE_H
#define	__KB_OVERRIDE_H


#include	"kb_node.h"
#include	"libkbase_exports.h"


/*  KBOverride								*/
/*  --------								*/

class	LIBKBASE_API	KBOverride : public KBNode
{
	KBAttrStr	m_ident		;
	KBAttrStr	m_path		;
	KBAttrStr	m_attrib	;
	KBAttrStr	m_value		;
	KBAttrBool	m_enabled	;

public	:

	KBOverride	(KBNode *, const QDict<QString> &, bool * = 0) ;
	KBOverride 	(KBNode *, const QString &, const QString &, const QString &, const QString &, bool) ;
	KBOverride	(KBNode *, KBOverride *) ;
       ~KBOverride 	() ;
	
	virtual	KBNode	*replicate 	(KBNode *)	  ;

	virtual	KBOverride
			*isOverride 	() { return this ; }

	QString		ident		() { return m_ident    .getValue     () ; }
	QString		path		() { return m_path     .getValue     () ; }
	QString		attrib		() { return m_attrib   .getValue     () ; }
	QString		value		() { return m_value    .getValue     () ; }
	bool		enabled		() { return m_enabled  .getBoolValue () ; }

	inline	void	setPath
		(	const QString	&p
		)
	{
		m_path    .setValue (p) ;
	}
	inline	void	setValue
		(	const QString	&v
		)
	{
		m_value   .setValue (v) ;
	}
	inline	void	setEnabled
		(	bool		e
		)
	{
		m_enabled .setValue (e) ;
	}

	KBObject	*substitute () ;
}	;

extern	QString	paramSub	(const QString &, const QDict<QString> &) ;


#endif	// __KB_OVERRIDE_H
