/***************************************************************************
    file	         : kb_prompt.cpp
    copyright            : (C) 1999,2000,2001,2002,2003 by Mike Richardson
			   (C) 2000,2001,2002,2003 by theKompany.com
			   (C) 2001,2002,2003 by John Dean
    license              : This file is released under the terms of
                           the GNU General Public License, version 2. The
                           copyright holders retain the right to release
                           this code under diffenent non-exclusive licences.
    email                : mike@quaking.demon.co.uk                                     
 ***************************************************************************/

#include	<qapp.h>
#include	<qdialog.h>


#include	"kb_classes.h"
#include	"kb_prompt.h"
#include	"kb_dbinfo.h"
#include	"kb_location.h"
#include	"kb_callback.h"
#include	"kb_appptr.h"



/*  KBPromptDlg								*/
/*  KBPromptDlg	: Constructor for prompt dialog				*/
/*  caption	: const QString & : Dialog caption			*/
/*  message	: const QString & : Dialog prompt message		*/
/*  value	: QString & 	  : Initial value/result		*/
/*  (returns)	: KBPromptDlg	  :					*/

KBPromptDlg::KBPromptDlg
	(	const QString	&caption,
		const QString	&message,
		QString		&value
	)
	:
	_KBDialog	(caption, true),
	m_bOK		(this),
	m_bCancel	(this),
	m_tMessage	(this),
	m_tValue	(this),
	m_value		(value)
{
	m_lMain	 = new QVBoxLayout (this)     ;

	m_lMain  ->addWidget	(&m_tMessage) ;
	m_lMain  ->addWidget	(&m_tValue  ) ;

	m_lButton= new QHBoxLayout (m_lMain ) ;

	m_lButton->addStretch	()	      ;
	m_lButton->addWidget	(&m_bOK     ) ;
	m_lButton->addWidget	(&m_bCancel ) ;

	m_tMessage.setText      (message) ;
	m_tValue  .setText      (value  ) ;

	m_bOK	  .setText      (TR("OK"    )) ;
	m_bCancel .setText      (TR("Cancel")) ;
	m_bOK	.  setDefault 	(true) ;

	connect	     (&m_bOK,     SIGNAL(clicked()), this, SLOT(accept())) ;
	connect	     (&m_bCancel, SIGNAL(clicked()), this, SLOT(reject())) ;

	m_tValue.setFocus () ;

	setMinimumSize (285, 110) ;
}

/*  KBPromptDlg								*/
/*  ~KBPromptDlg: Destructor for prompt dialog				*/
/*  (returns)	: void		:					*/

KBPromptDlg::~KBPromptDlg ()
{
}

/*  KBPromptDlg								*/
/*  accept	: Handle OK button click				*/
/*  (returns)	: void		:					*/

void	KBPromptDlg::accept ()
{
	m_value	= m_tValue.text () ;
	done (true) ;
}

/*  doPrompt	: Execute prompt dialog					*/
/*  caption	: const QString&: Dialog caption			*/
/*  message	: const QString&: Dialog prompt message			*/
/*  value	: QString &	: Initial value/result			*/
/*  (returns)	: bool		: Success				*/

bool	LIBKBASE_API	doPrompt
	(	const	QString	&caption,
		const	QString	&message,
		QString		&value
	)
{
	KBPromptDlg pDlg  (caption, message, value) ;
	return	pDlg.exec () ;
}


/*  ------------------------------------------------------------------  */

/*  KBPromptSaveDlg							*/
/*  KBPromptSaveDlg							*/
/*		: Constructor for save prompt dialog			*/
/*  caption	: const QString & : Dialog caption			*/
/*  message	: const QString & : Dialog prompt message		*/
/*  value	: QString &	  : Initial value/result		*/
/*  where	: QString &	  : Initial location/result		*/
/*  dbInfo	: KBDBInfo *	  : Database information		*/
/*  incfiles	: bool		  : Include files in list		*/
/*  (returns)	: KBPromptDlg	  :					*/

KBPromptSaveDlg::KBPromptSaveDlg
	(	const QString	&caption,
		const QString	&message,
		QString		&value,
		QString		&where,
		KBDBInfo	*dbInfo,
		bool		incfiles
	)
	:
	_KBDialog	(caption, true),
	m_bOK		(this),
	m_bCancel	(this),
	m_tMessage	(this),
	m_tValue	(this),
	m_cWhere	(this),
	m_value		(value),
	m_where		(where),
	m_incfiles	(incfiles)
{
	m_lMain	 = new QVBoxLayout (this) ;

	m_lMain	 ->addWidget	(&m_tMessage) ;
	m_lMain	 ->addWidget	(&m_tValue  ) ;
	m_lMain	 ->addWidget	(&m_cWhere  ) ;

	m_lButton= new QHBoxLayout (m_lMain ) ;

	m_lButton->addStretch	()	      ;
	m_lButton->addWidget	(&m_bOK     ) ;
	m_lButton->addWidget	(&m_bCancel ) ;

	m_tMessage.setText      (message) ;
	m_tValue  .setText      (value  ) ;
	m_tValue  .setSelection (0, value.length()) ;

	if (incfiles)
		m_cWhere.insertItem (dbInfo->getDBName()) ;

	QListIterator<KBServerInfo> *svIter = dbInfo->getServerIter() ;
	KBServerInfo		    *svInfo ;

	while ((svInfo = svIter->current()) != 0)
	{	m_cWhere.insertItem (svInfo->serverName()) ;
		(*svIter) += 1 ;
	}

	delete	svIter	;
	m_cWhere.setCurrentItem (0) ;
	for (int idx = 1 ; idx < m_cWhere.count() ; idx += 1)
		if (m_cWhere.text(idx) == where)
		{	m_cWhere.setCurrentItem (idx) ;
			break	;
		}


	m_bOK	 .setText       ("OK"    ) ;
	m_bCancel.setText       ("Cancel") ;
	m_bOK	 .setDefault	(true) ;

	connect	     (&m_bOK,     SIGNAL(clicked()), this, SLOT(accept())) ;
	connect	     (&m_bCancel, SIGNAL(clicked()), this, SLOT(reject())) ;

	m_tValue.setFocus () ;

	setMinimumSize (285, 110) ;
}

/*  KBPromptSaveDlg							*/
/*  ~KBPromptSaveDlg: Destructor for prompt dialog			*/
/*  (returns)	    : void		:				*/

KBPromptSaveDlg::~KBPromptSaveDlg ()
{
}

/*  KBPromptSaveDlg							*/
/*  accept	: Handle OK button click				*/
/*  (returns)	: void		:					*/

void	KBPromptSaveDlg::accept ()
{
	m_value	= m_tValue.text () ;

	if (m_incfiles && (m_cWhere.currentItem () == 0))
		m_where	= QString (KBLocation::m_pFile) ;
	else	m_where	= m_cWhere.currentText () ;

	done (true) ;
}

/*  doPromptSave: Execute prompt save dialog				*/
/*  caption	: const QString & : Dialog caption			*/
/*  message	: const QString & : Dialog prompt message		*/
/*  value	: QString &	  : Initial value/result		*/
/*  where	: QString &	  : Initial location/result		*/
/*  dbInfo	: KBDBInfo *	  : Database information		*/
/*  incfiles	: bool		  : Include files in list		*/
/*  (returns)	: bool		  : Success				*/

bool	LIBKBASE_API	doPromptSave
	(	const QString	&caption,
		const QString	&message,
		QString		&value,
		QString		&where,
		KBDBInfo	*dbInfo,
		bool		incfiles
	)
{
	KBPromptSaveDlg pDlg  (caption, message, value, where, dbInfo, incfiles) ;
	return	pDlg.exec () ;
}



/*  ------------------------------------------------------------------  */

/*  KBChoiceDlg								*/
/*  KBChoiceDlg	: Constructor for prompt dialog				*/
/*  caption	: const QString & : Dialog caption			*/
/*  message	: const QString & : Dialog prompt message		*/
/*  choices	: QStringList   & : Choices available			*/
/*  value	: QString &	  : Initial value/result		*/
/*  (returns)	: KBChoiceDlg	  :					*/

KBChoiceDlg::KBChoiceDlg
	(	const QString	&caption,
		const QString	&message,
		QStringList	&choices,
		QString		&value
	)
	:
	_KBDialog	(caption, true),
	m_bOK		(this),
	m_bCancel	(this),
	m_tMessage	(this),
	m_cValues	(this),
	m_value		(value)
{
	m_lMain	 = new QVBoxLayout (this) ;

	m_lMain  ->addWidget	(&m_tMessage) ;
	m_lMain  ->addWidget	(&m_cValues ) ;

	m_lButton= new QHBoxLayout (m_lMain ) ;

	m_lButton->addStretch	()	      ;
	m_lButton->addWidget	(&m_bOK     ) ;
	m_lButton->addWidget	(&m_bCancel ) ;

	m_tMessage.setText	(message) ;

	for (QStringList::Iterator it = choices.begin() ; it != choices.end() ; ++it)
		m_cValues.insertItem ((*it).latin1()) ;

	m_bOK	 .setText       ("OK"    ) ;
	m_bCancel.setText       ("Cancel") ;
	m_bOK	 .setDefault 	(true) ;

	connect	     (&m_bOK,     SIGNAL(clicked()), this, SLOT(accept())) ;
	connect	     (&m_bCancel, SIGNAL(clicked()), this, SLOT(reject())) ;

	m_cValues.setFocus () ;

	setMinimumSize (285, 110) ;
}

/*  KBChoiceDlg								*/
/*  ~KBChoiceDlg: Destructor for prompt dialog				*/
/*  (returns)	: void		:					*/

KBChoiceDlg::~KBChoiceDlg ()
{
}

/*  KBChoiceDlg								*/
/*  accept	: Handle OK button click				*/
/*  (returns)	: void		:					*/

void	KBChoiceDlg::accept ()
{
	m_value	= m_cValues.currentText () ;
	done (true) ;
}

