/***************************************************************************
    file	         : kb_qrynull.h
    copyright            : (C) 1999,2000,2001,2002,2003 by Mike Richardson
			   (C) 2000,2001,2002,2003 by theKompany.com
			   (C) 2001,2002,2003 by John Dean
    license              : This file is released under the terms of
                           the GNU General Public License, version 2. The
                           copyright holders retain the right to release
                           this code under diffenent non-exclusive licences.
    email                : mike@quaking.demon.co.uk                                     
 ***************************************************************************/

#ifndef	 _KB_QRYMENU_H
#define	 _KB_QRYMENU_H

#include "kb_qrybase.h"

#include "libkbase_exports.h"

#ifdef   _WIN32
#define  uint UINT
#endif

/*  KBQryNull								*/
/*  ---------								*/
/*  This class provides a null query for use in null blocks. 	In	*/
/*  effect, it provides a query that always succeeds, and returns zero	*/
/*  rows of zero fields.						*/

class LIBKBASE_API	KBQryNull : public KBQryBase
{
	QList<KBItem>	m_items	;

protected :

#if	! __KB_RUNTIME
	virtual	bool	propertyDlg  ()			{ return true ; }
#endif

public	:

	KBQryNull	(KBNode *, const QDict<QString> &, bool * = 0) ;
	KBQryNull	(KBNode *, KBQryNull *) ;
	KBQryNull	(KBNode *) ;

virtual~KBQryNull	() ;


	virtual	KBNode	*replicate   (KBNode  *) ;

	virtual	bool	addItem      (uint, KBItem  *) ;
	virtual	void	remItem      (uint, KBItem  *) ;

	virtual	bool	getSelect
		(	uint		,
			KBSelect	&
		)
	{
		return	true	;
	}

	virtual	bool	select
		(	uint		,
			KBValue 	*,
			const QString	&,
			const QString	&,
			const QString	&,
			bool		= false,
			uint		= 0
		)
	{
		return	true	;
	}

	virtual	void	resetData	(uint, uint) { } ;

	virtual	bool	startUpdate	(uint, uint, Locking)
	{
		return	true	;
	}
	virtual	bool	endUpdate	(uint, bool)
	{
		return	true	;
	}
	virtual	KBQryBase::Locking
				lockingState	(uint)
	{
		return	KBQryBase::NoLocking	;
	}

	virtual	bool	saveRow		(uint, uint) { return true ; }
	virtual	bool	deleteRow	(uint, uint) { return true ; }
	virtual	bool	insertRow	(uint, uint) { return true ; }

	virtual	bool	clearItems	(uint, uint) ;
	virtual	bool	loadItems	(uint, uint) ;

	virtual	bool	syncRow
		(	uint		,
			uint		,
			KBValue		*,
			const QString	&,
			KBBlock 	*,
			KB::Action	&,
			KBValue		&
		)
	{
		return	true	;
	}
	virtual	bool	syncAll
		(	uint		,
			KBValue 	*,
			const QString	&,
			KBBlock 	*
		)
	{
		return	true	;
	}

	virtual	bool	newRowEmpty  (uint, uint)	{ return true ; }
	virtual	bool	rowIsDirty   (uint, uint, bool)	{ return true ; }
	virtual uint	getNumRows   (uint)		{ return 1    ; }

	virtual	void	sortByColumn (uint, uint, bool, KBItem *) {}

	virtual	bool	getFieldList
		(	uint		   ,
			QList<KBFieldSpec> &,
			int	 	   &
		)
	{
		return	true ;
	}
	virtual	KBValue	getField
		(	uint	,
			uint	,
			uint	,
			bool	= false
		)
	{
		return	KBValue	() ;
	}
	virtual	void	setField
		(	uint	,
			uint	,
			uint	,
			const KBValue	&
		)
	{
	}
	virtual	uint	getWidth
		(	uint	,
			uint	
		)
	{
		return	0	;
	}
	virtual	KB::RState getRowState
		(	uint	,
			uint
		)
	{
		return	KB::RSInSync ;
	}
	virtual	uint	setCurrentRow
		(	uint	,
			uint
		)
	{
		return	0 ;
	}
	virtual	uint	getPermission
		(	uint
		)
	{
		return	0 ;
	}
	virtual	KBQryNull  *isQryNull ()
	{
		return	this ;
	}
	virtual	void	setRowMarked
		(	uint		,
			uint		,
			KB::MarkOp
		)
	{
	}
	virtual	bool	getRowMarked
		(	uint		,
			uint
		)
	{
		return	false	;
	}

	virtual	bool	deleteAllMarked
		(	uint	,
			uint	&nrows
		)
	{
		nrows	= 0	;
		return	true	;
	}

	virtual	QString	getComment
		(	uint
		)
	{
		return	"NULL"	;
	}

	virtual	QString	getSQLText
		(	uint	,
			bool
		)
	{
		return	QString::null ;
	}

	virtual	QString	getSQLReason
		(	uint
		)
	{
		return	QString::null ;
	}
}	;

#endif	// _KB_QRYMENU_H
