/***************************************************************************
    file	         : kb_richtext.cpp
    copyright            : (C) 1999,2000,2001,2002,2003 by Mike Richardson
			   (C) 2000,2001,2002,2003 by theKompany.com
			   (C) 2001,2002,2003 by John Dean
    license              : This file is released under the terms of
                           the GNU General Public License, version 2. The
                           copyright holders retain the right to release
                           this code under diffenent non-exclusive licences.
    email                : mike@quaking.demon.co.uk                                     
 ***************************************************************************/

#include	<stdio.h>
#include	<stdlib.h>
#include	<ctype.h>

#include	<qapplication.h>
#include	<qlist.h>
#include	<qstring.h>
#include	<qcursor.h>

#include	"kb_classes.h"
#include	"kb_type.h"
#include	"kb_value.h"

#include	"kb_sizer.h"
#include	"kb_display.h"
#include	"kb_ctrl.h"
#include	"kb_formblock.h"
#include	"kb_richtext.h"
#include	"kb_qtrichtext.h"
#include	"kb_nodereg.h"
#include	"kb_writer.h"
#include	"kb_layout.h"




/*  KBRichText								*/
/*  KBRichText	: Constructor for QT rich text field			*/
/*  parent	: KBNode *	: Parent node				*/
/*  aList	: const QDict<QString> &				*/
/*				: List of attributes			*/
/*  ok		: bool *	: Success				*/
/*  (returns)	: KBNode	:					*/

KBRichText::KBRichText
	(	KBNode			*parent,
		const QDict<QString>	&aList,
		bool			*ok
	)
	:
	KBItem	(parent, "KBRichText",	"expr",  aList),
	fgcolor	(this,   "fgcolor",	aList),
	bgcolor	(this,   "bgcolor",	aList),
	font	(this,	 "font",	aList, KF_FORM|KF_REPORT),
	supress	(this,	 "supress",	aList, KF_REPORT)
{
#if	! __KB_RUNTIME
	if (ok != 0)
	{
		if (!::richTextPropDlg (this, "Rich Text", attribs))
		{	delete	this	;
			*ok	= false	;
			return	;
		}

		*ok	= true	;
	}
#endif
	if (isReportDoc())
		report	= getParent()->getReport () ;
	else	report	= 0 ;
}

/*  KBRichText								*/
/*  KBRichText	: Constructor for simple form field			*/
/*  _parent	: KBNode *	: Parent node				*/
/*  _field	: KBRichText *	: Extant field				*/
/*  (returns)	: KBRichText	:					*/

KBRichText::KBRichText
	(	KBNode		*_parent,
		KBRichText		*_field
	)
	:
	KBItem	(_parent,"expr",	_field),
	fgcolor	(this,   "fgcolor",	_field),
	bgcolor	(this,   "bgcolor",	_field),
	font	(this,	 "font",	_field, KF_REPORT),
	supress	(this,	 "supress",	_field, KF_REPORT)
{
	if (isReportDoc())
		report	= getParent()->getReport () ;
	else	report	= 0 ;
}

/*  KBRichText								*/
/*  ~KBRichText	: Destructor for simple form field			*/
/*  (returns)	:		:					*/

KBRichText::~KBRichText ()
{
}

/*  KBRichText								*/
/*  makeCtrl	: Make a field control					*/
/*  morph	: bool		: Get morped control			*/
/*  (returns)	: KBControl *	: New control				*/

KBControl
	*KBRichText::makeCtrl
	(	uint		drow
	)
{
	return	new KBCtrlRichText (getDisplay(), this, drow) ;
}

/*  KBRichText								*/
/*  getReportValue							*/
/*		: Get value for report writing				*/
/*  first	: bool		: First output flag			*/
/*  prior	: bool		: Write prior value			*/
/*  (returns)	: KBValue	: Value					*/

KBValue	KBRichText::getReportValue
	(	bool		first,
		bool
	)
{
	QString	text	;

	if (first || (curVal != lastVal) || !supress.getBoolValue())
	{
		lastVal	= curVal ;
		return	  curVal ;
	}

	return	KBValue() ;
}

/*  KBRichText								*/
/*  replicate	: Replicate this field					*/
/*  _parent	: KBNode *	: Parent of replicant			*/
/*  (returns)	: KBNode *	: New field node			*/

KBNode	*KBRichText::replicate
	(	KBNode	*_parent
	)
{
	return	new KBRichText (_parent, this) ;
}

#if	! __KB_RUNTIME

/*  KBRichText								*/
/*  propertyDlg	: Show property dialog					*/
/*  (returns)	: bool		: Success				*/

bool	KBRichText::propertyDlg ()
{
	if (!::richTextPropDlg (this, "Rich text", attribs))
		return false ;

	updateProps  () ;
	return true     ;
}
#endif


NEWNODE(RichText, __TR("New &Rich Text"), KF_FORM|KF_REPORT|KF_BLOCK|KF_DATA)
