/***************************************************************************
    file	         : kb_tableinfodlg.cpp
    copyright            : (C) 1999,2000,2001,2002,2003 by Mike Richardson
			   (C) 2000,2001,2002,2003 by theKompany.com
			   (C) 2001,2002,2003 by John Dean
    license              : This file is released under the terms of
                           the GNU General Public License, version 2. The
                           copyright holders retain the right to release
                           this code under diffenent non-exclusive licences.
    email                : mike@quaking.demon.co.uk                                     
 ***************************************************************************/

#ifndef		_WIN32
#include	"kb_tableinfodlg.moc"
#else
#include	"kb_tableinfodlg.h"
#endif

#include	"kb_dblink.h"
	

KBTableInfoDlg::KBTableInfoDlg
	(	KBDBInfo	*dbInfo,
		const QString	&server,
		KBTableInfoSet	*tableInfoSet
	)
	:
	_KBDialog	("Table Information", true),
	m_dbInfo	(dbInfo),
	m_server	(server),
	m_tableInfoSet	(tableInfoSet),
	m_tableList	(this),
	m_columnList	(this),
	m_uniqueList	(this),
	m_bAdd		(this),
	m_bRemove	(this),
	m_bOK		(this),
	m_bCancel	(this)
{
	m_layMain	= new QVBoxLayout (this) ;
	m_layMain    ->addWidget (&m_tableList)	 ;

	m_layColumns	= new QHBoxLayout (m_layMain   ) ;
	m_layColumns ->addWidget (&m_columnList)	 ;
	m_layAddRem	= new QVBoxLayout (m_layColumns) ;
	m_layColumns ->addWidget (&m_uniqueList)	 ;

	m_layAddRem  ->addWidget (&m_bAdd) 	 ;
	m_layAddRem  ->addWidget (&m_bRemove)	 ;
	m_layAddRem  ->addStretch()		 ;

	m_layOKCancel	= new QHBoxLayout (m_layMain) ;
	m_layOKCancel->addStretch()		 ;
	m_layOKCancel->addWidget (&m_bOK)	 ;
	m_layOKCancel->addWidget (&m_bCancel)	 ;

	m_bAdd	 .setText (TR("Add"   )) ;
	m_bRemove.setText (TR("Remove")) ;
	m_bOK	 .setText (TR("OK"    )) ;
	m_bCancel.setText (TR("Cancel")) ;

	connect	(&m_bAdd,       SIGNAL(clicked()), SLOT(clickAdd   ())) ;
	connect	(&m_bRemove,    SIGNAL(clicked()), SLOT(clickRemove())) ;
	connect	(&m_bOK,        SIGNAL(clicked()), SLOT(clickOK    ())) ;
	connect	(&m_bCancel,    SIGNAL(clicked()), SLOT(clickCancel())) ;

	connect (&m_tableList,  SIGNAL(activated(const QString &)),
			        SLOT  (pickTable(const QString &))) ;

	connect (&m_columnList, SIGNAL(highlighted(int)), SLOT(pickColumn())) ;
	connect (&m_uniqueList, SIGNAL(highlighted(int)), SLOT(pickUnique())) ;

	m_tableMap.setAutoDelete  (true) ;

	const QDict<KBTableInfo>	&tableMap  = m_tableInfoSet->tableMap() ;
	QDictIterator<KBTableInfo>	tableIter  (tableMap) ;
	KBTableInfo			*tableInfo ;

	while ((tableInfo = tableIter.current()) != 0)
	{
		m_tableMap.insert
		(	tableIter.currentKey(),
			new KBTableUniqueList (tableInfo->unique ())
		)	;

		tableIter += 1 ;
	}
}

int	KBTableInfoDlg::exec ()
{
	KBDBLink dbLink ;
	if (!dbLink.connect (m_dbInfo, m_server))
	{	dbLink.lastError().DISPLAY() ;
		return	0 ;
	}

	KBTableDetailsList tabList ;
	if (!dbLink.listTables (tabList))
	{	dbLink.lastError().DISPLAY() ;
		return	0 ;
	}

	for (uint idx = 0 ; idx < tabList.count() ; idx += 1)
		m_tableList.insertItem (tabList[idx].m_name) ;

	showTable (m_tableList.currentText()) ;

	return	_KBDialog::exec() ;
}

void	KBTableInfoDlg::showTable
	(	const QString	&table
	)
{
	KBDBLink dbLink ;
	if (!dbLink.connect (m_dbInfo, m_server))
	{	dbLink.lastError().DISPLAY() ;
		return	;
	}

	KBTableSpec tabSpec (table) ;
	if (!dbLink.listFields (tabSpec))
	{	dbLink.lastError().DISPLAY() ;
		return	;
	}

	static	KBTableUniqueList empty	  ;
	const	KBTableUniqueList *unique = m_tableMap.find (table) ;
	if (unique == 0) unique = &empty  ;

	m_columnList.clear () ;
	m_uniqueList.clear () ;

	for (uint idx1 = 0 ; idx1 < tabSpec.m_fldList.count() ; idx1 += 1)
	{
		QString	field	= tabSpec.m_fldList.at(idx1)->m_name ;
		bool	set	= false	;

		for (uint idx2 = 0 ; idx2 < unique->count() ; idx2 += 1)
			if ((*unique)[idx2].column() == field)
			{	set	= true ;
				break	;
			}

		if (set)
			m_uniqueList.insertItem (field) ;
		else	m_columnList.insertItem (field) ;
	}

	m_bAdd	 .setEnabled (false) ;
	m_bRemove.setEnabled (false) ;

	m_currTable = table ;
}

void	KBTableInfoDlg::saveTable
	(	const QString	&table
	)
{
	KBTableUniqueList *unique = m_tableMap.find (table) ;

	if (unique == 0)
		m_tableMap.insert (table, unique = new KBTableUniqueList) ;
	else	unique->clear () ;

	for (uint idx = 0 ; idx < m_uniqueList.count() ; idx += 1)
		unique->append
		(	KBTableUnique
			(	m_uniqueList.text (idx),
				QString::null
		)	)	;
}

void	KBTableInfoDlg::pickTable
	(	const QString	&table
	)
{
	saveTable (m_currTable) ;
	showTable (table)	;
}

void	KBTableInfoDlg::pickColumn ()
{
	m_bAdd.setEnabled (true) ;
}

void	KBTableInfoDlg::pickUnique ()
{
	m_bRemove.setEnabled (true) ;
}

void	KBTableInfoDlg::clickAdd ()
{
	int idx = m_columnList.currentItem() ;

	if (idx >= 0)
	{	m_uniqueList.insertItem (m_columnList.currentText()) ;
		m_columnList.removeItem (idx) ;
	}

	m_bAdd   .setEnabled (m_columnList.currentItem() >= 0) ;
	m_bRemove.setEnabled (m_columnList.currentItem() >= 0) ;
}

void	KBTableInfoDlg::clickRemove ()
{
	int idx = m_uniqueList.currentItem() ;

	if (idx >= 0)
	{	m_columnList.insertItem (m_uniqueList.currentText()) ;
		m_uniqueList.removeItem (idx) ;
	}

	m_bAdd   .setEnabled (m_columnList.currentItem() >= 0) ;
	m_bRemove.setEnabled (m_columnList.currentItem() >= 0) ;
}

void	KBTableInfoDlg::clickOK ()
{
	saveTable (m_currTable) ;

	QDictIterator<KBTableUniqueList> tabIter (m_tableMap) ;
	KBTableUniqueList		 *unique ;

	while ((unique = tabIter.current()) != 0)
	{
		m_tableInfoSet->setUnique (tabIter.currentKey(), *unique) ;
		tabIter += 1 ;
	}

	m_tableInfoSet->save(true) ;

	done	(1) ;
}

void	KBTableInfoDlg::clickCancel ()
{
	done	(0) ;
}

