/***************************************************************************
    file	         : kb_tabpagedlg.h
    copyright            : (C) 1999,2000,2001,2002,2003 by Mike Richardson
			   (C) 2000,2001,2002,2003 by theKompany.com
			   (C) 2001,2002,2003 by John Dean
    license              : This file is released under the terms of
                           the GNU General Public License, version 2. The
                           copyright holders retain the right to release
                           this code under diffenent non-exclusive licences.
    email                : mike@quaking.demon.co.uk                                     
 ***************************************************************************/

#ifndef	__KB_TABPAGEDLG
#define	__KB_TABPAGEDLG

#if	! __KB_RUNTIME

#include	"libkbase_exports.h"

#include	<qpushbutton.h>
#include	<qlayout.h>

#include	"kb_draglist.h"
#include	"kb_framer.h"
#include	"kb_dialog.h"


/*  KBPageListBoxItem							*/
/*  ----------------							*/
/*  This class is a wrapper round QListBoxText. It retains a a pointer	*/
/*  to the tab page with which it is associated.			*/


class	LIBKBASE_API	KBPageListBoxItem : public QListBoxText
{
	KBTabberPage	*m_page	;

public	:

	inline	KBPageListBoxItem
		(	QListBox	*listBox,
			KBTabberPage	*page
		)
		:
		QListBoxText	(listBox, page->getAttrVal("tabtext")),
		m_page		(page)
	{
	}

	inline	KBTabberPage	*getPage ()
	{
		return	m_page	;
	}
}	;

class	LIBKBASE_API	KBTabPageDlg : public _KBDialog
{
	Q_OBJECT	
	QPushButton		m_bMoveUp	;
	QPushButton		m_bMoveDown	;
	QPushButton		m_bOK		;
	QPushButton		m_bCancel	;
	KBDragBox		m_pageListBox	;
	QHBoxLayout		*m_layMain	;
	QGridLayout		*m_layButt	;
	QList<KBTabberPage>	&m_pageList	;

protected slots :

	void			clickOK	      ();
	void			clickCancel   ();
	void			clickMoveUp   ();
	void			clickMoveDown ();

public	:

	KBTabPageDlg (QList<KBTabberPage> &)	;
}	;

#endif
#endif	// __KB_TABPAGEDLG
