/***************************************************************************
    file	         : kb_check.h
    copyright            : (C) 1999,2000,2001,2002,2003 by Mike Richardson
			   (C) 2000,2001,2002,2003 by theKompany.com
			   (C) 2001,2002,2003 by John Dean
    license              : This file is released under the terms of
                           the GNU General Public License, version 2. The
                           copyright holders retain the right to release
                           this code under diffenent non-exclusive licences.
    email                : mike@quaking.demon.co.uk                                     
 ***************************************************************************/

#ifndef	_KB_CHECK_H
#define	_KB_CHECK_H

#include "libkbase_exports.h"

#include	<sys/types.h>
#include	<qcheckbox.h>

#include	"kb_classes.h"
#include	"kb_node.h"
#include	"kb_item.h"



/*  KBCheck								*/
/*  -------								*/
/*  This class is used to represent a KBaseCheck element in the XML	*/
/*  form description. Note that it may map onto more than one actual	*/
/*  field.								*/

class LIBKBASE_API	KBCheck : public KBItem
{
	KBAttrStr	fgcolor	;	/* Foreground (text) colour	*/
	KBAttrStr	bgcolor	;	/* Background colour		*/
	KBEvent		onChange;	/* Value changed event		*/

protected :

	virtual	KBControl *makeCtrl  (uint) ;

#if	! __KB_RUNTIME
	virtual	bool	 propertyDlg () ;
#endif

public	:

	KBCheck	(KBNode  *, const QDict<QString> &, bool * = 0) ;
	KBCheck (KBNode  *, KBCheck *) ;
virtual~KBCheck	() ;

	virtual	KBNode	*replicate 	(KBNode *) ;

	void		userChange	(uint, bool) ;
}	;

#endif	// _KB_CHECK_H
