/***************************************************************************
    file	         : kb_choice.h
    copyright            : (C) 1999,2000,2001,2002,2003 by Mike Richardson
			   (C) 2000,2001,2002,2003 by theKompany.com
			   (C) 2001,2002,2003 by John Dean
    license              : This file is released under the terms of
                           the GNU General Public License, version 2. The
                           copyright holders retain the right to release
                           this code under diffenent non-exclusive licences.
    email                : mike@quaking.demon.co.uk                                     
 ***************************************************************************/

#ifndef	_KB_CHOICE_H
#define	_KB_CHOICE_H

#include 	"libkbase_exports.h"

#include	<qdict.h>
#include	<qstringlist.h>

#include	"kb_classes.h"
#include	"kb_item.h"
#include	"kb_qtchoice.h"


/*  KBChoice								*/
/*  --------								*/
/*  This class is used to represent a KBaseChoice element in the XML	*/
/*  form description. Note that it may map onto more than one actual	*/
/*  field.								*/

class LIBKBASE_API	KBChoice : public KBItem
{
	KBAttrStr	m_values	;
	KBAttrStr	m_nullval	;
	KBAttrBool	m_nullOK	;
	KBAttrBool	m_editable	;
	KBAttrStr	m_fgcolor	;
	KBAttrStr	m_bgcolor	;
	KBAttrStr	m_font		;
	KBAttrBool	m_morph		;
	KBEvent		m_onChange	;

	QStringList	m_valset	;

	void		loadValues    ()	;

protected :

	virtual	KBControl	*makeCtrl	(uint)	  ;
	virtual	bool		isMorphing	()	  ;

#if	! __KB_RUNTIME
	virtual	bool		propertyDlg	(cchar *) ;
#endif

public	:

	KBChoice(KBNode  *, const QDict<QString> &, bool * = 0) ;
	KBChoice(KBNode  *, KBChoice *) ;
	virtual~KBChoice()		 ;

	virtual	KBNode		*replicate	(KBNode *     ) ;
	virtual	void		showAs		(KB::ShowAs   ) ;
	virtual	void		setData		(uint, void  *) ;
	virtual	bool		keyStroke	(QKeyEvent   *) ;

	void			setValues	(const QStringList   &) ;
	bool			checkValid	(const QString &, bool) ;
	void			userChange	(uint, const QString &) ;

	const	QStringList	&getValues	()
	{
		return	m_valset ;
	}

	void			setCurrentItem	(uint, uint) ;
	uint			currentItem	(uint)	     ;

	inline	bool	canEdit	()
	{
		return	m_editable.getBoolValue	() ;
	}

	virtual	void		doSearch	() ;
}	;


#if	! __KB_RUNTIME
extern LIBKBASE_API	bool	choicePropDlg
			(	KBChoice	*,
				cchar		*,
				QList<KBAttr>	&,
				cchar		* = 0
			)	;
#endif
#endif	// _KB_CHOICE_H
