/***************************************************************************
    file	         : kb_config.cpp
    copyright            : (C) 1999,2000,2001,2002,2003 by Mike Richardson
			   (C) 2000,2001,2002,2003 by theKompany.com
			   (C) 2001,2002,2003 by John Dean
    license              : This file is released under the terms of
                           the GNU General Public License, version 2. The
                           copyright holders retain the right to release
                           this code under diffenent non-exclusive licences.
    email                : mike@quaking.demon.co.uk                                     
 ***************************************************************************/

#include	<stdio.h>
#include	<stdarg.h>

#include	<qlist.h>
#include	<qdict.h>
#include	<qstring.h>


#include	"kb_classes.h"
#include	"kb_attr.h"

#include	"kb_node.h"
#include	"kb_object.h"
#include	"kb_config.h"
#include	"kb_nodereg.h"


/*  KBConfig								*/
/*  KBConfig	: Constructor for configuration node			*/
/*  parent	: KBNode *	: Parent node				*/
/*  aList	: const QDict<QString> &				*/
/*				: Attribute list			*/
/*		: bool *	:					*/
/*  (returns)	: KBConfig	:					*/

KBConfig::KBConfig
	(	KBNode			*parent,
		const QDict<QString>	&aList,
		bool			*
	)
	:
	KBNode		(parent, "KBConfig"),
	m_ident		(this,	 "ident",	aList),
	m_attrib	(this,	 "attrib",	aList),
	m_value		(this,	 "value",	aList),
	m_legend	(this,	 "legend",	aList),
	m_user		(this,	 "user",	aList),
	m_required	(this,	 "required",	aList),
	m_hidden	(this,	 "hidden",	aList)
{
	m_changed	= false ;
}

/*  KBConfig								*/
/*  KBConfig	: Constructor for configuration node			*/
/*  parent	: KBNode *	  : Parent node				*/
/*  ident	: const QString & : Identification			*/
/*  attrib	: const QString & : Attribute name			*/
/*  value	: const QString & : Default value			*/
/*  legend	: const QString & : Legend				*/
/*  user	: bool		  : User (script) configuration		*/
/*  required	: bool		  : Value is required			*/
/*  hidden	: bool		  : Hidden state			*/
/*  (returns)	: KBConfig	  :					*/

KBConfig::KBConfig
	(	KBNode			*parent,
		const QString		&ident,
		const QString		&attrib,
		const QString		&value,
		const QString		&legend,
		bool			user,
		bool			required,
		bool			hidden
	)
	:
	KBNode		(parent, "KBConfig"),
	m_ident		(this,	 "ident",	ident	),
	m_attrib	(this,	 "attrib",	attrib	),
	m_value		(this,	 "value",	value	),
	m_legend	(this,	 "legend",	legend	),
	m_user		(this,	 "user",	user	),
	m_required	(this,	 "required",	required),
	m_hidden	(this,	 "hidden",	hidden	)
{
	m_changed	= false ;
}

/*  KBConfig								*/
/*  KBConfig	: Constructor for configuration node			*/
/*  parent	: KBNode *	: Parent node				*/
/*  extant	: KBConfig *	: Extant node				*/
/*  (returns)	: KBConfig	:					*/

KBConfig::KBConfig
	(	KBNode			*parent,
		KBConfig		*extant
	)
	:
	KBNode		(parent, "KBConfig"),
	m_ident		(this,	 "ident",	extant),
	m_attrib	(this,	 "attrib",	extant),
	m_value		(this,	 "value",	extant),
	m_legend	(this,	 "legend",	extant),
	m_user		(this,	 "user",	extant),
	m_required	(this,	 "required",	extant),
	m_hidden	(this,	 "hidden",	extant)
{
	m_changed	= false ;
}

/*  KBConfig								*/
/*  KBConfig	: Destructor for configuration node			*/
/*  (returns)	:		:					*/

KBConfig::~KBConfig ()
{
}

void	KBConfig::setValue
	(	const QString	&v
	)
{
	m_value.setValue (v) ;
}

/*  KBConfig								*/
/*  substitute	: Substitue value into parent				*/
/*  over	: bool		: True if this is an override		*/
/*  (returns)	: void		:					*/

void	KBConfig::substitute
	(	bool		over
	)
{
	KBAttr	*attr	= getParent()->getAttr(m_attrib.getValue()) ;
	QString	value	= m_value.getValue() ;

	fprintf
	(	stderr,
		"KBConfig::substitute(%d) [%p][%s]<-[%s]\n",
		over,
		(void  *)attr,
		(cchar *)m_attrib.getValue(),
		(cchar *)value
	)	;

	if (attr == 0) return ;

	KBEvent	*event	= attr->isEvent() ;
	if (over && (event != 0))
	{
		if (!value.isEmpty()) event->setOverride (value) ;
		return	;
	}

	attr->setValue (value) ;
}

/*  KBConfig								*/
/*  fixupValue	: Fix value from parents current attribute value	*/
/*  (returns)	: void		:					*/

void	KBConfig::fixupValue ()
{
	if (!m_user.getBoolValue())
		m_value.setValue (getParent()->getAttrVal(m_attrib.getValue())) ;
}

/*  KBConfig								*/
/*  replicate	: Replicate this configuration node			*/
/*  _parent	: KBNode *	: Parent of replicant			*/
/*  (returns)	: KBNode *	: New choice node			*/

KBNode	*KBConfig::replicate
	(	KBNode	*_parent
	)
{
	return	new KBConfig (_parent, this) ;
}

/*  KBConfig								*/
/*  printNode	: Output node XML					*/
/*  text	: QString &	: Result string				*/
/*  indent	: int		: Indent level of this node		*/
/*  (returns)	: void		:					*/

void	KBConfig::printNode
	(	QString	&text,
		int	indent
	)
{
	KBNode::printNode (text, indent) ;
}


NEWNODE(Config, (cchar *)0, KF_FORM|KF_REPORT)


