/***************************************************************************
    file	         : kb_dialog.h
    copyright            : (C) 1999,2000,2001,2002,2003 by Mike Richardson
			   (C) 2000,2001,2002,2003 by theKompany.com
			   (C) 2001,2002,2003 by John Dean
    license              : This file is released under the terms of
                           the GNU General Public License, version 2. The
                           copyright holders retain the right to release
                           this code under diffenent non-exclusive licences.
    email                : mike@quaking.demon.co.uk                                     
 ***************************************************************************/

#ifndef	_KB_SUPPORT_H
#define	_KB_SUPPORT_H

#include 	"libkbase_exports.h"

#include	<qapplication.h>
#include	<qlayout.h>
#include	<qdialog.h>


class		TKTextEditorManager	;

/*  _KBDialog								*/
/*  ---------								*/
/*  This class is a wrapper for QDialog. It exists to to set the	*/
/*  handle layout (margin and spacing); the implementation handles the	*/
/*  desktop and embedded cases.						*/

class	LIBKBASE_API	_KBDialog : public QDialog
{
	Q_OBJECT

	QString		m_name		;
	QSize		m_lastSize	;

	void		init 		(const QString &, const char * = 0, const QSize & = QSize()) ;

protected :

	bool		m_showMaxed	;

	void		setupLayout	(QLayout *)	;
	void		setupLayout	(QWidget *)	;

	virtual int	getSpacing	(QLayout *  = 0);
	virtual int	getMargin	(QLayout *  = 0);

	virtual	void	resizeEvent	(QResizeEvent *);

public	:

	_KBDialog 	(QString, 	const char * = 0, const QSize & = QSize()) ;
	_KBDialog 	(QString, bool, const char * = 0, const QSize & = QSize()) ;
       ~_KBDialog	() ;

	virtual	void	show		() ;

	/* Static versions for use in dialogs (such as tabbed dialogs)	*/
	/* which are not derived from _KBDialog.			*/
	static	void	setupLayout	(QLayout *, int, int)	;
	static	void	setupLayout	(QWidget *, int, int)	;


	static	TKTextEditorManager	*getTextManager
					(	QString = QString::null,
						bool	= false,
						bool	= false
					)	;
}	;

#endif	// _KB_SUPPORT_H
