/***************************************************************************
    file	         : kb_emitter.cpp
    copyright            : (C) 1999,2000,2001,2002,2003 by Mike Richardson
			   (C) 2000,2001,2002,2003 by theKompany.com
			   (C) 2001,2002,2003 by John Dean
    license              : This file is released under the terms of
                           the GNU General Public License, version 2. The
                           copyright holders retain the right to release
                           this code under diffenent non-exclusive licences.
    email                : mike@quaking.demon.co.uk                                     
 ***************************************************************************/

#include	"kb_classes.h"
#include	"kb_attr.h"
#include	"kb_event.h"
#include	"kb_object.h"

#ifndef		_WIN32
#include	"kb_emitter.moc"
#else
#include	"kb_emitter.h"
#endif


/*  KBEmitter								*/
/*  KBEmitter	: Constructor for event signal emitter			*/
/*  parent	: KBObject *	: Parent object				*/
/*  event	: KBEvent  *	: Associated event			*/
/*  (returns)	: KBEmitter	:					*/
 
KBEmitter::KBEmitter
	(	KBObject	*parent,
		KBEvent		*event
	)
	:
	m_parent(parent),
	m_event	(event)
{
}

/*  KBEmitter								*/
/*  doSignal	: Emit an event signal					*/
/*  argc	: uint		: Number of arguments			*/
/*  argv	: KBValue *	: Vector of arguments			*/
/*  (returns)	: KB::ScriptRC	: Slot execution return			*/

KB::ScriptRC
	KBEmitter::doSignal
	(	uint		argc,
		KBValue		*argv
	)
{
//	fprintf
//	(	stderr,
//		"KBEmitter::doSignal [%s/%s] [%d/%p]\n",
//		(cchar *)m_parent->getAttrVal("name"),
//		(cchar *)m_event ->getName(),
//		argc,
//		(void *)argv
//	)	;

	KB::ScriptRC	rc	= KB::ScriptOK ;

	emit	eventSignal
		(	m_parent,
			m_event->getName (),
			argc,
			argv,
			rc
		)	;

	return	rc	;
}
