/***************************************************************************
    file	         : kb_errordlg.cpp
    copyright            : (C) 1999,2000,2001,2002,2003 by Mike Richardson
			   (C) 2000,2001,2002,2003 by theKompany.com
			   (C) 2001,2002,2003 by John Dean
    license              : This file is released under the terms of
                           the GNU General Public License, version 2. The
                           copyright holders retain the right to release
                           this code under diffenent non-exclusive licences.
    email                : mike@quaking.demon.co.uk                                     
 ***************************************************************************/

#include	<stdlib.h>

#include	<qapp.h>
#include	<qdialog.h>
#include	<qregexp.h>

#include	"kb_classes.h"
#include	"tk_icons.h"

#ifndef 	_WIN32
#include	"kb_errordlg.moc"
#else
#include	"kb_errordlg.h"
#endif



/*  KBErrorDlg								*/
/*  KBErrorDlg	: Constructor for error report dialog			*/
/*  etype	: KBError::EType : Error type				*/
/*  message	: const QString &: Error message			*/
/*  detailText	: const QString &: Error details			*/
/*  caption	: const QString &: Optional caption			*/
/*  sfile	: cchar *	 : Originating source file		*/
/*  slno	: uint		 : Originating line number		*/
/*  dfile	: cchar *	 : Display source file			*/
/*  dlno	: uint		 : Display line number			*/
/*  (returns)	: KBErrorDlg	 :					*/

KBErrorDlg::KBErrorDlg
	(	KBError::EType	etype,
		const QString	&message,
		const QString	&detailText,
		const QString	&caption,
		cchar		*sFile,
		uint		sLno,
		cchar		*dFile,
		uint		dLno
	)
	:
	QDialog		(qApp->activeWindow(), 0, true),
	m_bOK		(this),
	m_bDetails	(this),
	m_lIcon		(this),
	m_lMessage	(this),
	m_layMain	(this),
	m_etype		(etype),
	m_detailText	(detailText),
	m_tDetails	(0),
	m_srceLabel	(0),
	m_srceFile	(0),
	m_destLabel	(0),
	m_destFile	(0),
	m_layDetails	(0)
{
	cchar	    *icon   ;

	setIcon (getSmallIcon ("rekall")) ;

	if (sFile != 0) m_srceMsg = QString("%1:%2").arg(sFile).arg(sLno) ;
	if (dFile != 0) m_destMsg = QString("%1:%2").arg(dFile).arg(dLno) ;

	m_detailText.replace(QRegExp("<" ), "&lt;" ) ;
	m_detailText.replace(QRegExp(">" ), "&gt;" ) ;
	m_detailText.replace(QRegExp("\n"), "<br/>") ;

	switch (etype)
	{
		case KBError::Info	: icon = "note"      ; break ;
		case KBError::Warning	: icon = "caution"   ; break ;
		case KBError::Error	: icon = "important" ; break ;
		case KBError::Fault	: icon = "warning"   ; break ;
		default			: icon = "warning"   ; break ;
	}

	QPixmap	    pixmap  = getDesktopIcon(icon) ;

	m_layMain .setMargin	 (4) ;
	m_layMain .setSpacing	 (8) ;

	m_lIcon	.setPixmap	 (pixmap ) ;
	m_lMessage.setTextFormat	 (Qt::RichText) ;
	m_lMessage.setText         (message) ;
	m_lMessage.setMinimumWidth (300) ;

	m_bOK	.setText         ("OK") ;
	m_bOK	.setDefault	 (true) ;
	m_bDetails.setText         ("Show details >>" ) ;

	QHBoxLayout *layInfo	= new QHBoxLayout (&m_layMain) ;
	QHBoxLayout *layButt	= new QHBoxLayout (&m_layMain) ;

	layInfo->addWidget 	 (&m_lIcon   )	;
	layInfo->addWidget 	 (&m_lMessage)	;
	layInfo->setStretchFactor
				 (&m_lMessage, 1) ;

	layButt->addWidget 	 (&m_bOK     )	;
	layButt->addWidget 	 (&m_bDetails)	;
	layButt->addStretch	 (1)	       	;

	layInfo->setMargin 	 (4)		;
	layInfo->setSpacing	 (8)		;
	layButt->setMargin 	 (4)		;
	layButt->setSpacing	 (8)		;

	connect	(&m_bOK, SIGNAL(clicked()), SLOT(accept())) ;

	if (caption.isEmpty())
		setCaption
		(
			etype == KBError::Info    ? "Information"	:
			etype == KBError::Warning ? "Warning"	    	:
			etype == KBError::Error   ? "Error"		:
			etype == KBError::Fault   ? "Internal error"	:
						    "Unknown error"
		)	;
	else	setCaption (caption) ;


	if (detailText.isEmpty() && ((dFile == 0) || (KBError::errDebug == 0)))
		m_bDetails.hide () ;
	else	connect	(&m_bDetails, SIGNAL(clicked()), SLOT(slotDetails())) ;

	m_expanded = false   ;
}

/*  KBErrorDlg								*/
/*  ~KBErrorDlg	: Destructor for error report dialog			*/
/*  (returns)	:		:					*/

KBErrorDlg::~KBErrorDlg ()
{
}

/*  KBErrorDlg								*/
/*  details	: Toggle details view					*/
/*  (returns)	: void		:					*/

void	KBErrorDlg::slotDetails ()
{
	if (!m_expanded)
	{
		m_baseSize	= size () ;
		m_tDetails	= new QTextView (this) ;

		m_tDetails->setTextFormat (Qt::RichText) ;
		m_tDetails->setText	  ("<qt>" + m_detailText + "</qt>") ;
		m_tDetails->show	  () ;

		m_layMain   .addWidget	(m_tDetails) ;

		if ((KBError::errDebug != 0) && !m_destMsg.isEmpty())
		{
			m_srceLabel	= new QLabel (this) ;
			m_srceFile	= new QLabel (this) ;
			m_destLabel	= new QLabel (this) ;
			m_destFile	= new QLabel (this) ;

			m_srceLabel ->setText       ("Source" ) ;
			m_srceFile  ->setText       (m_srceMsg) ;

			m_destLabel ->setText       ("Display") ;
			m_destFile  ->setText       (m_destMsg) ;

			m_srceFile  ->setFrameStyle(QFrame::Box|QFrame::Plain) ;
			m_destFile  ->setFrameStyle(QFrame::Box|QFrame::Plain) ;

			m_layDetails = new QGridLayout (&m_layMain) ;

			m_layDetails->addWidget	    (m_srceLabel, 0, 0) ;
			m_layDetails->addWidget	    (m_srceFile,  0, 1) ;
			m_layDetails->addWidget	    (m_destLabel, 1, 0) ;
			m_layDetails->addWidget	    (m_destFile,  1, 1) ;
			m_layDetails->setColStretch (1, 1) ;
			m_layDetails->setSpacing    (8) ;

			m_srceLabel ->show () ;
			m_srceFile  ->show () ;
			m_destLabel ->show () ;
			m_destFile  ->show () ;
		}

		m_expanded = true ;

		m_bDetails.setText (TR("<< Hide details")) ;
	}
	else
	{
		DELOBJ	(m_tDetails  ) ;
		DELOBJ	(m_srceLabel ) ;
		DELOBJ	(m_srceFile  ) ;
		DELOBJ	(m_destLabel ) ;
		DELOBJ	(m_destFile  ) ;
		DELOBJ	(m_layDetails) ;
		m_expanded = false ;

		m_bDetails.setText (TR("Show details >>")) ;

		/* Resize to the size just before we expanded. It seems	*/	
		/* neccessary to process all outstanding events first,	*/
		/* presumably so that all the resizes associated with	*/
		/* deleting the details stuff gets done _before_ the	*/
		/* restore.						*/
		qApp->processEvents() ;
		resize	(m_baseSize) ;
	}
}


int	KBErrorDlg::exec ()
{
	if (m_etype == KBError::None)
		if (getenv ("REKALL_ALLERRORS") == 0)
			return	1 ;

	return	QDialog::exec ()  ;
}
