/***************************************************************************
    file	         : kb_field.cpp
    copyright            : (C) 1999,2000,2001,2002,2003 by Mike Richardson
			   (C) 2000,2001,2002,2003 by theKompany.com
			   (C) 2001,2002,2003 by John Dean
    license              : This file is released under the terms of
                           the GNU General Public License, version 2. The
                           copyright holders retain the right to release
                           this code under diffenent non-exclusive licences.
    email                : mike@quaking.demon.co.uk                                     
 ***************************************************************************/

#include	<stdio.h>
#include	<stdlib.h>
#include	<ctype.h>

#include	<qapplication.h>
#include	<qlist.h>
#include	<qstring.h>
#include	<qcursor.h>

#include	"kb_classes.h"
#include	"kb_type.h"
#include	"kb_value.h"

#include	"kb_sizer.h"
#include	"kb_display.h"
#include	"kb_ctrl.h"
#include	"kb_formblock.h"
#include	"kb_field.h"
#include	"kb_qtfield.h"
#include	"kb_nodereg.h"
#include	"kb_writer.h"
#include	"kb_layout.h"
#include	"kb_finddlg.h"
#include	"kb_form.h"


/*  KBField								*/
/*  KBField	: Constructor for simple form field			*/
/*  parent	: KBNode *	: Parent node				*/
/*  aList	: const QDict<QString> &				*/
/*				: List of attributes			*/
/*  ok		: bool *	: Success				*/
/*  (returns)	: KBNode	:					*/

KBField::KBField
	(	KBNode			*parent,
		const QDict<QString>	&aList,
		bool			*ok
	)
	:
	KBItem		(parent, "KBField",	"expr",  aList),
	fgcolor		(this,   "fgcolor",	aList),
	bgcolor		(this,   "bgcolor",	aList),
	font		(this,	 "font",	aList),
	passwd		(this,	 "passwd",	aList, KF_FORM  ),
	nullOK		(this,   "nullok",	aList, KF_FORM  ),
	m_emptyNull	(this,	 "emptynull",	aList, KF_FORM	),
	eValid		(this,   "evalid",	aList, KF_FORM  ),
	ignCase		(this,   "igncase", 	aList, KF_FORM  ),
	mask		(this,	 "mask",	aList, KF_FORM  ),
	format		(this,	 "format",	aList),
	m_deformat	(this,	 "deformat",	aList, KF_FORM  ),
	align		(this,	 "align",	aList),
	supress		(this,	 "supress",	aList, KF_REPORT),
	helper		(this,	 "helper",	aList, KF_FORM  ),
	morph		(this,   "morph",	aList, KF_FORM  ),
	onChange	(this,   "onchange",
				 "onField",	aList, KF_FORM  )
{
#if	! __KB_RUNTIME
	if (ok != 0)
	{
		if (!::fieldPropDlg (this, "Field", attribs))
		{	delete	this	;
			*ok	= false	;
			return	;
		}

		*ok	= true	;
	}

	if (isReportDoc())
		report	= getParent()->getReport () ;
	else	report	= 0 ;
#endif
}

/*  KBField								*/
/*  KBField	: Constructor for simple form field			*/
/*  _parent	: KBNode *	: Parent node				*/
/*  _field	: KBField *	: Extant field				*/
/*  (returns)	: KBField	:					*/

KBField::KBField
	(	KBNode		*_parent,
		KBField		*_field
	)
	:
	KBItem		(_parent,"expr",	_field),
	fgcolor		(this,   "fgcolor",	_field),
	bgcolor		(this,   "bgcolor",	_field),
	font		(this,	 "font",	_field),
	passwd		(this,	 "passwd",	_field, KF_FORM  ),
	nullOK		(this,   "nullok",	_field, KF_FORM  ),
	m_emptyNull	(this,	 "emptynull",	_field, KF_FORM	 ),
	eValid		(this,   "evalid",	_field, KF_FORM  ),
	ignCase		(this,   "igncase", 	_field, KF_FORM  ),
	mask		(this,	 "mask",	_field, KF_FORM  ),
	format		(this,   "format", 	_field),
	m_deformat	(this,	 "deformat",	_field, KF_FORM  ),
	align		(this,	 "align",	_field),
	supress		(this,	 "supress",	_field, KF_REPORT),
	helper		(this,	 "helper",	_field, KF_FORM  ),
	morph		(this,    "morph",	_field, KF_FORM  ),
	onChange	(this,   "onchange",
				 "onField",	_field, KF_FORM  )
{
	if (isReportDoc())
		report	= getParent()->getReport () ;
	else	report	= 0 ;
}

/*  KBField								*/
/*  ~KBField	: Destructor for simple form field			*/
/*  (returns)	:		:					*/

KBField::~KBField ()
{
}

/*  KBField								*/
/*  makeCtrl	: Make a field control					*/
/*  morph	: bool		: Get morped control			*/
/*  (returns)	: KBControl *	: New control				*/

KBControl
	*KBField::makeCtrl
	(	uint		drow
	)
{
	return	new KBCtrlField (getDisplay(), this, drow) ;
}

/*  KBField								*/
/*  showAs	: Set or clear design mode				*/
/*  mode	: KB::ShowAs	: Design mode				*/
/*  (returns)	: void		:					*/

void	KBField::showAs
	(	KB::ShowAs	mode
	)
{
	m_rValid = QRegExp () ;
	KBItem::showAs (mode) ;
}

/*  KBField								*/
/*  doCheckValid: Check whether value can be saved in database		*/
/*  value	: const QString & : Putative value			*/
/*  allowNull	: bool		  : Ignore not-null check		*/
/*  (returns)	: bool		  : True if OK				*/

bool	KBField::doCheckValid
	(	const QString	&value,
		bool		allowNull
	)
{
	KBError	err	;

	/* First check is for empty fields when the field must be not-	*/
	/* null, except that we skip this test if nulls are being	*/
	/* allowed (while tabbing around a form).			*/
	if (!allowNull)
		if (value.isEmpty () && !nullOK.getBoolValue())
		{	
			setError
			(	KBError::Error,
		  		QString (TR("Field %1 may not be empty")).arg(name.getValue()),
				QString::null,
			  	__ERRLOCN
			)	;
			return	false	;
		}

	/* If the value is not empty and there is a validator then see	*/
	/* if the new value is OK.					*/
	if (!value.isEmpty() && !eValid.getValue().isEmpty())
	{
		if (m_rValid.isEmpty())
		{
			m_rValid.setPattern (eValid.getValue()) ;

			if (!m_rValid.isValid())
			{
				setError
				(	KBError::Error,
					QString (TR("Field %1: bad validator")).arg(name.getValue()),
					QString::null,
					__ERRLOCN
				)	;
				return	false	;
			}
		}

		if (m_rValid.match (value) < 0)
		{
			setError
			(	KBError::Error,
			  	QString (TR("Field %1 has invalid contents")).arg(name.getValue()),
				QString::null,
			  	__ERRLOCN
			)	;
			return	false	;
		}

	}

	/* If the value is not empty or we are doing not-null checks	*/
	/* then see if the value is OK to be saved to the database.	*/
	if (!value.isEmpty() || !allowNull)
		if (!type->isValid (value, err, name.getValue()))
		{
			setError (err) ;
			return	 false ;
		}

	return	true	;
}

/*  KBField								*/
/*  checkValid	: Check whether value can be saved in database		*/
/*  value	: const QString & : Putative value			*/
/*  allowNull	: bool		  : Ignore not-null check		*/
/*  (returns)	: bool		  : True if OK				*/

bool	KBField::checkValid
	(	const QString	&value,
		bool		allowNull
	)
{
	/* Special case. Ig the value is empty and empty values are to	*/
	/* be treated as null, then validate it as such.		*/
	if (value.isEmpty() && m_emptyNull.getBoolValue())
		return	doCheckValid (QString::null, allowNull) ;

	return	doCheckValid (value, allowNull) ;
}

/*  KBField								*/
/*  userChange	: Selection changed notification			*/
/*  qrow	: uint		: Query row number			*/
/*  (returns)	: void		:					*/

void	KBField::userChange
	(	uint	qrow
	)
{
	KBItem::userChange (qrow) ;
}

/*  KBField								*/
/*  getValue	: Get value						*/
/*  qrow	: uint		: Query row				*/
/*  (returns)	: KBValue	: Value					*/

KBValue	KBField::getValue
	(	uint	qrow
	)
{
	/* Get the control for the specified row. If there isn't one	*/
	/* (outside the displayed range) then return a null.		*/
	KBControl *ctrl = ctrlAtQRow (qrow) ;
	if (ctrl == 0) return KBValue()	    ;

	/* Get the value. If this is empty and empty values are to be	*/
	/* treated as nulls then also return a null ...			*/
	KBValue	value	= ctrl->getValue()  ;
	if (value.dataLength() == 0)
		if (m_emptyNull.getBoolValue())
			return	KBValue()   ;

	/* ... otherwise use the value as-is.				*/
	return	value	;
}

/*  KBField								*/
/*  getReportValue							*/
/*		: Get value for report writing				*/
/*  first	: bool		: First output flag			*/
/*  prior	: bool		: Write prior value			*/
/*  (returns)	: KBValue	: Value					*/

KBValue	KBField::getReportValue
	(	bool		first,
		bool
	)
{
	QString	text	;

	if (first || (curVal != lastVal) || !supress.getBoolValue())
	{	lastVal	= curVal ;
		return	  curVal ;
	}

	return	KBValue() ;
}

/*  KBField								*/
/*  isMorphing	: Test if field is morphed				*/
/*  (returns)	: bool		: Morphed				*/

bool	KBField::isMorphing ()
{
	return	morph.getBoolValue() ;
}

/*  KBField								*/
/*  replicate	: Replicate this field					*/
/*  _parent	: KBNode *	: Parent of replicant			*/
/*  (returns)	: KBNode *	: New field node			*/

KBNode	*KBField::replicate
	(	KBNode	*_parent
	)
{
	return	new KBField (_parent, this) ;
}

/*  KBField								*/
/*  doLeave	: Handle focus exit					*/
/*  qrow	: uint		: Query row				*/
/*  (returns)	: bool		: OK to leave				*/

bool	KBField::doLeave
	(	uint	qrow
	)
{
	/* Handle the onChange event here since we don't do it on a	*/
	/* keystroke by keystroke basis.				*/
	if (getValue(qrow) != getIniValue(qrow))
	{
		KBValue	args[2]	;
		bool	evRc	;

		args[0] = (int)qrow	 ;
		args[1] = getValue (qrow);

		eventHook (onChange, 2, args, evRc) ;
	}

	return	KBItem::doLeave (qrow) ;
}

/*  KBField								*/
/*  doSearch	: Do record search					*/
/*  (returns)	: void		:					*/

void	KBField::doSearch ()
{
	KBFindTextDlg findDlg (getFormBlock(), this) ;
	findDlg.exec () ;

}


#if	! __KB_RUNTIME
/*  KBField								*/
/*  propertyDlg	: Show property dialog					*/
/*  iniAttr	: cchar *	: Initial attribute			*/
/*  (returns)	: bool		: Success				*/

bool	KBField::propertyDlg
	(	cchar	*iniAttr
	)
{
	if (!::fieldPropDlg (this, "Field", attribs, iniAttr)) return false ;

	updateProps ()	;
	return true     ;
}
#endif

NEWNODE(Field, __TR("New &Field"), KF_FORM|KF_REPORT|KF_BLOCK|KF_DATA)
