/***************************************************************************
    file	         : kb_fielddlg.cpp
    copyright            : (C) 1999,2000,2001,2002,2003 by Mike Richardson
			   (C) 2000,2001,2002,2003 by theKompany.com
			   (C) 2001,2002,2003 by John Dean
    license              : This file is released under the terms of
                           the GNU General Public License, version 2. The
                           copyright holders retain the right to release
                           this code under diffenent non-exclusive licences.
    email                : mike@quaking.demon.co.uk                                     
 ***************************************************************************/

#include	<stdio.h>

#include	<qframe.h>
#include	<qmessagebox.h>
#include	<qregexp.h>

#include	"kb_classes.h"
#include	"kb_type.h"
#include	"kb_value.h"
#include	"kb_location.h"

#include	"kb_attr.h"
#include	"kb_dbinfo.h"
#include	"kb_qrybase.h"
#include	"kb_block.h"
#include	"kb_field.h"

#include	"kb_formatdlg.h"

#ifndef 	_WIN32
#include 	"kb_fielddlg.moc"
#else
#include 	"kb_fielddlg.h"
#endif

#include	"tk_messagebox.h"


/*  KBFieldPropDlg							*/
/*  KBFieldPropDlg: Constructor for block properties dialog		*/
/*  field	  : KBField *	  : Parent field			*/
/*  caption	  : const char *  : Dialog box caption			*/
/*  attribs	  : QList<KBAttr>&: List of attributes			*/
/*  apply	  : bool	  : Show apply button			*/
/*  iniAttr	  : cchar *	  : Initial attribute			*/
/*  (returns)	  : KBFieldPropDlg:					*/

KBFieldPropDlg::KBFieldPropDlg
	(	KBField		*field,
		cchar		*caption,
		QList<KBAttr>	&attribs,
		cchar		*iniAttr
	)
	:
	KBItemPropDlg	(field, caption, attribs, iniAttr),
	fDialog		(&topWidget),
	field		(field)
{
	fDialog.hide () ;
}

/*  KBFieldPropDlg							*/
/*  ~KBFieldPropDlg: Destructor for block properties dialog		*/
/*  (returns)	   : void	:					*/

KBFieldPropDlg::~KBFieldPropDlg ()
{
}

/*  KBFieldPropDlg							*/
/*  showProperty: Show property						*/
/*  item	: KBAttrItem *	: Associated item			*/
/*  (returns)	: bool		: Property on show			*/

bool	KBFieldPropDlg::showProperty
	(	KBAttrItem	*item
	)
{
	const QString	&aName	= item->attr()->getName () ;

	/* For format, show the format type and specification list	*/
	/* boxes. We have a look at the field type to give a hint as	*/
	/* to the appropriate types of format.				*/
	if (aName == "format")
	{
		const QString	&display = getProperty ("expr") ;
		uint		qlvl	 ;
		KBQryBase	*query	 ;

		if ((query = getBlockQuery(qlvl)) == 0) return false ;

		if (!fDialog.showFormats (item->value(), display, query, qlvl))
			return false ;

		setUserWidget (&fDialog) ;

		return	true	;
	}

	return	KBItemPropDlg::showProperty (item) ;
}

/*  KBFieldPropDlg							*/
/*  saveProperty: Check and save attribute				*/
/*  item	: KBAttrItem *	: Associated item			*/
/*  (returns)	: bool		: Attribute OK				*/

bool	KBFieldPropDlg::saveProperty
	(	KBAttrItem	*item
	)
{
	const QString	&aName = item->attr()->getName () ;

	/* Validity expression						*/
	/* Check that this compiles as a valid (extended) regular	*/
	/* expression.							*/
	if (aName == "evalid")
	{
		QString	 v = editBox.text() ;

		if (v.isEmpty())
		{
			setProperty (aName,  v) ;
			return	true		;
		}

		if (!QRegExp(v).isValid())
		{
			TKMessageBox::sorry
			(	0,
				"Validator error",
				"The validator is not a valid regular expression"
			)	;
			return	false	;
		}

		setProperty (aName,  v) ;
		return	true	;
	}

	/* In the case of the format specification, we need to stitch	*/
	/* together the type and the specification itself.		*/
	if (aName == "format")
	{
		setProperty (aName, fDialog.getValue()) ;
		return	true	;
	}

	return	KBItemPropDlg::saveProperty (item) ;
}

/*  fieldPropDlg  : Run the field properties dialog			*/
/*  field	  : KBField *	  : Parent field			*/
/*  caption	  : const char *  : Dialog box caption			*/
/*  attribs	  : QList<KBAttr>&: List of attributes			*/
/*  iniAttr	  : cchar *	  : Initial attribute			*/
/*  (returns)	  : bool	  : Success				*/

bool LIBKBASE_API fieldPropDlg
	(	KBField		*field,
		cchar		*caption,
		QList<KBAttr>	&attribs,
		cchar		*iniAttr
	)
{
	KBFieldPropDlg fDlg (field, caption, attribs, iniAttr) ;
	return	fDlg.exec () ;
}
