/***************************************************************************
    file	         : kb_formatdlg.h
    copyright            : (C) 1999,2000,2001,2002,2003 by Mike Richardson
			   (C) 2000,2001,2002,2003 by theKompany.com
			   (C) 2001,2002,2003 by John Dean
    license              : This file is released under the terms of
                           the GNU General Public License, version 2. The
                           copyright holders retain the right to release
                           this code under diffenent non-exclusive licences.
    email                : mike@quaking.demon.co.uk                                     
 ***************************************************************************/

#ifndef	_KB_FORMAT_H
#define	_KB_FORMAT_H

#include	<qlayout.h>
#include	<qlistview.h>
#include	<qlistbox.h>
#include	<qcheckbox.h>

#include	"libkbase_exports.h"

#include	"kb_classes.h"
#include	"tk_lineedit.h"

struct	LIBKBASE_API	aFormat
{
	cchar	*descr	;
	cchar	*example;
	cchar	*format	;
}	;

/*  KBFormatDlg								*/
/*  -----------								*/
/*  This class contains the functionality needed to handle format	*/
/*  selection in a dialog box. It is used with, for instance, the Field	*/
/*  and Data control dialogs.						*/

class	LIBKBASE_API	KBFormatDlg : public QWidget
{
	Q_OBJECT

	QWidget		*parent		;
	QVBoxLayout	vLayBox		;
	QHBoxLayout	hLayBox		;
	TKLineEdit	eBox		;
	QListBox	types		;
	QListView	formats		;
	QCheckBox	m_forced	;

	void		loadFormats 	(aFormat *) ;

private slots :

	void		selectType	(const QString &) ;
	void		selectFormat	(QListViewItem *) ;


public	:

	KBFormatDlg	(QWidget *) ;

	bool		showFormats	(const QString &, KB::IType) ;
	bool		showFormats	(const QString &, const QString &, KBQryBase *, uint) ;

	inline	QString	getValue	()
	{
		return	QString("%1%2:%3")
				.arg(m_forced.isChecked() ? "!" : "")
				.arg(types.currentText())
				.arg(eBox.text())
				;
	}
}	;

LIBKBASE_API	struct	aFormat	*getDateFormat		() ;
LIBKBASE_API	struct	aFormat	*getTimeFormat		() ;
LIBKBASE_API	struct	aFormat	*getDateTimeFormat	() ;

#endif	// _KB_FORMAT_H
