/***************************************************************************
    file	         : kb_grid.cpp
    copyright            : (C) 1999,2000,2001,2002,2003 by Mike Richardson
			   (C) 2000,2001,2002,2003 by theKompany.com
			   (C) 2001,2002,2003 by John Dean
    license              : This file is released under the terms of
                           the GNU General Public License, version 2. The
                           copyright holders retain the right to release
                           this code under diffenent non-exclusive licences.
    email                : mike@quaking.demon.co.uk                                     
 ***************************************************************************/

#include	<stdio.h>
#include	<stdlib.h>

#include	<qapplication.h>
#include	<qlist.h>
#include	<qstring.h>
#include	<qframe.h>
#include	<qlabel.h>
#include	<qpopupmenu.h>
#include	<qpainter.h>
#include	<qscrollview.h>

#include	"kb_classes.h"
#include	"kb_type.h"
#include	"kb_value.h"
#include	"kb_location.h"

#include	"kb_sizer.h"
#include	"kb_display.h"
#include	"kb_ctrl.h"

#include	"kb_formblock.h"
#include	"kb_grid.h"
#include	"kb_qtgrid.h"
#include	"kb_nodereg.h"
#include	"kb_writer.h"
#include	"kb_layout.h"

#include	"kb_sorter.h"

/*  KBGrid								*/
/*  KBGrid	: Consructor for grid header node			*/
/*  parent	: KBNode *	: Parent node				*/
/*  aList	: const QDict<QString> &				*/
/*				: List of attributes			*/
/*  ok		: bool *	: Success				*/
/*  (returns)	: KBGrid	:					*/

KBGrid::KBGrid
	(	KBNode			*parent,
		const QDict<QString>	&aList,
		bool			*ok
	)
	:
	KBObject	(parent, "KBGrid", 	aList),
	m_nosort	(this,	 "nosort",	aList)
{
	m_grid		= 0 	;
	m_sortCol	= -1	;
	m_sortAsc	= true	;

#if	! __KB_RUNTIME
	if (ok != 0)
	{
		if (!KBNode::propertyDlg ("Grid"))
		{	delete this	;
			*ok	= false ;
			return	    ;
		}

		*ok	= true	;
	}
#endif
}

/*  KBGrid								*/
/*  KBGrid	: Consructor for label node				*/
/*  _parent	: KBNode *	: Parent node				*/
/*  _grid	: KBGrid *	: Extant grid header			*/
/*  (returns)	: KBGrid	:					*/

KBGrid::KBGrid
	(	KBNode		*_parent,
		KBGrid		*_grid
	)
	:
	KBObject	(_parent,		_grid),
	m_nosort	(this,	 "nosort",	_grid)
{
	m_grid		= 0	;
	m_sortCol	= -1	;
	m_sortAsc 	= true	;
}

/*  KBGrid								*/
/*  ~KBGrid	: Desructor for label node				*/
/*  (returns)	:		:					*/

KBGrid::~KBGrid ()
{
//	fprintf	(stderr, "Delete grid:\n") ;
}

/*  KBGrid								*/
/*  replicate	: Replicate this grid header				*/
/*  _parent	: KBNode *	: Parent of replicant			*/
/*  (returns)	: KBNode *	: New grid header node			*/

KBNode	*KBGrid::replicate
	(	KBNode	*_parent
	)
{
	return	replicateBelow (new KBGrid (_parent, this)) ;
}

/*  KBGrid								*/
/*  buildCtrls	: Build controle for this node				*/
/*  numrows	: uint		: Number of rows to be displayed	*/
/*  dx		: int		: X offset between rows			*/
/*  dy		: int		: Y offset between rows			*/
/*  (returns)	: void		:					*/

void	KBGrid::buildCtrls
	(	uint		numrows,
		int		dx,
		int		dy
	)
{
	KBObject::buildCtrls (numrows, dx, dy) ;

	if (m_grid == 0)
	{
		m_grid	= new KBCtrlGrid (getDisplay(), this) ;
		setControl (m_grid)  ;
	}

	m_grid->KBControl::setGeometry (geometry()) ; 
	m_grid->setVisible	       (true) ;
	m_grid->setClickEnabled	       (!m_nosort.getBoolValue()) ;
}

/*  KBGrid								*/
/*  clearItems	: Clear all items from grid				*/
/*  all		: bool		: Clear all items list as well		*/
/*  (returns)	: void		:					*/

void	KBGrid::clearItems
	(	bool	all
	)
{
	if (m_grid != 0) m_grid->clearLabels () ;
	if (all	       ) m_allItems.clear    () ;

	m_visItems.clear () ;
}

/*  KBGrid								*/
/*  appendItem	: Append a new item to the grid				*/
/*  item	: KBItem *	: Item to be appended			*/
/*  all		: bool		: Add to all items list as well		*/
/*  (returns)	: void		:					*/

void	KBGrid::appendItem
	(	KBItem		*item,
		bool		all
	)
{
	if (m_grid != 0)
	{
		if (all) m_allItems.append (item) ;

		m_grid->appendLabel
		(	item ->getName  (),
			item ->geometry ().width(),
			!item->isRowMark()
		)	;
		m_visItems.append (item) ;
	}
}

/*  KBGrid								*/
/*  adjustItems	: Adjust item positions and sizes			*/
/*  section	: int		: Staring section number		*/
/*  (returns)	: void		:					*/

void	KBGrid::adjustItems
	(	int	section
	)
{
	QRect	r	= geometry () ;
	int	left	= r.x	   () ;
	int	gwidth	= r.width  () ;
	int	awidth	= 0 ;
	
	int	index	= m_grid->mapToIndex (section) ;

//	fprintf	(stderr, "KBGrid::adjustItems: %d -> %d\n", section, index) ;

	if (index < 0) return ;

	/* If we are embedded in a top-level block then we will resize	*/
	/* the scroller contents to  the grid width (and a bit ...:)	*/
	QScrollView *scroller	= getDisplay()->getScroller() ;
	if (scroller != 0) gwidth = 0x7fffffff ;

	/* Adjust the items corresponding to the altered section and	*/
	/* all to its right (ie., greater indexes).			*/
	while (index < (int)m_visItems.count())
	{
		int	section	= m_grid->mapToSection(index  ) ;
		int	pos	= m_grid->sectionPos  (section) ;
		int	size	= m_grid->sectionSize (section) ;
		KBItem	*item	= m_visItems.at  (index) ;
		QRect	ig	= item->geometry () ;

		/* Prevent the right-hand edge of the section going	*/
		/* outside the maximum width of the header widget width	*/
		if (pos + size > gwidth)
			if ((size = gwidth - pos) < 0)
				size = 0 ; 

//		fprintf
//		(	stderr,
//			"%3d [%-12s] -> (%d,%d)\n",
//			index,
//			(cchar *)item->getAttrVal("name"),
//			left + pos,
//			size
//		)	;

		item->setGeometry (QRect(left + pos, ig.y(), size, ig.height())) ;
		item->reposition  () ;

		awidth	= pos + size ;
		index  += 1	     ;
	}


	if ((awidth > 0) && (scroller != 0))
		scroller->resizeContents (awidth + left + 0 + 8, scroller->contentsHeight()) ;

	if (awidth > 0)
		if (scroller == 0)
			m_grid->resize (awidth + 0 + 8, m_grid->size().height()) ;
		else	        resize (awidth + 0 + 8, m_grid->size().height()) ;
}

/*  KBGrid								*/
/*  sizeChange	: Handle size change from grid header			*/
/*  section	: int		: Section number			*/
/*  oldSize	: int		: Original size				*/
/*  newSize	: int		: New size				*/
/*  (returns)	: void		:					*/

void	KBGrid::sizeChange
	(	int	section,
		int	,
		int	
	)
{
	adjustItems (section) ;
}

/*  KBGrid								*/
/*  indexChange	: Handle reordering from grid header			*/
/*  section	: int		: Section number			*/
/*  fromIndex	: int		: Index moved from ...			*/
/*  toIndex	: int		: ... and to				*/
/*  (returns)	: void		:					*/

void	KBGrid::indexChange
	(	int	,
		int	fromIndex,
		int	toIndex
	)
{
	/* Determine the section number for the left-hand most position	*/
	/* and adjust the items from this one onwards. We also move	*/
	/* the item to keep the visible item list in display order.	*/
	KBItem	*item	= m_visItems.take (fromIndex) ;
	int	lower	= fromIndex < toIndex ? fromIndex : toIndex ;

	m_visItems.insert (toIndex > fromIndex ? toIndex - 1 : toIndex, item) ;
	adjustItems  	  (m_grid->mapToSection (lower)) ;

	for (uint index = 0 ; index < m_visItems.count() ; index += 1)
	{
		KBItem	*item	= m_visItems.at (index)  ;

		if (item->getTabOrder () != 0)
			item->setTabOrder (index + 1) ;

//		fprintf
//		(	stderr,
//			"%3d: %s\n",
//			index,
//			(cchar *)item->getAttrVal("name")
//		)	;
	}

	KBNavigator *navi = getNavigator() ;
	if (navi != 0) navi->fixTabOrder() ;
}


/*  KBGrid								*/
/*  getItems	: Get list of items					*/
/*  ilist	: QList<KBItem> & : List of items			*/
/*  (returns)	: void		  :					*/

void	KBGrid::getItems
	(	QList<KBItem>	&ilist
	)
{
	for (uint idx = 0 ; idx < m_allItems.count() ; idx += 1)
		ilist.append (m_allItems.at(idx)) ;
}

/*  KBGrid								*/
/*  setOrder	: Set columns in specified order			*/
/*  ilist	: QList<KBItem> & : Order list				*/
/*  (returns)	: void		  :					*/

void	KBGrid::setOrder
	(	QList<KBItem>	&ilist
	)
{
	/* This is potentially dangerous, so check the arguments quite	*/
	/* carefully; make sure that exactly the same set of items is	*/
	/* passed as we already have.					*/
	if (ilist.count() != m_visItems.count())
	{
		KBError::EError
		(	TR("Grid ordering error"),
			TR("Incorrect number of grid items passed"),
			__ERRLOCN
		)	;
		return	;
	}

	LITER
	(	KBItem,
		ilist,
		item,

		if (m_visItems.find (item) < 0)
		{
			KBError::EError
			(	TR("Grid ordering error"),
				TR("Unexpected item specified"),
				__ERRLOCN
			)	;
			return	;
		}
	)

	LITER
	(	KBItem,
		m_visItems,
		item,

		if (ilist.find (item) < 0)
		{
			KBError::EError
			(	TR("Grid ordering error"),
				TR("Grid item not specified"),
				__ERRLOCN
			)	;
			return	;
		}
	)

	clearItems () ;

	for (uint idx = 0 ; idx < ilist.count() ; idx += 1)
	{
		KBItem	*item	= ilist.at(idx) ;
		appendItem (item) ;

		if (item->getTabOrder () != 0)
			item->setTabOrder (idx + 1) ;
	}

	adjustItems (0) ;

	KBNavigator *navi = getNavigator() ;
	if (navi != 0) navi->fixTabOrder() ;
}

/*  KBGrid								*/
/*  setColumnWidth: Set width of specified column			*/
/*  item	  : KBItem *	: Item correspoinding to column		*/
/*  width	  : uint	: Required width			*/
/*  (returns)	  : void		:				*/

void	KBGrid::setColumnWidth
	(	KBItem	*item,
		uint	width
	)
{
	if (width == 0) return ;
	int	idx	= m_visItems.find (item) ;
	if (idx   <   0) return ;
	int	sect	= m_grid->mapToSection(idx) ;

	m_grid->resizeSection (sect, width) ;
	adjustItems (sect) ;
}

/*  KBGrid								*/
/*  columnClicked: Hanle user column clock for sorting			*/
/*  colNo	 : int		: Column number				*/
/*  (returns)	 : void		:					*/

void	KBGrid::columnClicked
	(	int	colNo
	)
{
	if (m_sortCol != colNo)
	{
		m_sortCol = colNo	;
		m_sortAsc = true	;
	}
	else	m_sortAsc = !m_sortAsc	;

	columnSort () ;
}

/*  KBGrid								*/
/*  columnSort	: Sort by column if required				*/
/*  (returns)	: void		:					*/

void	KBGrid::columnSort ()
{
	if ((m_sortCol >= 0) && (m_sortCol < (int)m_visItems.count()))
	{
		getFormBlock()->sortByColumn (m_visItems.at(m_sortCol), m_sortAsc) ;
		m_grid->setSortIndicator (m_sortCol, m_sortAsc) ;
	}
}

/*  KBGrid								*/
/*  resetSort	: Reset ordering					*/
/*  (returns)	: void		:					*/

void	KBGrid::resetSort ()
{
	m_sortCol = -1	 ;
	m_sortAsc = true ;
	m_grid->setSortIndicator (-1) ;
}

/*  KBGrid								*/
/*  showAs	: Switch in or out of design mode			*/
/*  mode	: KB::ShowAs	: Design mode				*/
/*  (returns)	: void		:					*/

void	KBGrid::showAs
	(	KB::ShowAs	_showAs
	)
{
	/* Clear the default tab order list as the tab order may have	*/
	/* changed while in design mode.				*/
	KBObject::showAs  (_showAs) ;
	m_defTabOrder.clear () ;
}

/*  KBGrid								*/
/*  orderByExpr	: Order columns by expression (or not ...)		*/
/*  byExp	: bool		: True to order by expression		*/
/*  (returns)	: void		:					*/

void	KBGrid::orderByExpr
	(	bool	byExpr
	)
{
	/* If there is only a single column then there is nothing to	*/
	/* reorder ....							*/
	if (m_visItems.count() <= 1)
		return	;

	/* If the default tab order list is empty, then this is the	*/
	/* first call (maybe since leaving design mode), in which case	*/
	/* record the tab order - an int dictionary is a convenient way	*/
	if (m_defTabOrder.count() == 0)
		LITER
		(	KBItem,
			m_visItems,
			i,
			m_defTabOrder.insert (i->getTabOrder(), i)
		)

	/* Now get a list of items orders by expression or by default	*/
	/* tab order. We use a sorter list in either case. For order	*/
	/* by expression we insert labelled with the expression; for	*/
	/* tab order label with the tab order (fixed so that lexical	*/
	/* ordering gives the right result.				*/
	KBSorter<KBItem> sorter ;

	if (byExpr)
	{
		LITER
		(	KBItem,
			m_visItems,
			item,
			sorter.append (item->getAttrVal("expr"), item)
		)
	}
	else
	{
		QIntDictIterator<KBItem> iter (m_defTabOrder) ;
		KBItem	*item ;

		while ((item = iter.current()) != 0)
		{
			sorter.append (QString().sprintf("%04ld", iter.currentKey()), item) ;
			iter	+= 1 ;
		}
	}

	sorter.sort () ;

	/* Clear the items list and reinsert the items in the new	*/
	/* order, and adjust the column widths to match. The item tab	*/
	/* order values are updated .....				*/
	clearItems () ;


	for (uint idx = 0 ; idx < sorter.count() ; idx += 1)
	{
		KBItem	*item	= sorter.at(idx) ;
		appendItem (item) ;

		if (item->getTabOrder () != 0)
			item->setTabOrder (idx + 1) ;
	}

	adjustItems (0) ;

	/* ... and then we fix up the tab order so that we get		*/
	/* left-to-right tabbing.					*/
	KBNavigator *navi = getNavigator() ;
	if (navi != 0) navi->fixTabOrder() ;
}

/*  KBGrid								*/
/*  setItemsVisible							*/
/*		: Show or hide columns					*/
/*  visible	: QValueList<bool> : Column visibility flags		*/
/*  pack	: bool		   : Pack down visible columns		*/
/*  (returns)	: void		   :					*/

void	KBGrid::setItemsVisible
	(	QValueList<bool> &visible,
		bool
	)
{
	clearItems () ;

	for (uint slot = 0 ; slot < m_allItems.count() ; slot += 1)
	{
		KBItem	*item	= m_allItems.at(slot) ;
		bool	vis	= visible[slot]	      ;

		item->setAllVisible (vis ) ;
		if (vis) appendItem (item) ;
	}

	adjustItems (0) ;
}

/*  KBGrid								*/
/*  setItemsEnabled							*/
/*		: Enable or disable columns				*/
/*  enabled	: QValueList<bool> : Column enable flags		*/
/*  (returns)	: void		   :					*/

void	KBGrid::setItemsEnabled
	(	QValueList<bool> &enabled
	)
{
	for (uint slot = 0 ; slot < m_allItems.count() ; slot += 1)
		m_allItems.at(slot)->setAllEnabled (enabled[slot]) ;
}

#if	! __KB_RUNTIME

/*  KBGrid								*/
/*  propertyDlg	: Show property dialog					*/
/*  iniAttr	: cchar *	: Initial attribute			*/
/*  (returns)	: bool		: Success				*/

bool	KBGrid::propertyDlg
	(	cchar	*iniAttr
	)
{
	if (!KBNode::propertyDlg ("Grid Header", iniAttr)) return false ;

	m_grid->KBControl::setGeometry
	(	QRect
		(	0,
			0,
			getBlock()->geometry().width(),
			geometry().height()
	)	)	; 

	m_grid->setClickEnabled (!m_nosort.getBoolValue()) ;

	setChanged () ;
	getLayout  ()->addSizer (getSizer(), false) ;

	return	true  ;
}
#endif

NEWNODE(Grid, (cchar *)0, KF_FORM|KF_BLOCK|KF_STATIC)
