/***************************************************************************
    file	         : kb_labelskipdlg.cpp
    copyright            : (C)	1999,2000,2001,2002,2003,2004,2005
				 by Mike Richardson
			   (C)	2001,2002,2003,2004,2005
				by John Dean
    license              : This file is released under the terms of
                           the GNU General Public License, version 2. The
                           copyright holders retain the right to release
                           this code under diffenent non-exclusive licences.
    email                : mike@quaking.demon.co.uk                                     
 ***************************************************************************/

#include	<qlabel.h>
#include	<qcheckbox.h>
#include	<qspinbox.h>
#include	<qpainter.h>
#include	<qlayout.h>
#include	<qgroupbox.h>
#include	<qpushbutton.h>


#include	"kb_classes.h"

#ifdef		_WIN32
#include	"kb_labelskipdlg.h"
#else
#include	"kb_labelskipdlg.moc"
#endif


class	KBLabelSkipSampler : public QWidget
{
	uint		m_cols		;
	uint		m_rows		;
	bool		m_borders	;
	uint		m_skip		;

protected :

	virtual	void	paintEvent	(QPaintEvent *) ;

public	:

	KBLabelSkipSampler		(QWidget *, uint, uint, bool) ;

	void		setBorders	(bool)	;
	void		setSkipOver	(uint)	;
}	;

KBLabelSkipSampler::KBLabelSkipSampler
	(	QWidget		*parent,
		uint		cols,
		uint		rows,
		bool		borders
	)
	:
	QWidget		(parent),
	m_cols		(cols),
	m_rows		(rows),
	m_borders	(borders)
{
	m_skip	= 0 ;
	setMinimumSize (200, 200) ;
}

void	KBLabelSkipSampler::setBorders
	(	bool		borders
	)
{
	m_borders = borders ;
	update  () ;
}

void	KBLabelSkipSampler::setSkipOver
	(	uint		skip
	)
{
	m_skip	= skip	;
	update	()	;
}


void	KBLabelSkipSampler::paintEvent
	(	QPaintEvent	*e
	)
{
	QPainter p (this) ;

	p.fillRect
	(	0,
		0,
		width (),
		height(),
		QBrush(Qt::gray)
	)	;

	int	  w	= width () ;
	int	  h	= height() ;

//	if (w < 200) w = 200 ;
//	if (h < 200) h = 200 ;

	const int lm	= 10 ;
	const int tm 	= 10 ;
	const int cg	= 10 ;
	const int rg	= 10 ;
	const int cw	= (w - (lm * 2) - (cg * (m_cols - 1))) / m_cols ;
	const int rh	= (h - (tm * 2) - (rg * (m_rows - 1))) / m_rows ;

	p.setPen   (Qt::black) ;
	p.setFont  (QFont("Times", 8)) ;

	static	int lh = -1 ;
	if (lh < 0)
		lh = QFontMetrics(QFont("Times", 8)).height() ;

	uint  over	= 0 ;

	for (uint r = 0 ; r < m_rows ; r += 1)
		for (uint c = 0 ; c < m_cols ; c += 1)
		{
			QRect	rect
			(	lm + c * (cw + cg),
				tm + r * (rh + rg),
				cw,
				rh
			)	;

			p.fillRect (rect, QBrush(Qt::white)) ;

			if (m_borders)
				p.drawRect (rect) ;

			if (over >= m_skip)
				p.drawText
				(	rect.topLeft() + QPoint(5, lh),
					QString(TR("Blah %1")).arg(over - m_skip + 1)
				)	;

			over	+= 1	;
		}
}


KBLabelSkipDlg::KBLabelSkipDlg
	(	bool		borders,
		uint		cols,
		uint		rows
	)
	:
	_KBDialog	(TR("Label skipping and borders"), true)
{
	fprintf
	(	stderr,
		"KBLabelSkipDlg::KBLabelSkipDlg: b=%d (%d,%d)\n",
		borders,
		cols,
		rows
	)	;

	QVBoxLayout	*lay1	= new QVBoxLayout (this) ;
	QHBoxLayout	*lay2	= new QHBoxLayout (lay1) ;
	QHBoxLayout	*lay3	= new QHBoxLayout (lay1) ;

	QGroupBox	*grp	= new QGroupBox	  (2, Qt::Horizontal, this) ;
	m_sampler	= new KBLabelSkipSampler  (this, cols, rows, borders) ;

	lay2->addWidget (grp) ;
	lay2->addWidget (m_sampler) ;

	QLabel	*l1	= new QLabel (TR("Draw label borders"), grp)	;
	m_borders	= new QCheckBox (grp) ;
	QLabel	*l2	= new QLabel (TR("Skip over labels"),   grp)	;
	m_skipover	= new QSpinBox	(0, rows * cols - 1, 1, grp)	;

	QPushButton *ok		= new QPushButton(TR("OK"),     this)	;
	QPushButton *cancel	= new QPushButton(TR("Cancel"), this)	;
	lay3->addStretch() ;
	lay3->addWidget (ok) ;
	lay3->addWidget (cancel) ;

	connect	(ok,     SIGNAL(clicked()), SLOT(accept())) ;
	connect	(cancel, SIGNAL(clicked()), SLOT(reject())) ;

	m_borders ->setChecked	(borders) ;
	m_skipover->setValue	(0)	  ;

	connect
	(	m_borders,
		SIGNAL	(toggled	(bool)),
		SLOT	(bordersChanged	())
	)	;
	connect
	(	m_skipover,
		SIGNAL	(valueChanged	(int)),
		SLOT	(skipOverChanged())
	)	;
}

void	KBLabelSkipDlg::bordersChanged ()
{
	m_sampler->setBorders	(m_borders->isChecked()) ;
}

void	KBLabelSkipDlg::skipOverChanged ()
{
	m_sampler->setSkipOver	(m_skipover->value()) ;
}

bool	KBLabelSkipDlg::borders ()
{
	return	m_borders->isChecked () ;
}

uint	KBLabelSkipDlg::skipOver ()
{
	return	m_skipover->value () ;
}
