/***************************************************************************
    file	         : kb_module.cpp
    copyright            : (C) 1999,2000,2001,2002,2003 by Mike Richardson
			   (C) 2000,2001,2002,2003 by theKompany.com
			   (C) 2001,2002,2003 by John Dean
    license              : This file is released under the terms of
                           the GNU General Public License, version 2. The
                           copyright holders retain the right to release
                           this code under diffenent non-exclusive licences.
    email                : mike@quaking.demon.co.uk                                     
 ***************************************************************************/

#include	"kb_module.h"

/*  KBModule								*/
/*  KBModule	: Constructor for script node				*/
/*  parent	: KBNode *	: Parent node				*/
/*  element	: cchar *	: Element name				*/
/*  aList	: const QDict<QString> &				*/
/*				: Attribute list			*/
/*		: uint *	:					*/
/*		: bool *	:					*/
/*  (returns)	: KBModule	:					*/

KBModule::KBModule
	(	KBNode			*parent,
		cchar			*element,
		const QDict<QString>	&aList,
		uint			*,
		bool			*
	)
	:
	KBNode	(parent, element),
	module	(this,	 "module",	aList)	
{
}

/*  KBModule								*/
/*  KBModule	: Constructor for script node				*/
/*  parent	: KBNode *	: Parent node				*/
/*  element	: cchar *	: Element name				*/
/*  name	: cchar *	: Module name				*/
/*  (returns)	: KBModule	:					*/

KBModule::KBModule
	(	KBNode		*parent,
		cchar		*element,
		cchar		*name
	)
	:
	KBNode	(parent, element),
	module	(this,	 "module",	name)	
{
}


/*  KBModule								*/
/*  KBModule	: Constructor for script node				*/
/*  parent	: KBNode *	: Parent node				*/
/*  element	: cchar *	: Element name				*/
/*  extant	: KBModule *	: Extant module				*/
/*  (returns)	: KBModule	:					*/

KBModule::KBModule
	(	KBNode		*parent,
		cchar		*element,
		KBModule	*extant
	)
	:
	KBNode	(parent, element),
	module	(this,	 "module",	extant)	
{
}


/*  KBModule								*/
/*  ~KBModule	: Destructor for script node				*/
/*  (returns)	:		:					*/

KBModule::~KBModule ()
{
}

