/***************************************************************************
    file	         : kb_moduleitem.cpp
    copyright            : (C) 1999,2000,2001,2002,2003 by Mike Richardson
			   (C) 2000,2001,2002,2003 by theKompany.com
			   (C) 2001,2002,2003 by John Dean
    license              : This file is released under the terms of
                           the GNU General Public License, version 2. The
                           copyright holders retain the right to release
                           this code under diffenent non-exclusive licences.
    email                : mike@quaking.demon.co.uk                                     
 ***************************************************************************/

#ifndef 	_WIN32
#include	"kb_moduleitem.moc"
#else
#include	"kb_moduleitem.h"
#endif

#include	"kb_module.h"

/*  KBModuleItem							*/
/*  KBModuleItem: Constructor for extant module item			*/
/*  listBox	: QListBox *	: Display listbox			*/
/*  module	: KBModule *	: Module				*/
/*  (returns)	: KBModuleItem	:					*/

KBModuleItem::KBModuleItem
	(	QListBox	*listBox,
		KBModule	*module
	)
	:
	QListBoxText (listBox, module->getModuleName()),
	module	     (module)
{
}

/*  KBModuleItem							*/
/*  KBModuleItem: Constructor for new module item			*/
/*  listBox	: QListBox *	: Display listbox			*/
/*  module	: const QString&: Module name				*/
/*  (returns)	: KBModuleItem	:					*/

KBModuleItem::KBModuleItem
	(	QListBox	*listBox,
		const QString	&name
	)
	:
	QListBoxText (listBox, name),
	module	     (0)
{
}

/*  KBModuleItem							*/
/*  KBModuleItem: Destructor for module item				*/
/*  (returns)	:		:					*/

KBModuleItem::~KBModuleItem ()
{
}

/*  KBModuleItem							*/
/*  fixUp	: Fix up script item on dialog acceptance		*/
/*  root	: KBNode *	  : Owning root block			*/
/*  (returns)	: void		  :					*/

void	KBModuleItem::fixUp
	(	KBNode	*node
	)
{
	if (module == 0) module = makeModule (node, text()) ;
}


/*  ------------------------------------------------------------------  */

/*  KBModuleDlg								*/
/*  KBModuleDlg	: Module dialog constructor				*/
/*  parent	: QWidget *	    : Parent widget			*/
/*  node	: KBNode *	    : Parent node			*/
/*  (returns)	: KBModuleDlg	    :					*/

KBModuleDlg::KBModuleDlg
	(	QWidget		*parent,
		KBNode		*node
	)
	:
	QWidget	(parent),
	hLayout	(this),
	vLayout	(&hLayout),
	bLayout	(&vLayout),
	vModules(this),
	eModule	(this),
	bAdd	(this),
	bRemove	(this),
	node	(node)
{
	hLayout.setMargin (8) ;
	vLayout.setMargin (8) ;
	bLayout.setMargin (8) ;

	hLayout.addWidget	(&vModules) ;

	vLayout.setDirection	(QBoxLayout::BottomToTop) ;
	vLayout.addWidget	(&eModule ) ;

	bLayout.addStretch	()	    ;
	bLayout.addWidget	(&bAdd    ) ;
	bLayout.addWidget	(&bRemove ) ;

	bAdd   .setText   (TR("Add >>"   )) ;
	bRemove.setText   (TR("<< Remove")) ;
	bRemove.setEnabled(false)	;
	
	connect	(&bAdd,     SIGNAL(clicked()), SLOT(clickAdd   ())) ;
	connect	(&bRemove,  SIGNAL(clicked()), SLOT(clickRemove())) ;
	connect (&vModules, SIGNAL(highlighted(int)),
			    SLOT  (highlighted(int))) ;
}

/*  KBModuleDlg								*/
/*  ~KBModuleDlg: Module dialog destructor				*/
/*  (returns)	:		:					*/

KBModuleDlg::~KBModuleDlg ()
{
}

/*  KBModuleDlg								*/
/*  setModules	: Set list of extant modules				*/
/*  modules	: QList<KBModule> & : List of extant modules		*/
/*  (returns)	: void		    :					*/

void	KBModuleDlg::setModules
	(	QList<KBModule>	&modules
	)
{
	LITER
	(	KBModule,
		modules,
		m,
		makeModuleItem (&vModules, m)
	)
}

/*  KBModuleDlg:							*/
/*  clickAdd	 : Handle click of add button				*/
/*  (returns)	 : void		:					*/

void	KBModuleDlg::clickAdd ()
{
	if (!eModule.text().isEmpty())
	{	KBModuleItem *item = makeModuleItem (&vModules, eModule.text()) ;
		vModules.setCurrentItem (item) ;
		eModule .clear () ;
	}
}

/*  KBModuleDlg:							*/
/*  clickRemove	 : Handle click of remove button			*/
/*  (returns)	 : void		:					*/

void	KBModuleDlg::clickRemove ()
{
	KBModuleItem	*module	;
	KBModule	*m	;

	if ((module = (KBModuleItem *)vModules.item(vModules.currentItem())) != 0)
	{
		if ((m = module->getModule()) != 0)
			dropped.append (m) ;

		vModules.removeItem (vModules.currentItem()) ;
		bRemove .setEnabled (vModules.currentItem() >= 0) ;
	}
}

/*  KBModuleDlg:							*/
/*  highlighted	 : Handle highlight of modules list entry		*/
/*  (returns)	 : void		:					*/

void	KBModuleDlg::highlighted
	(	int	index
	)
{
	bRemove .setEnabled  (true) ;
	vModules.setSelected (index, true) ;
}

/*  KBModuleDlg	:							*/
/*  fixUp	: Fix up when used OK's changes				*/
/*  (returns)	: void		:					*/

void	KBModuleDlg::fixUp ()
{
	LITER (KBModule, dropped, m, delete m) ;

	for (uint idx = 0 ; idx < vModules.count() ; idx += 1)
		((KBModuleItem *)vModules.item(idx))->fixUp (node) ;
}


QString	KBModuleDlg::getText ()
{
	QString	res	;

	for (uint idx = 0 ; idx < vModules.count() ; idx += 1)
	{	if (!res.isEmpty()) res += ", " ;
		res += vModules.text (idx) ;
	}

	return	res	;
}

