/***************************************************************************
    file	         : kb_noobjdlg.h
    copyright            : (C) 1999,2000,2001,2002,2003 by Mike Richardson
			   (C) 2000,2001,2002,2003 by theKompany.com
			   (C) 2001,2002,2003 by John Dean
    license              : This file is released under the terms of
                           the GNU General Public License, version 2. The
                           copyright holders retain the right to release
                           this code under diffenent non-exclusive licences.
    email                : mike@quaking.demon.co.uk                                     
 ***************************************************************************/

#ifndef	__KB_NOOBJDLG_H
#define	__KB_NOOBJDLG_H

#if	! __KB_RUNTIME

#include	"libkbase_exports.h"

#include	<qlist.h>
#include	<qlabel.h>
#include	<qpushbutton.h>
#include	<qlistview.h>
#include	<qcombobox.h>
#include	<qlayout.h>


#include	"kb_classes.h"
#include	"kb_attr.h"
#include	"kb_dialog.h"


class	LIBKBASE_API	KBObjTreeObject : public QListViewItem
{
	KBObject	*m_object	;
	bool		m_expanded	;
	bool		m_start		;

public	:

	KBObjTreeObject (QListView 	*, KBObject *)	;
	KBObjTreeObject (QListViewItem	*, KBObject *)	;

	virtual	void	paintCell	(QPainter *, const QColorGroup &, int, int, int) ;
	virtual	void	setOpen 	(bool)	;

	inline	KBObject *object 	() { return m_object   ; }
	inline	bool	expanded 	() { return m_expanded ; }

	inline	void	setExpanded	() { m_expanded = true ; }
	inline	void	setStart 	() { m_start	= true ; }

	static	KBObjTreeObject	*expandToObject	(QListView *, KBObject *, KBObject * = 0) ;
}	;


/*  KBNoObjDlg								*/
/*  ----------								*/
/*  This dialog is used when KBObject::getNamedObject fails to locate	*/
/*  an object and the show-error option is set. It displays a tree	*/
/*  view showing objects and their names, and has the option to allow	*/
/*  the user to pick an object and continue with it. Useful for		*/
/*  debugging.								*/

class	LIBKBASE_API	KBNoObjDlg : public _KBDialog
{
	Q_OBJECT

	QLabel		m_error		;
	QListView	m_objTree	;
	QPushButton	m_bFail		;
	QPushButton	m_bContinue	;
	KBObject	*m_selected	;

	QVBoxLayout	*m_layMain	;
	QHBoxLayout	*m_layButtons	;


protected slots :

	void		slotObjClicked	()	;
	void		slotObjSelected	()	;
	void		clickFail	()	;
public	:

	KBNoObjDlg	(KBObject *, QString)	;

	inline	KBObject *selectedObj	()
	{
		return	 m_selected	;
	}

}	;

/*  KBSlotFindDlg							*/
/*  -------------							*/
/*  This dialog is used to aid location of objects and their events	*/
/*  in the slot dialogs.						*/

class	LIBKBASE_API	KBSlotFindDlg : public _KBDialog
{
	Q_OBJECT

	QListView		m_objTree	;
	QComboBox		m_events	;
	QPushButton		m_bOK		;
	QPushButton		m_bCancel	;

	QList<KBAttr>		m_eventList	;
	KBObject		*m_selected	;

	QVBoxLayout		*m_layMain	;
	QHBoxLayout		*m_layButtons	;


protected slots :

	void		slotObjClicked	(QListViewItem *) ;
	void		clickOK		()	;
	void		clickCancel	()	;

public	:

	KBSlotFindDlg	(KBObject *, KBObject *, const QString &) ;

	KBObject	*selectedObj	(QString &) ;
}	;

/*  KBConfigFindDlg							*/
/*  ---------------							*/
/*  This dialog is used to aid location of objects and their child	*/
/*  configuration objects in the component override dialog.		*/

class	LIBKBASE_API	KBConfigFindDlg : public _KBDialog
{
	Q_OBJECT

	QListView		m_objTree	;
	QComboBox		m_configs	;
	KBObject		*m_start	;
	QPushButton		m_bOK		;
	QPushButton		m_bCancel	;

	KBObject		*m_selected	;

	QVBoxLayout		*m_layMain	;
	QHBoxLayout		*m_layButtons	;


protected slots :

	void		slotObjClicked	(QListViewItem *) ;
	void		clickOK		()	;
	void		clickCancel	()	;

public	:

	KBConfigFindDlg	(KBObject *, KBObject *, const QString &) ;

	KBObject	*selectedConfig	(QString &, QString &) ;
}	;

#endif
#endif	// __KB_NOOBJDLG_H
