/***************************************************************************
    file	         : kb_parsecomponent.cpp
    copyright            : (C) 1999,2000,2001,2002,2003 by Mike Richardson
			   (C) 2000,2001,2002,2003 by theKompany.com
			   (C) 2001,2002,2003 by John Dean
    license              : This file is released under the terms of
                           the GNU General Public License, version 2. The
                           copyright holders retain the right to release
                           this code under diffenent non-exclusive licences.
    email                : mike@quaking.demon.co.uk                                     
 ***************************************************************************/

#include	<stdio.h>
#include	<stdlib.h>
#include	<stdarg.h>

#include	<qxml.h>
#include	<qpopupmenu.h>

#include	"kb_classes.h"
#include	"kb_type.h"
#include	"kb_value.h"

#include	"kb_component.h"
#include	"kb_nodereg.h"
#include	"kb_parse.h"



/*  KBComponenthandler							*/
/*  -------------							*/
/*  Handler for parsing forms.						*/

class	LIBKBASE_API 	KBComponentHandler : public KBSAXHandler
{
	QDict<NodeSpec>	&m_nodeDict	;
	KBComponent	*m_kbComponent	;

public	:

	KBComponentHandler (KBLocation &, KBNode *, QDict<NodeSpec> &) ;

	virtual	bool	startElement	(const QString &, const QString &, const QString &, const QXmlAttributes &) ;

	KBComponent	*parseFile (const QString &) ;
	KBComponent	*parseText (QByteArray	  &) ;
}	;


/*  KBComponentHandler							*/
/*  KBComponentHandler							*/
/*		: Constructor for form parser				*/
/*  location	: KBLocation *	     : Database location		*/
/*  parent	: KBNode *	     : Initial parent node		*/
/*  nodeDict	: QDict<NodeSpec> &  : Node dictionary			*/
/*  (returns)	: KBComponentHandler :					*/

KBComponentHandler::KBComponentHandler
	(	KBLocation	&location,
		KBNode		*parent,
		QDict<NodeSpec>	&nodeDict
	)
	:
	KBSAXHandler ("component", location, parent),
	m_nodeDict   (nodeDict)
{
	m_kbComponent	= 0 ;
}

/*  KBComponentHandler							*/
/*  startElement: Handle start of element				*/
/*  URI		: const QString &	: Namespace URI			*/
/*  localName	: const QString &	:				*/
/*  qName	: const QString &	: Element name			*/
/*  attribs	: const QXmlAttributes &: Attribute list		*/
/*  (returns)	: bool			:				*/

bool	KBComponentHandler::startElement
	(	const	QString		&,
		const	QString		&,
		const	QString		&qName,
		const	QXmlAttributes	&attribs
	)
{
	/* The QXmlAttributes are converted to a QDict<QString>		*/
	/* dictionary. This is done since by passing attributes in this	*/
	/* way, it is easy to construct forms on the fly.		*/
	QDict<QString>	aList	   ;
	aList.setAutoDelete (true) ;
	for (int idx = 0 ; idx < attribs.length() ; idx += 1)
		aList.insert (attribs.qName (idx), new QString (attribs.value(idx))) ;


	/* Check for the root of the component. This is a special	*/
	/* case, as we need to construct and note the form root node.	*/
	if (qName == "KBComponent")
	{
		m_kbTOS	= m_kbComponent = new KBComponent (m_location, aList) ;
		m_kbComponent->startParse ()     ; 
		return	true ;
	}

	if (m_kbTOS == 0)
	{
		setErrMessage (TR("Expected KBComponent element at top-most level, got %1"), qName) ;
		return	false ;
	}

	return	processNode (qName, aList, m_nodeDict) ;
}

/*  KBComponentHandler							*/
/*  parseFile	: Parse form from file					*/
/*  document	: const QString & : Form document file			*/
/*  (returns)	: KBComponent *	  : Form root or null on error		*/

KBComponent
	*KBComponentHandler::parseFile
	(	const QString	&document
	)
{
	/* All of the work is done by the base parse method, which	*/
	/* picks up on errors and empty documents.			*/
	if (!KBSAXHandler::parseFile (document)) return 0 ;

	return	m_kbComponent ;
}

/*  KBComponentHandler							*/
/*  parseText	: Parse form from text					*/
/*  document	: QByteArray &	: Form document text			*/
/*  (returns)	: KBComponent *	: Form root or null on error		*/

KBComponent
	*KBComponentHandler::parseText
	(	QByteArray	&document
	)
{
	/* All of the work is done by the base parse method, which	*/
	/* picks up on errors and empty documents.			*/
	if (!KBSAXHandler::parseText (document)) return 0 ;

	return	m_kbComponent ;
}


/*  KBOpenComponentText							*/
/*		: Open a form document from a file			*/
/*  location	: KBLocation &	 : Form location			*/
/*  document	: cchar *	 : Form document text			*/
/*  pError	: KBError &	 : Error return				*/
/*  (returns)	: KBComponent	 : Document root or null		*/

KBComponent
	*KBOpenComponentText
	(	KBLocation	&location,
		QByteArray	&document,
		KBError		&pError
	)
{
	extern	QDict<NodeSpec>	&getFormNodeDict() ;

	/* Create and initialise the SAX parser and the document and	*/
	/* error handlers (which are actually one and the same.		*/
	KBComponentHandler  	handler (location, 0, getFormNodeDict()) ;
	KBComponent		*comp	= handler.parseText (document) ;

	if (comp == 0)
	{	pError	= handler.lastError () ;
		return	0 ;
	}

	return	comp	;
}



