/***************************************************************************
    file	         : kb_popupmenu.cpp
    copyright            : (C) 1999,2000,2001,2002,2003 by Mike Richardson
			   (C) 2000,2001,2002,2003 by theKompany.com
			   (C) 2001,2002,2003 by John Dean
    license              : This file is released under the terms of
                           the GNU General Public License, version 2. The
                           copyright holders retain the right to release
                           this code under diffenent non-exclusive licences.
    email                : mike@quaking.demon.co.uk                                     
 ***************************************************************************/

#include	"kb_popupmenu.h"

/*  KBPopupMenu								*/
/*  KBPopupMenu	: Constructor for extended popup menu			*/
/*  lvState	: Qt::ButtonSate * : Return location for button state	*/
/*  (returns)	: KBPopupMenu	   :					*/

KBPopupMenu::KBPopupMenu
	(	Qt::ButtonState	*lvstate
	)
	:
	QPopupMenu (),
	lvstate	   (lvstate)
{
	subMenus.setAutoDelete (true) ;
}

/*  KBPopupMenu								*/
/*  ~KBPopupMenu: Desstructor for extended popup menu			*/
/*  (returns)	: void		:					*/

KBPopupMenu::~KBPopupMenu ()
{

}

/*  KBPopupMenu								*/
/*  insertEntry	: Insert a submenu					*/
/*  disable	: bool		: Disabled				*/
/*  text	: QString	: Label text				*/
/*  subMenu	: KBPopupMenu *	: Submenu				*/
/*  (returns)	: void		:					*/

void	KBPopupMenu::insertEntry
	(	bool		disable,
		const QString	&text,
		KBPopupMenu	*menu
	)
{
	int id = QPopupMenu::insertItem (text, menu) ;
	if (disable) setItemEnabled (id, false) ;
	subMenus.append (menu) ;
}

/*  KBPopupMenu								*/
/*  insertRenty	: Insert a submenu					*/
/*  disable	: bool		  : Disabled				*/
/*  text	: QString	  : Label text				*/
/*  receiver	: const QObject * : Signal received object		*/
/*  member	: const char *	  : Receiver slot			*/
/*  (returns)	: void		  :					*/

void	KBPopupMenu::insertEntry
	(	bool		disable,
		const QString	&text,
		const QObject	*receiver,
		const char	*member
	)
{
	int id = QPopupMenu::insertItem (text, receiver, member) ;
	if (disable) setItemEnabled (id, false) ;
}

/*  KBPopupMenu								*/
/*  mouseReleaseEvent							*/
/*		: Handle mouse release					*/
/*  q		: QMouseEvent *	: Mouse event				*/
/*  (returns)	: void		:					*/

void	KBPopupMenu::mouseReleaseEvent
	(	QMouseEvent	*e
	)
{
	if (lvstate != 0) *lvstate = e->state () ;
	QPopupMenu::mouseReleaseEvent (e) ;
}


