/***************************************************************************
    file	         : kb_qrysql.h
    copyright            : (C) 1999,2000,2001,2002,2003 by Mike Richardson
			   (C) 2000,2001,2002,2003 by theKompany.com
			   (C) 2001,2002,2003 by John Dean
    license              : This file is released under the terms of
                           the GNU General Public License, version 2. The
                           copyright holders retain the right to release
                           this code under diffenent non-exclusive licences.
    email                : mike@quaking.demon.co.uk                                     
 ***************************************************************************/

#ifndef	 _KB_QRYSQL_H
#define	 _KB_QRYSQL_H

#include	<qvaluelist.h>
#include	<qstringlist.h>

#include	"libkbase_exports.h"

#include	"kb_attr.h"
#include 	"kb_qrydata.h"
#include 	"kb_attrserver.h"
#include 	"kb_select.h"



/*  KBQrySQL								*/
/*  -----------								*/
/*  Class used for data queries which retrieve data via a simple free-	*/
/*  text SQL select query.						*/

class	LIBKBASE_API	KBQrySQL : public KBQryData
{
	KBAttrServer		m_server	;
	KBAttrStr		m_query		;
	KBAttrStr		m_topTable	;

	KBSelect		m_select	;

	KBTable			*m_qryTabPtr	;
	QList<KBTable>		m_qryTabList	;


protected :

	virtual	bool	loadQuery ()	;

#if	! __KB_RUNTIME
	virtual	bool		propertyDlg	()	;
#endif

public	:

	KBQrySQL	(KBNode *, const QDict<QString> &, bool * = 0) ;
	KBQrySQL	(KBNode *, KBQrySQL *) ;
	KBQrySQL	(KBNode *) ;

virtual~KBQrySQL	() ;

	virtual	KBQrySQL 	*isQrySQL	() { return this ; }

	virtual	void		showAs   	(KB::ShowAs)		;
	virtual	KBNode		*replicate  	(KBNode *)		;
	virtual	void		printNode	(QString &, int)	;

	virtual	QString		getComment	(uint) ;
}	;

#endif	// _KB_QRYSQL_H
