/***************************************************************************
    file	         : kb_qtlink.h
    copyright            : (C) 1999,2000,2001,2002,2003 by Mike Richardson
			   (C) 2000,2001,2002,2003 by theKompany.com
			   (C) 2001,2002,2003 by John Dean
    license              : This file is released under the terms of
                           the GNU General Public License, version 2. The
                           copyright holders retain the right to release
                           this code under diffenent non-exclusive licences.
    email                : mike@quaking.demon.co.uk                                     
 ***************************************************************************/

#ifndef	_KB_QTLINK_H
#define	_KB_QTLINK_H


#include	<qstringlist.h>

#include	"kb_classes.h"
#include	"kb_type.h"
#include	"kb_value.h"
#include	"kb_ctrl.h"
#include	"kb_combobox.h"

#include	"libkbase_exports.h"

class		KBMultiListBox	;

/*  KBComboBox								*/
/*  ----------								*/
/*  Wrapper class for combo box control					*/

class LIBKBASE_API	KBCtrlLink : public KBComboBox, public KBControl
{
	Q_OBJECT

	KBLink			*m_link		;
	QList<QStringList>	*m_valset	;
	KBMultiListBox		*m_listBox	;

	QString			m_userFilter	;
	QString			m_userSorting	;
	QStringList		*m_keyset	;

	QFocusEvent		*m_deferFocus	;
	QMouseEvent		*m_deferMouse	;

	void		loadDataValues	(const QValueList<const QStringList> &) ;

private slots :

	void		slotActivated	(int) ;
	void		passFocus	() ;

protected :

        virtual void    giveFocus	() ;

public	:

	KBCtrlLink (KBDisplay *, KBLink *, uint) ;
virtual~KBCtrlLink () ;

	virtual	void	showName	() ;
	virtual	void	redraw		() ;
	virtual	void	setData		(void *) ;
	virtual	void	showAs		(KB::ShowAs) ;
	virtual	void	setValue   	(const KBValue &) ;
	virtual	KBValue	getValue   	() ;
	virtual	void	clearValue	(bool) ;
	virtual	bool	changed    	() ;
	virtual	bool	isEmpty		() ;
	virtual	bool	isValid		(bool) ;
	virtual	bool	write		(KBWriter *, QRect, const KBValue &, bool, int &) ;

	virtual	bool	event		(QEvent      *) ;
	virtual	void	focusInEvent	(QFocusEvent *) ;

	virtual	QString	morphText	() ;

	void		setUserFilter	(const QString &) ;
	void		setUserSorting	(const QString &) ;
	void		reload		() ;

	SETFOCUS
	SIZEHINT
}	;

#endif	// _KB_QTLINK_H
