/***************************************************************************
    file	         : kb_script.h
    copyright            : (C) 1999,2000,2001,2002,2003 by Mike Richardson
			   (C) 2000,2001,2002,2003 by theKompany.com
			   (C) 2001,2002,2003 by John Dean
    license              : This file is released under the terms of
                           the GNU General Public License, version 2. The
                           copyright holders retain the right to release
                           this code under diffenent non-exclusive licences.
    email                : mike@quaking.demon.co.uk                                     
 ***************************************************************************/

#ifndef	_KB_SCRIPT_H
#define	_KB_SCRIPT_H

#include	<stdarg.h>

#include	<qvaluelist.h>
#include	<qlist.h>
#include	<qdict.h>

#include	"kb_module.h"
#include	"kb_moduleitem.h"
#include	"kb_location.h"

#include	"libkbase_exports.h"


class	KBDebug		;
class	TKToggleAction	;
class	TKTextEditor	;


/*  KBScript								*/
/*  ------------							*/
/*  This node specifies information about database script modules used	*/
/*  by reports and forms.						*/

class 	LIBKBASE_API	KBScript : public KBModule
{
public	:

	KBScript	(KBNode *, const QDict<QString> &, bool * = 0) ;
	KBScript	(KBNode *, cchar    *) ;
	KBScript	(KBNode *, KBScript *) ;
	virtual 	~KBScript () ;

	virtual	KBNode		*replicate (KBNode *) ;

	virtual	KBScript	*isScript  () { return this ; }

	enum	ExeRC
	{
		ExeError,	/* Script error, caller to handle	*/
		ExeFail,	/* Script error, debugger handles	*/
		ExeTrue,	/* Script returned true			*/
		ExeFalse	/* Script returned false		*/
	}	;

}	;


/*  KBScriptItem							*/
/*  ------------							*/
/*  Wrapper class round KBModuleItem which manufactures KBScript	*/
/*  instances.								*/

class 	LIBKBASE_API	KBScriptItem : public KBModuleItem
{
protected :

	virtual	KBModule *makeModule (KBNode *, const QString &) ;

public	:

	inline	KBScriptItem
		(	QListBox	*listBox,
			KBScript	*script
		)
		:
		KBModuleItem (listBox, script)
	{
	}

	inline	KBScriptItem
		(	QListBox	*listBox,
			const QString	&name
		)
		:
		KBModuleItem (listBox, name)
	{
	}

	virtual	~KBScriptItem () ;
}	;


/*  KBScriptDlg								*/
/*  -----------								*/
/*  This wraps the module dialog to implement the virtual methods that	*/
/*  instantiate module items (here as script items).			*/

class 	LIBKBASE_API	KBScriptDlg : public KBModuleDlg
{
protected :

	virtual	KBModuleItem	*makeModuleItem (QListBox *, KBModule 	   *) ;
	virtual	KBModuleItem	*makeModuleItem (QListBox *, const QString &) ;

public	:

	KBScriptDlg (QWidget *, KBNode *, QList<KBModule> &) ;
	virtual ~KBScriptDlg () ;
}	;


/*  KBScriptCode							*/
/*  ------------							*/
/*  This class is a base class for chunks of script code which is	*/
/*  manipulated in-store (eg., embeded in forms or held in a database)	*/

class 	LIBKBASE_API	KBScriptCode
{
protected	:

	KBEvent		*m_inherit	;

public		:

	inline	KBScriptCode
		(	KBEvent		*inherit
		)
	{
		m_inherit = inherit	;

	}	;

	virtual~KBScriptCode ()
	{
	} 	;

	virtual	KBScript::ExeRC	execute
		(	KBNode		*,
			uint		,
			const KBValue	*,
			KBValue		&
		)	= 0 ;
	virtual	KBScript::ExeRC	execute
		(	KBNode		*,
			KBNode		*,
			const QString	&,
			uint		,
			const KBValue	*,
			KBValue		&
		)	= 0 ;

	virtual	void	setBreakpoints
		(	const QValueList<int>	&
		)	= 0 ;
}	;


/*  KBScriptObject							*/
/*  --------------							*/
/*  Instances of this class can be attached to a KBObject by a script	*/
/*  interpreter to provide object persistence. These instances are	*/
/*  destroyed on data/design transitions and on KBObject deletion.	*/

class	LIBKBASE_API	KBScriptObject
{
public	:

	KBScriptObject() ;
	virtual	~KBScriptObject	() ;
}	;


/*  KBScriptIF								*/
/*  ----------								*/
/*  An instance of this object is instantiated by each form in order	*/
/*  to access a scripting language. It contains methods to load and to	*/
/*  unload modules, and to executen a script function.			*/

class 	LIBKBASE_API	KBScriptIF : public QObject
{	
	Q_OBJECT

public	:

	KBScriptIF () ;
	virtual	~KBScriptIF () ;

	virtual	void	setApp  (KBNotifier *, KBCallback *) = 0 ;

	virtual	bool	compile
		(	KBLocation		&,
			QString			&,
			QString			&,
			KBError			&
		)	= 0 ;

	virtual	KBScriptCode   *compileFunc
		(	const QString		&,
			const QString		&,
			const QString		&,
			QString			&,
			QString			&,
			const QStringList	&,
			KBEvent			*,
			KBError			&
		)	= 0 ;

	virtual	KBScriptCode   *compileExpr
		(	const QString		&,
			const QString		&,
			QString			&,
			QString			&,
			const QStringList	&,
			KBError			&
		)	= 0 ;

	virtual	bool	load
		(	KBLocation		&,
			QString			&,
			QString			&,
			KBError			&
		)	= 0 ;

	virtual	KBScript::ExeRC	execute
		(	const QStringList	&,
			const QString		&,
			KBNode			*,
			uint,
			const KBValue		*,
			KBValue 		&
		)	= 0 ;

	virtual	QString	   ident	() = 0	;

	virtual	KBLocation exeError	(QString &, uint &, QString &) = 0 ;

	/* Deleting and renaming script files is done through the	*/
	/* interface so that we can handle cases such as EL, where	*/
	/* there may be a compiled code file as well as the source file	*/
	virtual	bool	unlink		(KBLocation   &, KBError &) = 0 ;
	virtual	bool	rename		(KBLocation   &, const QString &, KBError &) = 0 ;

	virtual	void	editorInit	(TKTextEditor   *) ;
	virtual	KBDebug	*showDebug	(TKToggleAction *) ;
	virtual	bool	debugScript	(KBLocation   &, KBError	&) ;

	static	void	addIdentString	(const QString &, const QString &) ;
	static	QString	getIdentStrings	() ;
}	;

extern LIBKBASE_API KBScriptIF *LinkKBScript (const QString &, KBError &) ;

#endif	// _KB_SCRIPT_H
