/***************************************************************************
    file	         : kb_summarydlg.cpp
    copyright            : (C) 1999,2000,2001,2002,2003 by Mike Richardson
			   (C) 2000,2001,2002,2003 by theKompany.com
			   (C) 2001,2002,2003 by John Dean
    license              : This file is released under the terms of
                           the GNU General Public License, version 2. The
                           copyright holders retain the right to release
                           this code under diffenent non-exclusive licences.
    email                : mike@quaking.demon.co.uk                                     
 ***************************************************************************/

#include	<qframe.h>

#include	"kb_classes.h"
#include	"kb_type.h"
#include	"kb_value.h"

#include	"kb_attr.h"
#include	"kb_dbinfo.h"
#include	"kb_qrybase.h"
#include	"kb_block.h"
#include	"kb_summary.h"

#include	"kb_formatdlg.h"

#ifndef 	_WIN32
#include 	"kb_summarydlg.moc"
#else
#include 	"kb_summarydlg.h"
#endif



/*  KBSummaryPropDlg							*/
/*  KBSummaryPropDlg: Constructor for block properties dialog		*/
/*  summary	  : KBSummary *	    : Parent summary control		*/
/*  caption	  : const char *    : Dialog box caption		*/
/*  attribs	  : QList<KBAttr> & : List of attributes		*/
/*  iniAttr	  : cchar *	    : Initial attribute			*/
/*  (returns)	  : KBSummaryPropDlg:					*/

KBSummaryPropDlg::KBSummaryPropDlg
	(	KBSummary	*summary,
		cchar		*caption,
		QList<KBAttr>	&attribs,
		cchar		*iniAttr
	)
	:
	KBItemPropDlg	(summary, caption, attribs, iniAttr),
	m_fDialog	(&topWidget),
	m_summary	(summary)
{
	m_fDialog.hide () ;
}

/*  KBSummaryPropDlg							*/
/*  ~KBSummaryPropDlg: Destructor for block properties dialog		*/
/*  (returns)	   : void	:					*/

KBSummaryPropDlg::~KBSummaryPropDlg ()
{
}

/*  KBBSummaryPropDlg							*/
/*  hideProperty: Hide property						*/
/*  attr	: KBAttr *	: Attribute in question			*/
/*  (returns)	: void		:					*/

bool	KBSummaryPropDlg::hideProperty
	(	KBAttr	*attr
	)
{
	const QString	&aName	= attr->getName() ;

	return	(aName == "rdonly" ) ||
		(aName == "default") || (aName == "taborder") ;
}

/*  KBSummaryPropDlg							*/
/*  showProperty: Show property						*/
/*  item	: KBAttrItem *	: Associated item			*/
/*  (returns)	: bool		: Property on show			*/

bool	KBSummaryPropDlg::showProperty
	(	KBAttrItem	*item
	)
{
	const QString	&aName	= item->attr()->getName () ;

	/* For format, show the format type and specification list	*/
	/* boxes. We have a look at the field type to give a hint as	*/
	/* to the appropriate types of format.				*/
	if (aName == "format")
	{
		const QString	&display = getProperty ("expr") ;
		uint		qlvl	 ;
		KBQryBase	*query	 ;

		if ((query = getBlockQuery(qlvl)) == 0)
			return false ;

		if (!m_fDialog.showFormats (item->value(), display, query, qlvl))
			return false ;

		setUserWidget (&m_fDialog) ;
		return	true ;
	}

	/* Summary type options are shown using the KBPropDlg combobox,	*/
	/* initialised with the set of possibilities. 			*/
	if (aName == "summary")
	{
		comboBox.setGeometry (150, 140, 400,  20) ;

		comboBox.clear	     () ;
		comboBox.insertItem  (TR("Total  ")) ;
		comboBox.insertItem  (TR("Minimum")) ;
		comboBox.insertItem  (TR("Maximum")) ;

		QString	value = item->value() ;
		if	(value == "Total"  ) comboBox.setCurrentItem (0) ;
		else if (value == "Minimum") comboBox.setCurrentItem (1) ;
		else			     comboBox.setCurrentItem (2) ;

		comboBox.show () ;

		return	true	 ;
	}

	return	KBItemPropDlg::showProperty (item) ;
}

/*  KBSummaryPropDlg							*/
/*  saveProperty: Check and save attribute				*/
/*  item	: KBAttrItem *	: Associated item			*/
/*  (returns)	: bool		: Attribute OK				*/

bool	KBSummaryPropDlg::saveProperty
	(	KBAttrItem	*item
	)
{
	const QString	&aName = item->attr()->getName () ;

	/* In the case of the format specification, we need to stitch	*/
	/* together the type and the specification itself.		*/
	if (aName == "format")
	{
		setProperty (aName, m_fDialog.getValue()) ;
		return	true	;
	}

	/* Similarly handle the summary type here ...			*/
	if (aName == "summary")
	{
		static	cchar	*vals[] =
		{	"Total",
			"Minimum",
			"Maximum"
		}	;

		setProperty (item, vals[comboBox.currentItem()]) ;
		return	true ;
	}

	return	KBItemPropDlg::saveProperty (item) ;
}

/*  summaryPropDlg: Run the data control properties dialog		*/
/*  summary	  : KBSummary *	  : Parent summary control		*/
/*  caption	  : const char *  : Dialog box caption			*/
/*  attribs	  : QList<KBAttr>&: List of attributes			*/
/*  iniAttr	  : cchar *	    : Initial attribute			*/
/*  (returns)	  : bool	  : Success				*/

bool	summaryPropDlg
	(	KBSummary	*summary,
		cchar		*caption,
		QList<KBAttr>	&attribs,
		cchar		*iniAttr
	)
{
	KBSummaryPropDlg sDlg (summary, caption, attribs, iniAttr) ;
	return	sDlg.exec () ;
}
