/***************************************************************************
    file	         : tk_action.cpp
    copyright            : (C) 1999,2000,2001,2002,2003 by Mike Richardson
			   (C) 2000,2001,2002,2003 by theKompany.com
			   (C) 2001,2002,2003 by John Dean
    license              : This file is released under the terms of
                           the GNU General Public License, version 2. The
                           copyright holders retain the right to release
                           this code under diffenent non-exclusive licences.
    email                : mike@quaking.demon.co.uk                                     
 ***************************************************************************/


#include	"tk_action.moc"
#include	"tk_config.h"


TKURL::TKURL
	(	const KURL	&url
	)
	:
	KURL	(url)
{
}

/*  TKAction								*/
/*  TKAction	: Constructor for simple action base class		*/
/*  text	: const QString & : Menu text				*/
/*  iconName	: const QString & : Menu or toolbar icon name		*/
/*  accel	: int		  : Accelerator code			*/
/*  receiver	: const QObject * : Receiver object for action signals	*/
/*  slot	: char char *	  : Receiver slot for action signals	*/
/*  parent	: QObject *	  : Parent object			*/
/*  name	: const char *	  : Object name				*/
/*  (returns)	: TKAction	  :					*/

TKAction::TKAction
	(	const QString	&text,
		const QString	&iconName,
		int		accel,
		const QObject	*receiver,
		const char	*slot,
		QObject		*parent,
		const char 	*name
	)
	:
	QObject	(parent, name)
{
	code	= 0	;
	group	= 0	;

	/* Connection our activated signal to the receiver, and create	*/
	/* a KAction object whose activated signal is received by us.	*/
	/* This allows our action code to be passed to the receiver.	*/
	if (receiver != 0)
		connect	  (this, SIGNAL(activated(int)), receiver, slot) ;

	if (iconName == QString::null)
		setAction (new KAction (text,           accel, this, SLOT(slotActivated()), this, name)) ;
	else	setAction (new KAction (text, iconName, accel, this, SLOT(slotActivated()), this, name)) ;

	/* If an icon name is specified, then tell the action. This is	*/
	/* needed since KAction doesn't interpret a null icon name as	*/
	/* meaning no icon.						*/
	if (!iconName.isEmpty()) action->setIcon (iconName) ;
}

/*  TKAction								*/
/*  TKAction	: Constructor for simple action base class		*/
/*  receiver	: const QObject * : Receiver object for action signals	*/
/*  slot	: char char *	  : Receiver slot for action signals	*/
/*  parent	: QObject *	  : Parent object			*/
/*  name	: const char *	  : Object name				*/
/*  (returns)	: TKAction	  :					*/

TKAction::TKAction
	(	const QObject	*receiver,
		const char	*slot,
		QObject		*parent,
		const char 	*name
	)
	:
	QObject	(parent, name)
{
	code	= 0	;
	group	= 0	;
	action	= 0	;

	/* This constructor is used by TKToggleAction. Just connect	*/
	/* our signal; the real KAction-derived object will be set	*/
	/* later.							*/
	if (receiver != 0)
		connect	(this, SIGNAL(activated(int)), receiver, slot) ;
}

/*  TKAction								*/
/*  TKAction	: Constructor for simple action base class		*/
/*  parent	: QObject *	  : Parent object			*/
/*  name	: const char *	  : Object name				*/
/*  (returns)	: TKAction	  :					*/

TKAction::TKAction
	(	QObject		*parent,
		const char 	*name
	)
	:
	QObject	(parent, name)
{
	code	= 0	;
	group	= 0	;
	action	= 0	;
}

/*  TKAction								*/
/*  TKAction	: Constructor for action proxy				*/
/*  action	: KAction	: Underlying action			*/
/*  parent	: QObject *	: Parent object				*/
/*  name	: const char *	: Object name				*/
/*  (returns)	: TKAction	:					*/

TKAction::TKAction
	(	KAction		*action,
		QObject		*parent,
		const char	*name
	)
	:
	QObject	(parent, name),
	action	(action)
{
	code	= 0	;
	group	= 0	;
}

/*  TKAction								*/
/*  ~TKAction	: Destructor for action proxy				*/
/*  (returns)	:		:					*/

TKAction::~TKAction ()
{
	if (action != 0) delete action ;
}

/*  TKAction								*/
/*  setAction	: Set underlying KDE action				*/
/*  _action	: KAction *	: The action in question		*/
/*  (returns)	: void		:					*/

void	TKAction::setAction
	(	KAction		*_action
	)
{
	action	= _action ;
}

/*  TKAction								*/
/*  slotActivated: Handle action activation				*/
/*  (returns)	 : void		:					*/

void	TKAction::slotActivated ()
{
	/* All we are really doing is to bounce the signal on to the	*/
	/* receiver, except that the action code is added.		*/
	emit	activated (code) ;
}

/*  TKAction								*/
/*  getAction	: Get the underlying KDE action				*/
/*  (returns)	: KAction *	: Action				*/

KAction	*TKAction::getAction ()
{
	return	action	;
}

/*  TKAction								*/
/*  getGroup	: Get action group identifier				*/
/*  (returns)	: int		: Group					*/

int	TKAction::getGroup ()
{
	return	group	;
}

/*  TKAction								*/
/*  setCode	: Set action activation code				*/
/*  _code	: int		: Required code				*/
/*  (returns)	: void		:					*/

void	TKAction::setCode
	(	int	_code
	)
{
	code	= _code	 ;
}

/*  TKAction								*/
/*  setGroup	: Set action group identifier				*/
/*  _group	: int		: Required identifier			*/
/*  (returns)	: void		:					*/

void	TKAction::setGroup
	(	int	_group
	)
{
	group	= _group ;
}

/*  TKAction								*/
/*  setToolTop	: Set tool tip for action				*/
/*  tip		: const QString & : Tip text				*/
/*  (returns)	: void		  :					*/

void	TKAction::setToolTip
	(	const QString	&tip
	)
{
	action->setToolTip (tip) ;
}

/*  TKAction								*/
/*  setEnabled	: Set action enabled (or disabled)			*/
/*  enabled	: bool		: True to enable			*/
/*  (returns)	: void		:					*/

void	TKAction::setEnabled
	(	bool	enabled
	)
{
	action->setEnabled (enabled) ;
}

/*  TKAction								*/
/*  unplugAll	: Unplug from all containers				*/
/*  (returns)	: void		:					*/

void	TKAction::unplugAll ()
{
	action->unplugAll () ;
}

/*  ------------------------------------------------------------------  */

/*  TKToggleAction							*/
/*  TKToggleAction							*/
/*		: Constructor for toggle action object			*/
/*  text	: const QString & : Menu text				*/
/*  iconName	: const QString & : Menu or toolbar icon name		*/
/*  accel	: int		  : Accelerator code			*/
/*  receiver	: const QObject * : Receiver object for action signals	*/
/*  slot	: char char *	  : Receiver slot for action signals	*/
/*  parent	: QObject *	  : Parent object			*/
/*  name	: const char *	  : Object name				*/
/*  (returns)	: TKAction	  :					*/

TKToggleAction::TKToggleAction
	(	const QString	&text,
		const QString	&iconName,
		int		accel,
		const QObject	*receiver,
		const char	*slot,
		QObject		*parent,
		const char 	*name
	)
	:
	TKAction (receiver, slot, parent, name)
{
	if (receiver != 0)
		connect	  (this, SIGNAL(toggled(bool, int)), receiver, slot) ;

	/* Construct the underlying KDE action object, and set the icon	*/
	/* if present. Then store the action pointer.			*/
	toggleAction = new KToggleAction (text, accel, this, name) ;
	if (!iconName.isEmpty()) toggleAction->setIcon (iconName) ;

	connect	  (toggleAction, SIGNAL(toggled(bool)), SLOT(slotToggled(bool))) ;
	setAction (toggleAction) ;
}

/*  TKToggleAction							*/
/*  getToggleAction: Get the underlying KDE toggle action		*/
/*  (returns)	   : KToggleAction * : Underlying toggle action		*/

KToggleAction	*TKToggleAction::getToggleAction ()
{
	return	toggleAction	;
}

/*  TKToggleAction							*/
/*  setChecked	: Set or clear checked state				*/
/*  checked	: bool		: True to check				*/
/*  (returns)	: void		:					*/

void	TKToggleAction::setChecked
	(	bool	checked
	)
{
	toggleAction->setChecked (checked) ;
}

/*  TKToggleAction							*/
/*  isChecked	: See if currently checked				*/
/*  (returns)	: bool		: True if checked			*/

bool	TKToggleAction::isChecked ()
{
	return	toggleAction->isChecked () ;
}

/*  TKToggleAction								*/
/*  slotToggled	: Handle toggling					*/
/*  state	: bool		: Toggle state				*/
/*  (returns)	: void		:					*/

void	TKToggleAction::slotToggled
	(	bool	state
	)
{
	/* All we are really doing is to bounce the signal on to the	*/
	/* receiver, except that the action code is added.		*/
	emit	toggled (state, code) ;
}

/*  ------------------------------------------------------------------  */

/*  TKSelectAction							*/
/*  TKSelectAction							*/
/*		: Constructor for select action				*/
/*  text	: const QString & : Menu text				*/
/*  iconName	: const QString & : Menu or toolbar icon name		*/
/*  accel	: int		  : Accelerator code			*/
/*  receiver	: const QObject * : Receiver object for action signals	*/
/*  slot	: char char *	  : Receiver slot for action signals	*/
/*  parent	: QObject *	  : Parent object			*/
/*  name	: const char *	  : Object name				*/
/*  (returns)	: TKAction	  :					*/

TKSelectAction::TKSelectAction
	(	const QString	&text,
		const QString	&iconName,
		int		accel,
		const QObject	*receiver,
		const char	*slot,
		QObject		*parent,
		const char 	*name
	)
	:
	TKAction (parent, name)
{
	/* Construct the underlying KDE action object, and set the icon	*/
	/* if present. Then store the action pointer.			*/
	selectAction = new KSelectAction
		       (	text,
				accel,
				this,
				name
		       )	;

	if (!iconName.isEmpty()) selectAction->setIcon (iconName) ;
	setAction (selectAction) ;

	if (receiver != 0)
		connect
		(	selectAction,
			SIGNAL(activated(const QString &)),
			receiver,
			slot
		)	;
}

void	TKSelectAction::setItems
	(	const QStringList	&items
	)
{
	selectAction->setItems (items) ;
}

void	TKSelectAction::setCurrentItem
	(	int		id
	)
{
	selectAction->setCurrentItem (id) ;
}

QPopupMenu
	*TKSelectAction::popupMenu ()
{
	return	selectAction->popupMenu () ;
}

/*  ------------------------------------------------------------------  */

/*  TKRecentFilesAction							*/
/*  TKRecentFilesAction							*/
/*		: Constructor for recent files action			*/
/*  text	: const QString & : Menu text				*/
/*  iconName	: const QString & : Menu or toolbar icon name		*/
/*  accel	: int		  : Accelerator code			*/
/*  receiver	: const QObject * : Receiver object for action signals	*/
/*  slot	: char char *	  : Receiver slot for action signals	*/
/*  parent	: QObject *	  : Parent object			*/
/*  name	: const char *	  : Object name				*/
/*  (returns)	: TKAction	  :					*/

TKRecentFilesAction::TKRecentFilesAction
	(	const QString	&text,
		const QString	&iconName,
		int		accel,
		const QObject	*receiver,
		const char	*slot,
		QObject		*parent,
		const char 	*name
	)
	:
	TKAction (parent, name)
{
	/* Construct the underlying KDE action object, and set the icon	*/
	/* if present. Then store the action pointer.			*/
	recentAction = new KRecentFilesAction
		       (	text,
				accel,
				this,
				SLOT(slotUrlSelected(const KURL &)),
				this,
				name
		       )	;

	if (!iconName.isEmpty()) recentAction->setIcon (iconName) ;
	setAction (recentAction) ;

	if (receiver != 0)
		connect
		(	this,
			SIGNAL(urlSelected(const TKURL &)),
			receiver,
			slot
		)	;
}

void	TKRecentFilesAction::slotUrlSelected
	(	const KURL	&url
	)
{
	emit	urlSelected	(TKURL(url)) ;
}

/*  TKRecentFilesAction							*/
/*  loadEntries	: Load configuration					*/
/*  config	: TKConfig *	: Configuration				*/
/*  (returns)	: void		:					*/

void	TKRecentFilesAction::loadEntries
	(	TKConfig	*config
	)
{
	recentAction->loadEntries (config->config()) ;
}

/*  TKRecentFilesAction							*/
/*  saveEntries	: Load configuration					*/
/*  config	: TKConfig *	: Configuration				*/
/*  (returns)	: void		:					*/

void	TKRecentFilesAction::saveEntries
	(	TKConfig	*config
	)
{
	recentAction->saveEntries (config->config()) ;
}

/*  TKRecentFilesAction							*/
/*  addURL	: Add a url to the action				*/
/*  url		: const TKURL &	: URL in question			*/
/*  (returns)	: void		:					*/

void	TKRecentFilesAction::addURL
	(	const TKURL	&url
	)
{
	recentAction->addURL (url) ;
}

/*  TKRecentFilesAction							*/
/*  removeURL	: Remove a url to the action				*/
/*  url		: const TKURL &	: URL in question			*/
/*  (returns)	: void		:					*/

void	TKRecentFilesAction::removeURL
	(	const TKURL	&url
	)
{
	recentAction->removeURL (url) ;
}


void	TKRecentFilesAction::setCurrentItem
	(	int		id
	)
{
	recentAction->setCurrentItem (id) ;
}

/*  ------------------------------------------------------------------  */

/*  TKActionMenu							*/
/*  TKActionMenu: Constructor for action popup menu			*/
/*  text	: const QString & : Menu text				*/
/*  parent	: QObject *	  : Parent object			*/
/*  name	: const char *	  : Object name				*/
/*  (returns)	: TKAction	  :					*/

TKActionMenu::TKActionMenu
	(	const QString	&text,
		QObject		*parent,
		const char	*name
	)
	:
	TKAction (parent, name)
{
	setAction (actionMenu = new KActionMenu (text, this, name)) ;
}

void	TKActionMenu::insert
	(	TKAction *action,
		int	 index
	)
{
	actionMenu->insert (action->getAction(), index) ;
}

void	TKActionMenu::remove
	(	TKAction *action
	)
{
	actionMenu->remove (action->getAction()) ;
}

#if	!((KDE_VERSION_MAJOR == 3) && (KDE_VERSION_MINOR == 0))

TKWidgetAction::TKWidgetAction
	(	QWidget		*widget,
		QObject		*parent,
		const char	*name
	)
	:
	TKAction	(parent, name)
{
	widgetAction	= new KWidgetAction
			  (	widget,
				"",
				shortcut,
				0,
				0,
				0,
				name
			  )	;
	setAction (widgetAction);
}
#endif
