/***************************************************************************
    file	         : kb_qtkdepart.cpp
    copyright            : (C) 1999,2000,2001,2002,2003 by Mike Richardson
			   (C) 2000,2001,2002,2003 by theKompany.com
			   (C) 2001,2002,2003 by John Dean
    license              : This file is released under the terms of
                           the GNU General Public License, version 2. The
                           copyright holders retain the right to release
                           this code under diffenent non-exclusive licences.
    email                : mike@quaking.demon.co.uk                                     
 ***************************************************************************/

#include	<unistd.h>
#include	<qfile.h>
#include	<ktempfile.h>


#ifndef 	_WIN32
#include 	"kb_qtkdepart.moc"
#else
#include 	"kb_qtkdepart.h"
#endif

#include	"kb_block.h"
#include	"kb_kdepart.h"
#include	"kb_display.h"
#include	"kb_writer.h"


#include	<kparts/mainwindow.h>
#include	<kparts/browserextension.h>
#include	<kparts/browserinterface.h>


/*  KBCtrlKDEPart							*/
/*  KBCtrlKDEPart							*/
/*		: Constructor for KDE part wrapper			*/
/*  display	: KBDisplay *	: Parent display			*/
/*  part	: KBKDEPart *	: Parent part item			*/
/*  drow	: uint		: Row number in block			*/
/*  (returns)	: KBCtrlKDEPart	:					*/

KBCtrlKDEPart::KBCtrlKDEPart
	(	KBDisplay	*display,
		KBKDEPart	*part,
		uint		drow
	)
	:
	QLabel		(display->getDisplayWidget()),
	KBControl	(this, display, part, drow),
	m_part		(part)
{
	/* Install our own event filter on the text view, since this	*/
	/* is not the top-level (TKTextEditor) widger.			*/
//	textView()->installEventFilter (this) ;

	m_layout  	= new QVBoxLayout (this) ;
	m_roPart  	= 0 ;
	m_tempFile	= 0 ;

	redraw		()  ;
}

/*  KBCtrlKDEPart								*/
/*  ~KBCtrlKDEPart							*/
/*		: Desctructor for part class				*/
/*  (returns)	:		:					*/

KBCtrlKDEPart::~KBCtrlKDEPart ()
{
	if (m_tempFile != 0) delete m_tempFile ;		
}

/*  KBCtrlKDEPart							*/
/*  eventFilter	: Widget event filter					*/
/*  o		: QObject *	: Object originating event		*/
/*  e		: QEvent *	: Event in question			*/
/*  (returns)	: bool		: False to continue processing		*/

bool	KBCtrlKDEPart::eventFilter
	(	QObject	*o,
		QEvent	*e
	)
{
	if (e->type() == QEvent::KeyPress)
		return	false	;

	return	KBControl::eventFilter (o, e) ;
}

/*  KBCtrlKDEPart								*/
/*  viewSetFocusOK							*/
/*		: Check if OK to set focus into the memo		*/
/*  (returns)	: bool		: True if OK				*/

bool	KBCtrlKDEPart::viewSetFocusOK()
{
	return	m_part->moveFocusOK (m_drow) ;
}

/*  KBCtrlKDEPart								*/
/*  redraw	: Redraw to get profile and frame correct		*/
/*  (returns)	: bool		:					*/

void	KBCtrlKDEPart::redraw ()
{
	m_layout->setMargin (ctrlSetFrame (this)) ;
}

/*  KBCtrlKDEPart								*/
/*  setPalette	: Set palette on widget					*/
/*  pal		: const QPalette *: Palette in question			*/
/*  (returns)	: void		  :					*/

void	KBCtrlKDEPart::setPalette
	(	const QPalette *
	)
{
}

/*  KBCtrlKDEPart								*/
/*  setFont	: Set font on widget					*/
/*  font	: const QFont *	: Font in question			*/
/*  (returns)	: void		:					*/

void	KBCtrlKDEPart::setFont
	(	const QFont *
	)
{
}

/*  KBCtrlKDEPart								*/
/*  showName	: Show control name					*/
/*  (returns)	: void		:					*/

void	KBCtrlKDEPart::showName ()
{
#if	! __KB_RUNTIME
	if (m_drow == 0) setText (m_part->getName()) ;
#endif
}

/*  KBCtrlKDEPart								*/
/*  showAs	: Set or clear design mode				*/
/*  mode	: KB::ShowAs	: Design mode				*/
/*  (returns)	: void		:					*/

void	KBCtrlKDEPart::showAs
	(	KB::ShowAs	mode
	)
{
	KBControl::showAs (mode) ;

	DELOBJ	 (m_roPart) ;

#if	! __KB_RUNTIME
	if (mode == KB::ShowAsDesign)
	{
		showName () ;
		return	 ;
	}
#endif

	if ((m_roPart = m_part->readOnlyPart (this)) == 0)
	{
		fprintf
		(	stderr,
			"KBCtrlKDEPart::showAs: showAsData: *** no part ***\n"
		)	;
		return	;
	}

	QWidget *w = m_roPart->widget () ;
	m_layout->addWidget (w)	;
	w	->show	() 	;

	KParts::BrowserExtension *bext = KParts::BrowserExtension::childObject (m_roPart) ;
	if (bext != 0)
	{
		fprintf
		(	stderr,
			"KBCtrlKDEPart::showAs: got browser extension [%p]\n",
			(void *)bext
		)	;
		KParts::BrowserInterface  *bif = new KParts::BrowserInterface (this) ;
		bext->setBrowserInterface (bif) ;

		connect
		(	bext,
			SIGNAL(openURLRequestDelayed(const KURL &, const KParts::URLArgs &)),
			SLOT  (openURLRequest	    (const KURL &))
		)	;
	}
}

void	KBCtrlKDEPart::loadURL
	(	const KURL	&url
	)
{
	if (m_roPart != 0)
		if (!m_roPart->openURL(url))
			KBError::EWarning
			(	QString(TR("Failed to load URL '%1'"))
					.arg(url.url()),
				QString::null,
				__ERRLOCN
			)	;
}

void	KBCtrlKDEPart::openURLRequest
	(	const KURL	&url
	)
{
	fprintf
	(	stderr,
		"KBCtrlKDEPart::openURLRequest: called [%s]\n",
		(cchar *)url.url()
	)	;

	if (m_part->follow()) loadURL (url) ;
}


/*  KBCtrlMeno								*/
/*  giveFocus	: Give focus to the control				*/
/*  (returns)	: void							*/

void	KBCtrlKDEPart::giveFocus ()
{
	QFrame::setFocus () ;
}


/*  KBCtrlMeno								*/
/*  loadValueData: Load value as data rather then URL			*/
/*  value	 : const KBValue & : Value				*/
/*  (returns)	 : void		   :					*/

void	KBCtrlKDEPart::loadValueData
	(	const KBValue	&value
	)
{
	if (m_tempFile != 0)
		delete	m_tempFile ;

	m_tempFile = new KTempFile ;
	m_tempFile->setAutoDelete (true) ;

	if (m_tempFile->status() != 0)
	{
		KBError::EError
		(	QString(TR("Unable to open file '%1' to load part data"))
				.arg(m_tempFile->name()),
			strerror(m_tempFile->status()),
			__ERRLOCN
		)	;
		return	;
	}

	int	handle	= m_tempFile->handle() ;
	if (handle < 0)
	{
		KBError::EError
		(	QString(TR("Unable to access file '%1' to load part data"))
				.arg(m_tempFile->name()),
			strerror(m_tempFile->status()),
			__ERRLOCN
		)	;
		return	;
	}

	if (::write (handle, value.dataPtr(), value.dataLength()) != (ssize_t)value.dataLength())
	{
		KBError::EError
		(	QString(TR("Unable to write to file '%1' to load part data"))
				.arg(m_tempFile->name()),
			strerror(errno),
			__ERRLOCN
		)	;
		return	;
	}

	if (!m_tempFile->close())
	{
		KBError::EError
		(	QString(TR("Error closing '%1' when loading part data"))
				.arg(m_tempFile->name()),
			strerror(m_tempFile->status()),
			__ERRLOCN
		)	;
		return	;
	}

	fprintf
	(	stderr,
		"KBCtrlKDEPart::loadValueData: file [%s]\n",
		(cchar *)m_tempFile->name()
	)	;

	loadURL	(KURL(m_tempFile->name())) ;
}

/*  KBCtrlKDEPart								*/
/*  setValue	: Set memo value					*/
/*  value	: const KBValue &: Value				*/
/*  (returns)	: void		 :					*/

void	KBCtrlKDEPart::setValue
	(	const KBValue	&value
	)
{
	if (m_part->valueIsData ())
		loadValueData (value) ;
	else	loadURL	      (KURL (value.getRawText())) ;


	KBControl::setValue (value) ;
}

/*  KBCtrlKDEPart							*/
/*  getValue	: Get memo value					*/
/*  (returns)	: KBValue	: Value					*/

KBValue	KBCtrlKDEPart::getValue ()
{
	return	KBValue	() ;
}

/*  KBCtrlKDEPart								*/
/*  clearValue	: Clear value for specified query and display row	*/
/*  query	: bool		: Clearing for query			*/
/*  (returns)	: void		:					*/

void	KBCtrlKDEPart::clearValue
	(	bool	query
	)
{
	loadValueData (KBValue()) ;
	KBControl::clearValue (query) ;
}

/*  KBCtrlKDEPart								*/
/*  changed	: Test if memo value has been changed			*/
/*  (returns)	: bool		: TRUE if changed			*/

bool	KBCtrlKDEPart::changed ()
{
	return	false	;
}

/*  KBCtrlKDEPart								*/
/*  isEmpty	: See if control is empty				*/
/*  (returns)	: bool		: Empty					*/

bool	KBCtrlKDEPart::isEmpty ()
{
	return	true	;
}

/*  KBCtrlKDEPart								*/
/*  isValid	: See if control is valid				*/
/*  allowNull	: bool		: True to ignore not-null check		*/
/*  (returns)	: bool		: Empty					*/

bool	KBCtrlKDEPart::isValid
	(	bool
	)
{
	return	true	;
}

/*  KBCtrlKDEPart								*/
/*  mainWidget	: Get the main widget for the control			*/
/*  (returns)	: QWidget *	: Widget in question			*/

QWidget	*KBCtrlKDEPart::mainWidget ()
{
	return	this	;
}

/*  KBCtrlKDEPart								*/
/*  KBControl								*/
/*  topWidget	: Get top-level widget					*/
/*  (returns)	: QWidget *	: Widget in question			*/

QWidget	*KBCtrlKDEPart::topWidget ()
{
	return	this	;
}

/*  KBCtrlKDEPart								*/
/*  write	: Write memo 						*/
/*  writer	: KBWriter *	: Output writer				*/
/*  rect	: QRect		: Memo area				*/
/*  value	: KBValue &	: Value for reports			*/
/*  fSubs	: bool		: Substitution flag			*/
/*  extra	: int &		: Return extra space			*/
/*  (returns)	: bool		: Success				*/

bool	KBCtrlKDEPart::write
	(	KBWriter	*,//writer
		QRect		,//rect
		const KBValue	&,//value
		bool		,//fSubs
		int		&//extra
	)
{
#if	0
	if (writer->asReport())
	{
		KBWriterText *w = new KBWriterText
				  (	writer,
					rect,
					memo->getPalette(true   ),
					memo->getFont   (true   ),
					value.getRawText(),
					0x1001,
					fSubs
				  )	;
		extra	= w->extra()	;
		return	true	;
	}

	return	KBControl::write (writer, rect, value, fSubs, extra) ;
#endif
	return	true	;
}
