/***************************************************************************
    file	         : main.cpp
    copyright            : (C) 1999,2000,2001,2002,2003 by Mike Richardson
			   (C) 2000,2001,2002,2003 by theKompany.com
			   (C) 2001,2002,2003 by John Dean
    license              : This file is released under the terms of
                           the GNU General Public License, version 2. The
                           copyright holders retain the right to release
                           this code under diffenent non-exclusive licences.
    email                : mike@quaking.demon.co.uk                                     
 ***************************************************************************/

#include	<stdio.h>
#include	<stdlib.h>

#include	<qglobal.h>
#include	<qtoolbar.h>
#include	<qmenubar.h>
#include	<qpopupmenu.h>
#include	<qmultilineedit.h>
#include	<qworkspace.h>
#include	<qstatusbar.h>

#include	<qdom.h>

#include	"main.moc"

#include	"tk_config.h"
#include	"tk_action.h"
#include	"tk_xmlguispec.h"
#include	"tk_mainwindow.h"


TKAction		*tkExit		;
TKAction		*tkSwitch	;
TKConfig		*config		;
TKRecentFilesAction	*recent		;
TKActionMenu		*actions	;

TKTest::TKTest
	(	QWidget		*parent,
		const char	*name
	)
	:
	TKMainWindow	(parent, name, WDestructiveClose)
{
	TKActionCollection *cmain = actionCollection() ;

	config	= TKConfig::getConfig() ;

	recent	= new TKRecentFilesAction
	(	"Recent files",
		0,
		0,
		this,
		SLOT(noSuchSlot(const TKURL &)),
		cmain,
		"recent"
	)	;

	tkExit	= new TKAction
		  (	"E&xit",
		  	"exit",
		  	0,
			this,
		  	SLOT(slotExit()),
		  	cmain,
		  	"exit"
		  )	;
	tkSwitch =new TKAction
		  (	"&Switch",
		  	"redo",
		  	0,
		  	this,
		  	SLOT(slotSwitch()),
		  	cmain,
		  	"switch"
		  )	;
	tFirst	= new TKToggleAction
		  (	"Show &first",
			"top",
			0,
			this,
			SLOT(slotFirst()),
			cmain,
			"first"
		  )	;

	tSecond	= new TKToggleAction
		  (	"Show &second",
			"bottom",
			0,
			this,
			SLOT(slotSecond()),
			cmain,
			"second"
		  )	;
	actions	= new TKActionMenu
		  (	"Actions",
		  	cmain,
		  	"actions"
		  )	;

	setXMLFile ("tktest.xml") ;
	createGUI  (0) ;

	recent->loadEntries (config) ;
	recent->addURL	    (TKURL("/tmp/xxx")) ;
	recent->saveEntries (config) ;
	config->sync () ;

	actions->insert
	(	new TKAction
		(	"First",
			0,
			0,
			this,
			SLOT(showFirst()),
			this
		)
	)	;

	actions->insert
	(	new TKAction
		(	"Second",
			0,
			0,
			this,
			SLOT(showSecond()),
			this
		)
	)	;

	QWorkspace     *space   = new QWorkspace     (this) ;
	setCentralWidget (space) ;

	QMultiLineEdit *wFirst	= new QMultiLineEdit (space) ;
	QMultiLineEdit *wSecond	= new QMultiLineEdit (space) ;

	wFirst ->setCaption ("First" ) ;
	wSecond->setCaption ("Second") ;

	pFirst	= new TKPart  (this) ;
	pSecond	= new TKPart  (this) ;

	pFirst ->setWidget (wFirst ) ;
	pSecond->setWidget (wSecond) ;


	TKPartManager *manager = new TKPartManager (this) ;
	connect (manager, SIGNAL(activatePartChanged(TKPart *)), this, SLOT(createGUI(TKPart *))) ;

	manager->addPart (pFirst ) ;
	manager->addPart (pSecond) ;

	TKActionCollection *cFirst  = pFirst ->actionCollection() ;
	TKActionCollection *cSecond = pSecond->actionCollection() ;

	new TKAction
		  (	"&Go second",
		  	"bottom",
		  	0,
		  	this,
		  	SLOT(showSecond()),
		  	cFirst,
		  	"second"
		  )	;
	new TKAction
		  (	"&Gofirst",
		  	"top",
		  	0,
		  	this,
		  	SLOT(showFirst()),
		  	cSecond,
		  	"first"
		  )	;

	pFirst ->setXMLFile ("first.xml" ) ;
	pSecond->setXMLFile ("second.xml") ;

	wFirst ->show () ;
	wSecond->show () ;

	showFirst  () ;

	setCaption ("TKTest") ;
	show	   () ;
}

TKAction*TKTest::action
	(	const QDomElement	&element
	)
{
	fprintf	(stderr, "TKTest: finding action \"%s\"\n",
			 (const char *)element.attribute("name")) ;
	return	TKMainWindow::action (element) ;
}

void	TKTest::slotExit ()
{
	recent->saveEntries (config) ;
	config->writeEntry("tktest was here", 666) ;
	config->sync() ;
	qApp->closeAllWindows() ;
}

void	TKTest::showPart
	(	TKPart		*part
	)
{
	showing = part ;
	part->widget()->setFocus () ;
}

void	TKTest::showFirst ()
{
	showPart (pFirst) ;

	tFirst  ->setChecked (true ) ;
	tSecond ->setChecked (false) ;
	tkExit  ->setEnabled (true ) ;
	tkSwitch->setEnabled (false) ;
}

void	TKTest::showSecond ()
{
	showPart (pSecond) ;

	tFirst  ->setChecked (false) ;
	tSecond ->setChecked (true ) ;
	tkExit  ->setEnabled (false) ;
	tkSwitch->setEnabled (true ) ;
}

void	TKTest::slotFirst ()
{
	if (tFirst->isChecked())
		showFirst  () ;
	else	showSecond () ;
}

void	TKTest::slotSecond ()
{
	if (tSecond->isChecked())
		showSecond () ;
	else	showFirst  () ;
}

void	TKTest::slotSwitch ()
{
	if (showing == pFirst)
		showSecond () ;
	else	showFirst  () ;
}

void	TKTest::createGUI
	(	TKPart		*part
	)
{
	TKMainWindow::createGUI (part) ;

	if (part == pFirst)
	{	tFirst ->setChecked (true ) ;
		tSecond->setChecked (false) ;
	}
	else
	{	tFirst ->setChecked (false) ;
		tSecond->setChecked (true) ;
	}
}

static	void	myMsgHandler
	(	QtMsgType	type,
		const char	*msg
	)
{
	switch (type)
	{
		case QtDebugMsg   :
			fprintf	(stderr, "Debug: %s\n",   msg) ;
			break	;

		case QtWarningMsg :
			fprintf	(stderr, "Warning: %s\n", msg) ;
			break	;

		case QtFatalMsg	  :
			fprintf	(stderr, "Fatal: %s\n",   msg) ;
			abort	() ;
			break	;

		default	:
			fprintf	(stderr, "Unknown: %s\n",  msg) ;
			abort	() ;
			break	;
	}
}

int	main
	(	int	argc,
		char	*argv[]
	)
{
	qInstallMsgHandler (myMsgHandler) ;

	QApplication app(argc, argv) ;

	new TKTest ()  ;
	app.connect (&app,SIGNAL(lastWindowClosed()), &app, SLOT(quit())) ;
	return	app.exec() ;
}  
