/***************************************************************************
    file	         : tk_dirwatch.cpp
    copyright            : (C) 1999,2000,2001,2002,2003 by Mike Richardson
			   (C) 2000,2001,2002,2003 by theKompany.com
			   (C) 2001,2002,2003 by John Dean
    license              : This file is released under the terms of
                           the GNU General Public License, version 2. The
                           copyright holders retain the right to release
                           this code under diffenent non-exclusive licences.
    email                : mike@quaking.demon.co.uk                                     
 ***************************************************************************/

#include	<qfileinfo.h>

#ifndef 	_WIN32
#include	"tk_dirwatch.moc"
#else
#include	"tk_dirwatch.h"
#endif


TKDirWatchDir::TKDirWatchDir
	(	const QString	&path
	)
	:
	m_dir	(path)
{
	m_lastmod = m_dir.lastModified () ;
}

bool	TKDirWatchDir::dirty ()
{
	QDateTime mod = m_dir.lastModified () ;
	bool	  rc  = mod != m_lastmod ;
	m_lastmod     = mod ;
	return	  rc  ;
}


TKDirWatch::TKDirWatch
	(	int	frequency
	)
{
	m_dirlist.setAutoDelete (true) ;
	connect	(&m_timer, SIGNAL(timeout()), this, SLOT(checkDirs())) ;
	if (frequency > 0) m_timer.start (frequency) ;
}

void	TKDirWatch::addDir
	(	const QString	&path
	)
{
	if (m_dirlist.find (path) == 0)
		m_dirlist.insert (path, new TKDirWatchDir (path)) ;
}

void	TKDirWatch::removeDir
	(	const QString	&path
	)
{
	m_dirlist.remove (path) ;
}

void	TKDirWatch::checkDirs ()
{
	QDictIterator<TKDirWatchDir> iter (m_dirlist) ;
	TKDirWatchDir	*dir ;

	while ((dir = iter.current()) != 0)
	{
		if (dir->dirty ()) emit dirty (iter.currentKey()) ;
		iter += 1 ;
	}
}
