/***************************************************************************
    file	         : tk_locator.cpp
    copyright            : (C) 1999,2000,2001,2002,2003 by Mike Richardson
			   (C) 2000,2001,2002,2003 by theKompany.com
			   (C) 2001,2002,2003 by John Dean
    license              : This file is released under the terms of
                           the GNU General Public License, version 2. The
                           copyright holders retain the right to release
                           this code under diffenent non-exclusive licences.
    email                : mike@quaking.demon.co.uk                                     
 ***************************************************************************/

#include	<stdio.h>
#include	<stdlib.h>

#include	<qstring.h>
#include 	<qdir.h>

#include	"tk_header.h"
#include	"libtkkde_exports.h"

#ifndef _WIN32

static	QString	instdir	= ROOTDIR ;
static	QString	rootdir	= ROOTDIR ;

#define	DATAPATH	"/share/apps/rekall/"
#define	DOCPATH		"/share/doc/HTML/en/rekall/"

/*  locateFile	: Locate a file of specified type			*/
/*  type	: const char *	  : File type				*/
/*  name	: const QString & : File name				*/
/*  (returns)	: QString	  : Path				*/

LIBTKKDE_API
	QString	locateFile
	(	const char	*type,
		const QString	&name
	)
{
	fprintf	(stderr, "locateFile: %s: %s (with %s)\n",
			 type,
			 (const char *)name,
			 (const char *)rootdir) ;

	if (qstrcmp (type, "appdata") == 0)
		return	rootdir + DATAPATH + name ;

	if (qstrcmp (type, "doc") == 0)
		return	rootdir + DOCPATH  + name ;

	return	QString::null ;
}

#else

static	QString instdir = QDir::convertSeparators(QDir::currentDirPath());
static	QString rootdir = QDir::convertSeparators(QDir::currentDirPath() + "\\common");

/*  locateFile	: Locate a file of specified type			*/
/*  type	: const char *	  : File type				*/
/*  name	: const QString & : File name				*/
/*  (returns)	: QString	  : Path				*/

LIBTKKDE_API
	QString	locateFile
	(	const char	*type,
		const QString	&name
	)
{
	fprintf	(stderr, "locateFile: %s: %s (with %s)\n",
			 type,
			 (const char *)name,
			 (const char *)rootdir) ;

	if (qstrcmp (type, "appdata") == 0)
		return	rootdir + SEPSTR "data"  SEPSTR + name ;

	if (qstrcmp (type, "doc") == 0)
		return	rootdir + SEPSTR "doc"   SEPSTR + name ;

	return	QString::null ;
}

#endif

/*  locateDir	: Locate a directory of specified type			*/
/*  type	: const char *	  : Directory type			*/
/*  name	: const QString & : Directory name			*/
/*  (returns)	: QString	  : Path				*/

LIBTKKDE_API
	QString	locateDir
	(	const char	*type,
		const QString	&
	)
{
	/* The name is never used here. The argument exists since under	*/
	/* KDE there seems to be no way to locate an application	*/
	/* directory without naming a file that will be found in it.	*/
	QString	path	= locateFile   (type, "") ;

//	if (!path.isNull())
//		path	= path.left (path.length() - name.length()) ;
//	fprintf	(stderr, "locateDir : %s\n", (const char *)path) ;
	return	path	;
}

/*  setRootDir	: Set different root directory				*/
/*  _rootdir	: const QString & : New root directory name		*/
/*  (returns)	: void		  :					*/

LIBTKKDE_API
	void	setRootDir
	(	const QString	&_rootdir
	)
{
#ifdef	_WIN32
	instdir = _rootdir ;
	rootdir	= _rootdir + "\\common" ;
#else
	rootdir	= _rootdir ;
#endif
	fprintf	(stderr, "setRootDir(%s)\n", (const char *)rootdir) ;
}

/*  getRootDir	: Get root directory					*/
/*  (returns)	: const QString & : Directory name			*/

LIBTKKDE_API
	const QString	&getRootDir ()
{
	fprintf	(stderr, "getRootDir(%s)\n", (const char *)rootdir) ;
	return	rootdir	;
}

/*  getInstDir	: Get installation directory				*/
/*  (returns)	: const QString & : Directory name			*/

LIBTKKDE_API
	const QString	&getInstDir ()
{
	fprintf	(stderr, "getInstDir(%s)\n", (const char *)instdir) ;
	return	instdir	;
}
