/***************************************************************************
    file	         : tk_xmlguispec.h
    copyright            : (C) 1999,2000,2001,2002,2003 by Mike Richardson
			   (C) 2000,2001,2002,2003 by theKompany.com
			   (C) 2001,2002,2003 by John Dean
    license              : This file is released under the terms of
                           the GNU General Public License, version 2. The
                           copyright holders retain the right to release
                           this code under diffenent non-exclusive licences.
    email                : mike@quaking.demon.co.uk                                     
 ***************************************************************************/

#ifndef	__TK_XMLGUISPEC_H
#define	__TK_XMLGUISPEC_H

#include	<qlist.h>
#include	<qdom.h>
#include	<qstring.h>
#include	<qmenubar.h>
#include	<qtoolbar.h>

#include	"tk_action.h"

#include 	"libtkkde_exports.h"

class	LIBTKKDE_API TKXMLGUISpec
{
	QList<QDomDocument>	m_XMLSpecs	;
	TKActionCollection	*m_collection	;

	void	buildMenuPopup	(QPopupMenu *, const QDomElement &) ;
	void	buildMenuBar	(QMenuBar   *, const QDomElement &) ;
	void	buildToolBar	(QToolBar   *, const QDomElement &) ;

	QPopupMenu
		*findPopup	(QMenuData *, const QString &) ;

public	:

	TKXMLGUISpec	() ;
	virtual	~TKXMLGUISpec	() ;

	virtual	TKAction	*action		  (const QDomElement	&) const ;
	TKAction		*action		  (const char		*) const ;
	bool			setXMLFile	  (const QString &, bool = false) ;
	void			buildGUI	  (QMenuBar   *, QToolBar *) ;
	void			buildGUI	  (QPopupMenu *, QToolBar *) ;

	TKActionCollection	*actionCollection () ;

}	;

LIBTKKDE_API	const QString	&getAppdataDir	()	;
LIBTKKDE_API	void		setAppdataDir	(const QString &) ;

#endif	// __TK_XMLGUISPEC_H
