/*
    Copyright (C) 2001-2002 by theKompany.com <www.thekompany.com>
    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
    See COPYING.GPL file.

    In addition, as a special exception, theKompany.com gives permission
    to link the code of this program with the tkwidgets library (or with
    modified versions of tkwidgets that use the same license as tkwidgets),
    and distribute linked combinations including the two.  You must obey
    the GNU General Public License in all respects for all of the code used
    other than tkwidgets.  If you modify this file, you may extend this
    exception to your version of the file, but you are not obligated to do so.
    If you do not wish to do so, delete this exception statement from your
    version.

    This license grants you the ability to use tkwidgets with Rekall only
    and may not be used outside of Rekall.
    See also http://www.rekall.a-i-s.co.uk/products/license.txt for details.
*/


#ifndef _WIN32
#include "tktextmanager.moc"
#else
#include "tktextmanager.h"
#endif

#include "tktextview.h"
#include "tktexteditor.h"
#include "tktextdoc.h"
#include "tkhighlight.h"

#include <qpaintdevicemetrics.h>
#include <qprinter.h>

#include <stdlib.h>

/*
TKTextMarginManager::TKTextMarginManager()
{
  TKTextEditorManager::self()->registerMarginManager(this);
}

TKTextMarginManager::~TKTextMarginManager()
{
  TKTextEditorManager::self()->unregisterMarginManager(this);
}
*/
/************************************************************************/
/*
TKTextEditorManager *TKTextEditorManager::self()
{
  static TKTextEditorManager *stthis = 0;
  if (!stthis)
    stthis = new TKTextEditorManager();
  return stthis;
}
*/
TKTextEditorManager::TKTextEditorManager()
: QObject()
{
  QFont f;//("etl-fixed", 14);
  setFont(f);

#ifndef QT_NO_PRINTER
//  printer = new QPrinter();
#endif
  fCursorWrap = false;
  fSaveTab = false;
  fVerticalSelection = false;
  fOvr = false;
  fAutoIndent = true;
  // by deafult DO NOT remove spaces
  fRemoveSpaces = false;
  fBackspaceIndent = true;
  fSmartHome = true;

  fIndicatorMargin = true;
  fSelectionMargin = true;
#ifdef KOBOL
	run_line = -1;
#else
  fLinuNumberMargin = true;
#endif

  tabWidthValue = 8;

  margins.setRect(30, 30, 30, 30);
  setMargins(margins);

  normalBackgroundColor   = Qt::white;
  selectedBackgroundColor = QColor("#d0d0d0");
  foundBackgroundColor    = QColor("#a0a0a0");

  setResourcesDir(getenv("QTDIR"));
}
/*
void TKTextEditorManager::registerMarginManager(TKTextMarginManager *m)
{
  static int id = 0;
  marginManagers.insert(new int(id++), m);
}

void TKTextEditorManager::unregisterMarginManager(TKTextMarginManager *m)
{
  QPtrDictIterator<TKTextMarginManager> it(marginManagers);
  for (; it.current(); ++it)
    if (it.current() == m) {
      marginManagers.remove(it.currentKey());
      break;
    }
}
*/
void TKTextEditorManager::setResourcesDir(const QString &dir)
{
  resDir = dir;
}

QString TKTextEditorManager::resourcesDir()
{
  return resDir;
}

void TKTextEditorManager::setLocalResourcesDir( const QString &dir )
{
  localResDir = dir;
}


QString TKTextEditorManager::localResourcesDir()
{
  return localResDir.isEmpty() ? resDir + "/local/" : localResDir;
}

void TKTextEditorManager::setHlSettingsKey(const QString &key)
{
  hlSettings = key;
}

QString TKTextEditorManager::hlSettingsKey()
{
  return hlSettings;
}
/*
int TKTextEditorManager::textMarginClassId(TKTextMarginManager *m)
{
  QPtrDictIterator<TKTextMarginManager> it(marginManagers);
  for (; it.current(); ++it)
    if (it.current() == m)
      return *((int *)it.currentKey());
  return -1;
}

QPixmap TKTextEditorManager::marginIcon(int classId, int itemId)
{
  QPtrDictIterator<TKTextMarginManager> it(marginManagers);
  for (; it.current(); ++it)
    if (*((int *)it.currentKey()) == classId)
      return it.current()->icon(itemId);

  return QPixmap();
}
*/
TKTextEditorManager::~TKTextEditorManager()
{
#ifndef QT_NO_PRINTER
//  delete printer;
#endif
}

TKTextEditor* TKTextEditorManager::createEditor(QWidget *parent, TKTextDocument *doc, const char *name)
{
  if (!doc) {
    doc = new TKTextDocument(this);
    connect(doc, SIGNAL(destroyed()), SLOT(docDestroyed()));
    documents.append(doc);
  }
  TKTextEditor *editor = new TKTextEditor(doc, parent, name);
  connect(editor, SIGNAL(destroyed()), SLOT(editorDestroyed()));
  editors.append(editor);
  return editor;
}

void TKTextEditorManager::addEditor(TKTextEditor *editor, TKTextDocument *doc)
{
  if (doc) {
    connect(doc, SIGNAL(destroyed()), SLOT(docDestroyed()));
    documents.append(doc);
  }

  connect(editor, SIGNAL(destroyed()), SLOT(editorDestroyed()));
  editors.append(editor);
}

void TKTextEditorManager::docDestroyed()
{
  documents.remove((TKTextDocument *)sender());
}

void TKTextEditorManager::editorDestroyed()
{
  editors.remove((TKTextEditor *)sender());
}

void TKTextEditorManager::setMargins(const QRect &m)
{
  margins = m;
#ifndef QT_NO_PRINTER
//  QPaintDeviceMetrics metrics(printer);
//  int dpix = metrics.logicalDpiX();
//  int dpiy = metrics.logicalDpiY();
//  QRect body(margins.x() * dpix / 72,
//             margins.y() * dpiy / 72,
//             metrics.width() - (margins.x() + margins.width()) * dpix / 72,
//             metrics.height() - (margins.y() + margins.height()) * dpiy / 72);
//
//  printWidth = body.width();
//
//  for (TKTextDocument *document = documents.first(); document; document = documents.next()) {
//    document->tagAll();
//    document->updateViews();
//  }
#endif
}

bool TKTextEditorManager::setupPrinter()
{
#ifndef QT_NO_PRINTER
//  if (!printer->setup())
//    return false;
//
//  setMargins(margins);
  return true;
#else
  return false;
#endif
}

void TKTextEditorManager::setFont(const QFont &f)
{
  fonts[0].set(f, false, false);
  fonts[1].set(f, false, true);
  fonts[2].set(f, true, false);
  fonts[3].set(f, true, true);
  fnt = f;

  for (TKTextDocument *document = documents.first(); document; document = documents.next())
    document->updateFontData();
}

void TKTextEditorManager::updateMarginsState()
{
  for (TKTextEditor *editor = editors.first(); editor; editor = editors.next())
    editor->textView()->updateMarginsState();
}

int TKTextEditorManager::width(int type, QChar &c)
{
  return (fonts[type].width < 0) ? fonts[type].fm->width(c) : fonts[type].width;
}

int TKTextEditorManager::width(int type, const QString &s)
{
  return (fonts[type].width < 0) ? fonts[type].fm->width(s) : s.length() * fonts[type].width;
}

QFont &TKTextEditorManager::font(int type) const
{
	return *fonts[type].font;
}

void TKTextEditorManager::editorActivated(TKTextEditor *editor)
{
  emit activate(editor);
}

bool TKTextEditorManager::isIndicatorMarginVisible()
{
  return fIndicatorMargin;
}

#ifndef KOBOL
bool TKTextEditorManager::isLinuNumberMarginVisible()
{
  return fLinuNumberMargin;
}
#endif

bool TKTextEditorManager::isSelectionMarginVisible()
{
  return fSelectionMargin;
}

void TKTextEditorManager::setIndicatorMarginVisible(bool f)
{
  fIndicatorMargin = f;
  updateMarginsState();
}

void TKTextEditorManager::setLinuNumberMarginVisible(bool f)
{
#ifndef KOBOL
  fLinuNumberMargin = f;
  updateMarginsState();
#endif
}

void TKTextEditorManager::setSelectionMarginVisible(bool f)
{
  fSelectionMargin = f;
  updateMarginsState();
}

void TKTextEditorManager::setOverwriteMode(bool f)
{
  fOvr = f;
  emit overwriteModeChanged();
}

bool TKTextEditorManager::overwriteMode()
{
  return fOvr;
}

QStringList TKTextEditorManager::highlightsNames()
{
  QStringList names;
  HighlightDataDict *dict = TKTextHighlightManager::highlights(this);
  QDictIterator<TKHighlightData> it(*dict);
  for (; it.current(); ++it)
    names << it.currentKey();
  return names;
}

void TKTextEditorManager::setVerticalSelection(bool f)
{
  fVerticalSelection = f;
  for (TKTextDocument *document = documents.first(); document; document = documents.next()) {
    document->tagAll();
    document->updateViews();
  }
}

int TKTextEditorManager::tabWidth()
{
  return tabWidthValue;
}

void TKTextEditorManager::setTabWidth(int width)
{
  tabWidthValue = width;
  for (TKTextDocument *document = documents.first(); document; document = documents.next())
    document->setTabWidth(width);
}

#ifdef KOBOL
int TKTextEditorManager::runLine()
{
	return run_line;
}

void TKTextEditorManager::setRunLine(int l)
{
	run_line = l;
}
#endif // KOBOL

void TKTextEditorManager::updateHighlight()
{
  for (TKTextDocument *document = documents.first(); document; document = documents.next())
  {
    document->setHighlight(document->highlight()->name());
  }
}
