/***************************************************************************
    file	         : kb_wizdblist.cpp
    copyright            : (C) 1999,2000,2001,2002,2003 by Mike Richardson
			   (C) 2000,2001,2002,2003 by theKompany.com
			   (C) 2001,2002,2003 by John Dean
    license              : This file is released under the terms of
                           the GNU General Public License, version 2. The
                           copyright holders retain the right to release
                           this code under diffenent non-exclusive licences.
    email                : mike@quaking.demon.co.uk                                     
 ***************************************************************************/

#include	"kb_classes.h"
#include	"kb_database.h"
#include	"kb_serverinfo.h"

#include	"kb_wizdblist.h"


KBWizardCtrlDBList::KBWizardCtrlDBList
	(	KBWizardPage		*page,
		const QDomElement	&elem
	)
	:
	KBWizardCtrl	(page, elem.attribute("name"))
{
	setWidget (m_dbList = new QComboBox (page)) ;

	connect
	(	m_dbList,
		SIGNAL(activated  (int)),
		SLOT  (ctrlChanged())
	)	;
	connect
	(	m_dbList,
		SIGNAL(textChanged(const QString &)),
		SLOT  (ctrlChanged())
	)	;

	m_dbList->setEditable (true) ;
}

KBWizardCtrlDBList::~KBWizardCtrlDBList ()
{
}

void	KBWizardCtrlDBList::setValue
	(	const QString	&value
	)
{
	for (int idx = 0 ; idx < m_dbList->count() ; idx += 1)
		if (m_dbList->text(idx) == value)
		{	m_dbList->setCurrentItem (idx) ;
			break	;
		}
}

/*  KBWizardCtrlDBList							*/
/*  value	: Get value						*/
/*  (returns)	: QString	: Value					*/

QString	KBWizardCtrlDBList::value ()
{
	return	m_dbList->currentText () ;
}


void	KBWizardCtrlDBList::loadDatabases ()
{
	QString	 dbType	 = page()->wizard()->findCtrl("*", "dbType"  )->value() ;
	QString	 host	 = page()->wizard()->findCtrl("*", "host"    )->value() ;
	QString	 port	 = page()->wizard()->findCtrl("*", "port"    )->value() ;
	QString	 username= page()->wizard()->findCtrl("*", "username")->value() ;
	QString	 password= page()->wizard()->findCtrl("*", "password")->value() ;

	fprintf
	(	stderr,
		"KBWizardCtrlDBList::loadDatabases: t=[%s] h=[%s:%s] u=[%s] p=[%s]\n",
		(cchar *)dbType,
		(cchar *)host,
		(cchar *)port,
		(cchar *)username,
		(cchar *)password
	)	;
	KBServer *server = dbType.isEmpty() ? 0 : getDriverServer(dbType) ;

	if (server == 0) return ;

	KBServerInfo info (0, 0, dbType, host, 0, username, password) ;
	if (!port.isEmpty()) info.setPort (port) ;

	if (!server->connect (&info))
	{	server->lastError().DISPLAY() ;
		delete	server	;
		return	;
	}

	QStringList dbNames ;
	if (!server->listDatabases (dbNames))
	{	server->lastError().DISPLAY() ;
		delete	server	;
		return	;
	}

	QString	current	= m_dbList->currentText() ;

	m_dbList->clear () ;
	m_dbList->insertStringList (dbNames) ;

	for (int idx = 0 ; idx < m_dbList->count() ; idx += 1)
		if (m_dbList->text(idx) == current)
		{	m_dbList->setCurrentItem (idx) ;
			break	;
		}

	delete	server	;
}

/*  KBWizardCtrlDBList							*/
/*  pageShown	: Control is being shown as used enters page		*/
/*  next	: bool		: Moving to next page			*/
/*  (returns)	: void		:					*/

void	KBWizardCtrlDBList::pageShown
	(	bool		next
	)
{
	/* If moving to the next page then load the databases. No need	*/
	/* on previous since they should not have changed and we do not	*/
	/* want to disturb the user's selection.			*/
	if (next) loadDatabases () ;
}

bool	KBWizardCtrlDBList::ok ()
{
	return	!m_dbList->currentText().isEmpty() ;
}

WIZARDCTRLREG(DBList)
