/***************************************************************************
    file	         : kb_copierlist.cpp
    copyright            : (C) 1999,2000,2001,2002,2003 by Mike Richardson
			   (C) 2000,2001,2002,2003 by theKompany.com
			   (C) 2001,2002,2003 by John Dean
    license              : This file is released under the terms of
                           the GNU General Public License, version 2. The
                           copyright holders retain the right to release
                           this code under diffenent non-exclusive licences.
    email                : mike@quaking.demon.co.uk                                     
 ***************************************************************************/

#include	<errno.h>

#include 	<qcursor.h>
#include 	<qpopupmenu.h>

#include	"kb_classes.h"
#include	"kb_location.h"
#include	"kb_dbinfo.h"
#include	"kb_listitem.h"
#include	"kb_viewer.h"

#ifndef 	_WIN32
#include	"kb_copierlist.moc"
#else
#include 	"kb_copierlist.h"
#endif

/*  KBCopierList							*/
/*  KBCopierList: Constructor for copier list widget			*/
/*  parent	: QWidget *	: Parent widget				*/
/*  dbInfo	: KBDBInfo *	: Database information object		*/
/*  (returns)	: KBCopierList	:					*/

KBCopierList::KBCopierList
	(	QWidget		*parent,
		KBDBInfo	*dbInfo
	)
	:
	KBFileList
	(	parent,
		dbInfo,
		"Create new copier",
		"copier",
		"copier",
		"Copier name"
	)
{
}

/*  KBCopierList							*/
/*  ~KBCopierList: Destructor for copier list widget			*/
/*  (returns)	 :		:					*/

KBCopierList::~KBCopierList ()
{
}

/*  KBCopierList								*/
/*  showServerMenu : Show popup menu for server entries			*/
/*  (returns)	   : void	:					*/

void	KBCopierList::showServerMenu ()
{
	QPopupMenu pop ;
	pop.insertItem (TR("Cancel")) ;
	pop.insertSeparator () ;
	pop.insertItem (TR("&Reload copier list"), this, SLOT(reloadServer())) ;
	pop.insertItem (TR("&Copy to server ..."), this, SLOT(copyToServer())) ;
	pop.exec       (QCursor::pos()) ;
}

/*  KBCopierList								*/
/*  showObjectMenu : Show popup menu for server entries			*/
/*  (returns)	   : void	:					*/

void	KBCopierList::showObjectMenu ()
{
	QPopupMenu pop ;
	pop.insertItem (TR("Cancel")) ;
	pop.insertItem (TR("&Execute"),    	this, SLOT(showAsData  ())) ;
	pop.insertItem (TR("&Design"),    	this, SLOT(showAsDesign())) ;
	pop.insertItem (TR("&Rename copier"),  	this, SLOT(renameCopier())) ;
	pop.insertItem (TR("De&lete copier"),  	this, SLOT(deleteCopier())) ;
	pop.insertItem (TR("&Save to file"),   	this, SLOT(saveToFile  ())) ;
	pop.exec       (QCursor::pos()) ;
}

/*  KBCopierList							*/
/*  renameCopier: Rename a copier					*/
/*  (returns)	: void		:					*/

void	KBCopierList::renameCopier ()
{
	rename	(m_curItem) ;
}

/*  KBCopierList							*/
/*  deleteCopier: Delete a copier					*/
/*  (returns)	: void		:					*/

void	KBCopierList::deleteCopier ()
{
	delobj	(m_curItem) ;
}
