/***************************************************************************
    file	         : kb_querywidget.h
    copyright            : (C) 1999,2000,2001,2002,2003 by Mike Richardson
			   (C) 2000,2001,2002,2003 by theKompany.com
			   (C) 2001,2002,2003 by John Dean
    license              : This file is released under the terms of
                           the GNU General Public License, version 2. The
                           copyright holders retain the right to release
                           this code under diffenent non-exclusive licences.
    email                : mike@quaking.demon.co.uk                                     
 ***************************************************************************/

#ifndef	__KB_QUERYWIDGET_H
#define	__KB_QUERYWIDGET_H

#include	<qlayout.h>
#include	<qgroupbox.h>
#include	<qcombobox.h>
#include	<qlistbox.h>
#include	<qpushbutton.h>

#include	"kb_copybase.h"
#include	"kb_copyquery.h"
#include	"kb_fieldchooser.h"


/*  KBQueryWidget							*/
/*  -------------							*/
/*  This is the copied widget which provides the user GUI interface to	*/
/*  the query copier object.						*/

class	KBQueryWidget : public QWidget, public KBCopyQuery
{
	Q_OBJECT

	QObject		*part		;

	bool		srce		;
	KBLocation	location	;

	QVBoxLayout	*layMain	;
	QHBoxLayout	*layQuery	;
	QHBoxLayout	*laySelect	;
	QHBoxLayout	*layExpr	;
	QVBoxLayout	*layButton	;

	QComboBox	cbServer	;
	QComboBox	cbQuery		;

	QListBox	lbFields	;
	QListBox	lbSelect	;
	QPushButton	bAdd		;
	QPushButton	bAddAll		;
	QPushButton	bRemove		;
	QPushButton	bUp		;
	QPushButton	bDown		;

#if	! __KB_EMBEDDED
	QGroupBox	gbBottom	;
#endif
	QWidget		wBottom		;
	QLabel		*lWhere		;
	QLineEdit	*eWhere		;
	QLabel		*lOrder		;
	QLineEdit	*eOrder		;

	QLabel		*lExpr		;
	QLineEdit	*eExpr		;
	QPushButton	*bExpr		;

	QGridLayout	*layBottom	;

	KBFieldChooser	fldChooser	;

	void		saveall		() ;

signals	:

	void		changed		() ;

protected slots	:

	void		clickExpr	()	;

public	:

	KBQueryWidget	(QWidget *parent, QObject *, bool, KBLocation &) ;

	bool		valid		(KBError     &) ;
	void		def		(QDomElement &) ;
	bool		set		(QDomElement &, KBError &) ;
}	;
#endif	// __KB_QUERYWIDGET_H
