/***************************************************************************
    file	         : kb_formbase.cpp
    copyright            : (C) 1999,2000,2001,2002,2003 by Mike Richardson
			   (C) 2000,2001,2002,2003 by theKompany.com
			   (C) 2001,2002,2003 by John Dean
    license              : This file is released under the terms of
                           the GNU General Public License, version 2. The
                           copyright holders retain the right to release
                           this code under diffenent non-exclusive licences.
    email                : mike@quaking.demon.co.uk                                     
 ***************************************************************************/

#include	<errno.h>
#include	<time.h>

#include	<qwidget.h>


#include	"kb_classes.h"
#include	"kb_type.h"
#include	"kb_value.h"
#include	"kb_attrdict.h"
#include	"kb_database.h"
#include	"kb_gui.h"
#include	"kb_dbinfo.h"
#include	"kb_dblink.h"
#include	"kb_display.h"
#include	"kb_form.h"
#include	"kb_options.h"
#include	"kb_string.h"
#include	"kb_nodereg.h"
#include	"kb_parse.h"
#include	"kb_docroot.h"
#include	"kb_viewer.h"
#include	"kb_build.h"

#include	"kb_formviewer.h"

#include	"kb_objbase.h"

#ifndef 	_WIN32
#include	"kb_formbase.moc"
#else
#include 	"kb_formbase.h"
#endif

#include	"kb_formlist.h"

/*  KBFormBase	:							*/
/*  KBFormBase	: Constructor for base object for forms			*/
/*  parent	: QObject *	: Parent object				*/
/*  name	: cchar *	: Object name				*/
/*  (returns)	: KBForm	:					*/

KBFormBase::KBFormBase
	(	QObject		*parent,
		cchar		*name
	)
	:
	KBObjBase (parent, name)
{
	m_docRoot = 0 ;
	m_viewer  = 0 ;
}

/*  KBFormBase	:							*/
/*  ~KBFormBase	: Destructor for base object for forms			*/
/*  (returns)	:		:					*/

KBFormBase::~KBFormBase ()
{
	DELOBJ (m_docRoot) ;
}

/*  KBFormBase	:							*/
/*  build	: Build an instance of an object			*/
/*  _location	: KBLocation &	  : Object location			*/
/*  _create	: bool		  : Creating a new object		*/
/*  pDict	: QDict<QString>& : Parameter dictionary		*/
/*  pError	: KBError &	  : Error return			*/
/*  (returns)	: bool		  :					*/

bool	KBFormBase::build
	(	KBLocation	&location,
		bool		create,
		KBError		&pError
	)
{
	setLocation (location) ;

#if	! __KB_RUNTIME
	if (create)
	{
		KBAttrDict	aList	;

		aList.addValue ("language", "py"	 ) ;
		aList.addValue ("autosync", "Yes"	 ) ;
		aList.addValue ("rowcount", "1"	  	 ) ;
		aList.addValue ("name",	    "UnnamedForm") ;
		aList.addValue ("w",	    KBOptions::getFormWidth ()) ;
		aList.addValue ("h",	    KBOptions::getFormHeight()) ;
		aList.addValue ("dx",	    KBOptions::getDefaultDX ()) ;
		aList.addValue ("dy",	    KBOptions::getDefaultDY ()) ;
		aList.addValue ("modal",    KBOptions::getFormsModal() ? "Yes" : "No") ;

		bool	ok ;
		m_docRoot	= new KBForm (getLocation(), aList, ok) ;
		if (!ok)
		{	pError	= KBError
				  (	KBError::Warning,
					TR("User cancel"),
					QString::null,
					__ERRLOCN
				  )	;
			return	false	;
		}
	}
	else
#endif
	{
		QByteArray doc ;

		if (!getLocation().contents (doc, pError))
			return	false	;

		if ((m_docRoot = KBOpenFormText (getLocation(), doc, pError)) == 0)
			return	false	;
	}

	return	true	;
}

/*  KBFormBase	:							*/
/*  show	: Show form						*/
/*  showAs	: KB::ShowAs	  : Display mode			*/
/*  pDict	: QDict<QString> &: Parameter dictionary		*/
/*  embed	: QWidget *	  : Widget into which to embed display	*/
/*  pError	: KBError &	  : Error return			*/
/*  key		: const KBValue & : Parent key				*/
/*  rDict	: QDict<QString> *: Results dictionary			*/
/*  (returns)	: KB::ShowRC	  : Startup result			*/

KB::ShowRC
	KBFormBase::show
	(	KB::ShowAs		showAs,
		const QDict<QString>	&pDict,
		QWidget			*embed,
		KBError			&pError,
		const KBValue		&key,
		QDict<QString>		*rDict
	)
{
	QString	*override = pDict.find ("__showAs") ;

	if (override != 0)
		showAs = showAsCode (*override, showAs) ;

	if (m_viewer == 0)
	{
		bool	modal	= ((KBAttrBool *)m_docRoot->getAttr("modal"))->getBoolValue() ;

		fprintf
		(	stderr,
			"KBFormBase::show: modal=[%d] key=[%s]\n",
			modal,
			(cchar *)key.getRawText()
		)	;

		m_viewer = new KBFormViewer
			   (		this,
					embed,
					pDict,
					modal
			   )	;

		setPart	(m_viewer, modal) ;

		KB::ShowRC rc = m_viewer->startup
				(	m_docRoot,
					showAs,
					key,
					pError
				) ;

		if (rc == KB::ShowRCModal)
		{
			fprintf
			(	stderr,
				"KBFormBase::show: KB::ShowRCModal [%p]\n",
				(void *)rDict
			)	;

			/* If we were passed a results dictionary then	*/
			/* use this to pick up the results. This is the	*/
			/* code that allows modal forms to be used as	*/
			/* dialogs.					*/
			if (m_rc  == 0)
				return	KB::ShowRCCancel ;

			if (rDict != 0)
				m_docRoot->getResults (QString::null, *rDict) ;

			return	KB::ShowRCModal ;
		}

		if (rc != KB::ShowRCOK)
		{
			delete	m_viewer ;
			return	rc	 ;
		}

		return	KB::ShowRCOK ;
	}

	KBPartWidget *pw = m_viewer->getPartWidget() ;
	pw->show		() ;
	pw->raise		() ;
	pw->setActiveWindow	() ;

	m_viewer->showAs(showAs);
	return	KB::ShowRCOK	;
}

QString	KBFormBase::def ()
{
	QString	text	;
	m_docRoot->printNode (text, 0) ;
	return	text	;
}

void	KBFormBase::widgetClosing ()
{
	DELOBJ (m_docRoot) ;
}

/*  -----------------------------------------------------------------  */


KBFACTORYIMPL
(	KBFormFactory,
	formview,
	"Rekall form viewer",
	"Plugin",
	"0",
	"7",
	"0"
)

QObject	*KBFormFactory::create
	(	QObject		  *parent,
		cchar		  *name,
		cchar		  *className,
		const QStringList &
	)
{
	if ((className != 0) && (strcmp (className, "browser") == 0))
		return	new KBFormList ((QWidget *)parent, (KBDBInfo *)name) ;

	return	new	KBFormBase (parent) ;
}

cchar	*KBFormFactory::ident ()
{
	return	__KB_BUILD_IDENT	;
}
