/***************************************************************************
    file	         : kb_macrobase.cpp
    copyright            : (C) 1999,2000,2001,2002,2003 by Mike Richardson
			   (C) 2000,2001,2002,2003 by theKompany.com
			   (C) 2001,2002,2003 by John Dean
    license              : This file is released under the terms of
                           the GNU General Public License, version 2. The
                           copyright holders retain the right to release
                           this code under diffenent non-exclusive licences.
    email                : mike@quaking.demon.co.uk                                     
 ***************************************************************************/

#include	<qwidget.h>


#include	"kb_classes.h"
#include	"kb_type.h"
#include	"kb_value.h"
#include	"kb_attrdict.h"
#include	"kb_database.h"
#include	"kb_gui.h"
#include	"kb_dbinfo.h"
#include	"kb_dblink.h"
#include	"kb_display.h"
#include	"kb_options.h"
#include	"kb_string.h"
#include	"kb_nodereg.h"
#include	"kb_parse.h"
#include	"kb_docroot.h"
#include	"kb_viewer.h"
#include	"kb_build.h"

#include	"kb_classes.h"


#include	"kb_objbase.h"

#ifndef 	_WIN32
#include	"kb_macrobase.moc"
#else
#include 	"kb_macrobase.h"
#endif

#include	"kb_macrolist.h"


/*  KBMacroBase								*/
/*  KBMacroBase	: Constructor for base object for macros		*/
/*  parent	: QObject *	: Parent object				*/
/*  name	: cchar *	: Object name				*/
/*  (returns)	: KBForm	:					*/

KBMacroBase::KBMacroBase
	(	QObject		*parent,
		cchar		*name
	)
	:
	KBObjBase (parent, name)
{
	m_viewer  = 0 ;
}

/*  KBMacroBase								*/
/*  ~KBMacroBase							*/
/*		: Destructor for base object for components		*/
/*  (returns)	:		:					*/

KBMacroBase::~KBMacroBase ()
{
}

/*  KBMacroBase	:							*/
/*  build	: Build an instance of an object			*/
/*  location	: KBLocation &	  : Object location			*/
/*  create	: bool		  : Creating a new object		*/
/*  pDict	: QDict<QString>& : Parameter dictionary		*/
/*  pError	: KBError &	  : Error return			*/
/*  (returns)	: bool		  :					*/

bool	KBMacroBase::build
	(	KBLocation	&location,
		bool		create,
		KBError		&pError
	)
{
	setLocation (location) ;

	if (!create)
	{
		if (!getLocation().contents (m_doc, pError))
			return	false	;
	}

	return	true	;
}

/*  KBMacroBase	:							*/
/*  show	: Show form						*/
/*  showAs	: KB::ShowAs	  : Display mode, always design		*/
/*  pDict	: QDict<QString> &: Parameter dictionary		*/
/*  embed	: QWidget *	  : Widget into which to embed display	*/
/*  pError	: KBError &	  : Error return			*/
/*  key		: const KBValue & : Parent key				*/
/*  rDict	: QDict<QString>* : Results dictionary			*/
/*  (returns)	: KB::ShowRC	  : Startup result			*/

KB::ShowRC
	KBMacroBase::show
	(	KB::ShowAs		,
		const QDict<QString>	&,
		QWidget			*embed,
		KBError			&pError,
		const KBValue		&,
		QDict<QString>		*
	)
{
	if (m_viewer == 0)
	{
		m_viewer = new KBMacroViewer (this, embed) ;
		setPart	(m_viewer, false) ;

		KB::ShowRC rc = m_viewer->startup (m_doc, pError) ;
		if (rc != KB::ShowRCOK)
		{
			delete	m_viewer;
			return	rc	;
		}

		return	KB::ShowRCOK	;
	}

	m_viewer->widget()->setFocus()	;
	return	KB::ShowRCOK ;
}

QString	KBMacroBase::def ()
{
	return	m_viewer->def() ;
}

void	KBMacroBase::widgetClosing ()
{
}


/*  -----------------------------------------------------------------  */

KBFACTORYIMPL
(	KBMacroFactory,
	macroview,
	"Rekall macro viewer",
	"Plugin",
	"0",
	"7",
	"0"
)


QObject	*KBMacroFactory::create
	(	QObject		  *parent,
		cchar		  *name,
		cchar		  *className,
		const QStringList &
	)
{
	if ((className != 0) && (strcmp (className, "browser") == 0))
		return	new KBMacroList ((QWidget *)parent, (KBDBInfo *)name) ;

	return	new KBMacroBase (parent) ;
}

cchar	*KBMacroFactory::ident ()
{
	return	__KB_BUILD_IDENT	;
}
