/***************************************************************************
    file	         : kb_macroviewer.cpp
    copyright            : (C) 1999,2000,2001,2002,2003 by Mike Richardson
			   (C) 2000,2001,2002,2003 by theKompany.com
			   (C) 2001,2002,2003 by John Dean
    license              : This file is released under the terms of
                           the GNU General Public License, version 2. The
                           copyright holders retain the right to release
                           this code under diffenent non-exclusive licences.
    email                : mike@quaking.demon.co.uk                                     
 ***************************************************************************/

#include	<qwidget.h>
#include	<qguardedptr.h>
#include	<qlayout.h>
#include	<qsplitter.h>

#include	"tk_messagebox.h"


#include	"kb_classes.h"
#include	"kb_type.h"
#include	"kb_value.h"
#include	"kb_database.h"
#include	"kb_gui.h"
#include	"kb_dbinfo.h"
#include	"kb_dblink.h"
#include	"kb_string.h"
#include	"kb_options.h"
#include	"kb_viewer.h"

#ifndef 	_WIN32
#include	"kb_macroviewer.moc"
#else
#include 	"kb_macroviewer.h"
#endif



/*  KBMacroViewer							*/
/*  KBMacroViewer							*/
/*		: Constructor for macor viewer object			*/
/*  KBObjBase	: QObject	: Parent object				*/
/*  embed	: QWidget *	: Embedding widget			*/
/*  (returns)	: KBMacroViewer	:					*/

KBMacroViewer::KBMacroViewer
	(	KBObjBase		*parent,
		QWidget			*embed
	)
	:
	KBViewer (parent, embed, WDestructiveClose|WStyle_NormalBorder)
{
	m_gui		= new KBaseGUI (this, this, "rekallui.macro") ;
	m_editor	= new KBMacroEditor
			  (	m_partWidget,
				getLocation().dbInfo,
				getLocation().docLocn
			  )	;
	m_topWidget	= m_editor ;

	connect	(m_editor, SIGNAL(changed()), SLOT(slotChanged())) ;
}

/*  KBMacroViewer							*/
/*  ~KBMacroViewer							*/
/*		: Destructor for component viewer			*/
/*  (returns)	: void		:					*/

KBMacroViewer::~KBMacroViewer ()
{
}

void	KBMacroViewer::slotChanged ()
{
	m_gui->setEnabled ("KB_saveDoc", true) ;
}

/*  KBMacroViewer							*/
/*  startup	: Startup macro viewer object				*/
/*  doc		: QByteArray &	: Macro definition			*/
/*  pError	: KBError &	: Error return				*/
/*  (returns)	: KB::ShowRC	: Startup success			*/

KB::ShowRC
	KBMacroViewer::startup
	(	QByteArray	&doc,
		KBError		&pError
	)
{
	setGUI	(m_gui) ;

	KB::ShowRC rc = m_editor->startup (doc, pError) ;
	if (rc != KB::ShowRCOK) return rc ;

	m_topWidget	->show  () ;
	m_partWidget	->resize(620, 500, true, false) ;
	m_partWidget	->show  (false, KB::ShowAuto  ) ;

	return	KB::ShowRCOK	;
}

/*  KBMacroViewer							*/
/*  getChanged	: Report whether there are unsaved changes		*/
/*  both	: bool		: True for both data and design change	*/
/*  (returns)	: cchar *	: Changed message or null if none	*/

cchar	*KBMacroViewer::getChanged
	(	bool	
	)
{
	return	m_editor->getChanged() ? "macro" : 0 ;
}

/*  KBMacroViewer							*/
/*  def		: Get definition as XML					*/
/*  (returns)	: QString	: XML definition			*/

QString	KBMacroViewer::def ()
{
	KBError	error ;
	return	m_editor->def(error) ;
}

/*  KBMacroViewer							*/
/*  showAs	: Show document in specified mode			*/
/*  _showAs	: KB::ShowAs	: Specified mode			*/
/*  (returns)	: void		:					*/

void	KBMacroViewer::showAs
	(	KB::ShowAs	
	)
{
}

/*  KBMacroViewer							*/
/*  saveDocumentAs: Save document under specified name			*/
/*  (returns)	  : void	:					*/

void	KBMacroViewer::saveDocumentAs ()
{
	m_objBase->saveDocumentAs() ;
	m_gui->setEnabled ("KB_saveDoc", false) ;
}

/*  KBMacroViewer							*/
/*  saveDocument: Save document						*/
/*  (returns)	: void		:					*/

void	KBMacroViewer::saveDocument ()
{
	m_objBase->saveDocument() ;
	m_gui->setEnabled ("KB_saveDoc", false) ;
}

/*  KBMacroViewer							*/
/*  queryClose	: Query whether to close				*/
/*  (returns)	: bool		: True to allow close			*/

bool	KBMacroViewer::queryClose ()
{
	cchar	*cmsg	;

	if ((cmsg = getChanged (true)) != 0)
		if (TKMessageBox::questionYesNo
			(	0,
				QString(TR("Macro %1 changed: close anyway?")).arg(cmsg)
			)	!= TKMessageBox::Yes
		   )	return	false	;

	return	true	;
}
