/***************************************************************************
    file	         : kb_queryviewer.cpp
    copyright            : (C) 1999,2000,2001,2002,2003 by Mike Richardson
			   (C) 2000,2001,2002,2003 by theKompany.com
			   (C) 2001,2002,2003 by John Dean
    license              : This file is released under the terms of
                           the GNU General Public License, version 2. The
                           copyright holders retain the right to release
                           this code under diffenent non-exclusive licences.
    email                : mike@quaking.demon.co.uk                                     
 ***************************************************************************/

#include	<stdio.h>
#include	<errno.h>

#include	<qwidget.h>


#include	"kb_classes.h"
#include	"kb_location.h"
#include	"kb_type.h"
#include	"kb_value.h"
#include	"kb_gui.h"
#include	"kb_dbinfo.h"
#include	"kb_dblink.h"
#include	"kb_grid.h"
#include	"kb_form.h"
#include	"kb_query.h"
#include	"kb_table.h"
#include	"kb_qrybase.h"
#include	"kb_qryexpr.h"
#include	"kb_display.h"


#include	"kb_nodereg.h"
#include	"kb_parse.h"

#include	"kb_viewer.h"

#ifndef		_WIN32
#include	"kb_queryviewer.moc"
#else
#include	"kb_queryviewer.h"
#endif

#if		! __KB_RUNTIME
#include	"kb_querydlg.h"
#endif

#include	"tk_messagebox.h"
#include	"tk_config.h"
#include	"tk_icons.h"



/*  KBQueryViewer							*/
/*  KBQueryViewer: Query viewer constructor for extant query		*/
/*  parent	 : KBObjBase *	: Parent object				*/
/*  embed	 : QWidget *	: Embedding widget			*/
/*  (returns)	 : KBQueryViewer:					*/

KBQueryViewer::KBQueryViewer
	(	KBObjBase	*parent,
		QWidget		*embed
	)
	:
	KBViewer (parent, embed, WDestructiveClose|WStyle_NormalBorder)
{
	m_showing   = KB::ShowAsUnknown ;
	m_qryRoot   = 0 ;
	m_qryForm   = 0 ;
	m_dataGUI   = new KBaseGUI (this, this, "rekallui.query.data"  ) ;

#if	! __KB_RUNTIME
	m_qryDialog = 0 ;
	m_designGUI = new KBaseGUI (this, this, "rekallui.query.design") ;
#endif
}

/*  KBQueryViewer							*/
/*  ~KBQueryViewer: Query viewer destructor				*/
/*  (returns)	  : void	:					*/

KBQueryViewer::~KBQueryViewer ()
{
#if	! __KB_RUNTIME
	DELOBJ	(m_qryDialog) ;
#endif
	DELOBJ	(m_qryForm  ) ;
}

/*  KBQueryViewer							*/
/*  saveLayout	: Save dialog layout information			*/
/*  (returns)	: void		:					*/

void	KBQueryViewer::saveLayout ()
{
#if	! __KB_RUNTIME
	if (m_qryDialog)
	{
		TKConfig *config = TKConfig::getConfig() ;

		config->setGroup   ("Query Options" ) ;
		config->writeEntry ("Geometry", m_qryDialog->size     ()) ;
		config->writeEntry ("exprs",	m_qryDialog->exprSizes()) ;
		config->sync	   () ;
	}
#endif
}

/*  KBQueryViewer							*/
/*  queryClose	: Check if it OK to close the viewer			*/
/*  (returns)	: void		:					*/

bool	KBQueryViewer::queryClose ()
{
#if	! __KB_RUNTIME
	if ((m_showing == KB::ShowAsDesign) && m_qryRoot->getChanged())
	{
		if (TKMessageBox::questionYesNo
			(	0,
				TR("Query changed: close anyway?")
			)	!= TKMessageBox::Yes
		   )	return	false	;
	}
#endif
	if ((m_showing == KB::ShowAsData  ) && m_qryForm->getChanged(false))
	{
		if (TKMessageBox::questionYesNo
			(	0,
				TR("Data changed: close anyway?")
			)	!= TKMessageBox::Yes
		   )	return	false	;
	}

	saveLayout () ;
	return	true  ;
}

/*  KBQueryViewer							*/
/*  showDesign	: Show query in design mode				*/
/*  pError	: KBError &	: Error return				*/
/*  (returns)	: KB::ShowRC	: Success				*/

KB::ShowRC
	KBQueryViewer::showDesign
	(	KBError		&
	)
{
#if	! __KB_RUNTIME
	DELOBJ	(m_qryForm  )	;
	DELOBJ	(m_qryDialog)	;

	m_topWidget = 0		;
	m_qryDialog = new KBQueryDlg (m_partWidget, getLocation(), m_qryRoot, m_designGUI) ;
	m_topWidget = m_qryDialog ;

	m_partWidget->setIcon (getSmallIcon ("help")) ;

	TKConfig *config = TKConfig::getConfig() ;
	config->setGroup   ("Query Options") ;

#if	! __KB_EMBEDDED

	QSize	hint	= m_qryDialog->sizeHint   () ;
	QSize	size	= config  ->readSizeEntry ("Geometry") ;
	if (size.isEmpty()) size = hint ;

	m_partWidget->resize	    (size.width(), size.height(), true, false) ;
#endif

	m_qryDialog->setExprSizes   (config->readIntListEntry ("exprs")) ;

	m_showing = KB::ShowAsDesign ;
	return	KB::ShowRCOK	   ;
#else
	return	KB::ShowRCCancel   ;
#endif
}

/*  KBQueryViewer							*/
/*  showData	: Show query in data mode				*/
/*  pError	: KBError &	: Error return				*/
/*  (returns)	: KB::ShowRC	: Success				*/

KB::ShowRC
	KBQueryViewer::showData
	(	KBError		&pError
	)
{
	KB::ShowRC	rc	 ;
	QSize		size	 ;

	DELOBJ(m_qryForm)	;

	if ((m_qryForm = KBOpenQuery (getLocation(), m_qryRoot, pError)) == 0)
	{
		pError.DISPLAY () ;
		return	showDesign (pError) ;
	}

	rc = m_qryForm->showData (m_partWidget, KBAttrDict(), KBValue(), size) ;
	if (rc != KB::ShowRCData)
	{
		m_qryForm->lastError().DISPLAY () ;
		DELOBJ	(m_qryForm) ;
		return	showDesign (pError) ;
	}

	KBObject *gobj	= m_qryForm->getNamedObject ("$$grid$$", false) ;
	KBGrid	 *grid	= gobj == 0 ? 0 : gobj->isGrid() ;
	if (grid != 0)
	{
		QList<KBItem>   items  ;
		grid->getItems (items) ;

		KBQryBase	*qryb  = m_qryForm->getQuery() ;
		QFontMetrics	fm     (*grid->getFont (true)) ;
		int		cw     = fm.width('X') ;
		uint		tw     = 50 + 20 ;

		LITER
		(	KBItem,
			items,
			item,

			uint	qryLvl	= item->getQueryLvl() ;
			uint	qryIdx	= item->getQueryIdx() ;
			uint	w	= qryb->getWidth (qryLvl, qryIdx) * cw ;

			if (w < 100) w = 100 ;
			if (w > 500) w = 500 ;

			grid->setColumnWidth (item, w) ;
			tw += w ;
		)


		QScrollView *scroll = m_qryForm->getContainer()->getScroller() ;
		scroll->resizeContents (tw, scroll->contentsHeight()) ;

		fprintf
		(	stderr,
			"KBQueryViewer::showData: set width=%d\n",
			tw
		)	;
	}
	
	saveLayout () ;
#if	! __KB_RUNTIME
	DELOBJ	   (m_qryDialog) ;
#endif
	m_topWidget = m_qryForm->getDisplay()->getTopWidget() ;

	m_qryForm->setGUI (m_dataGUI) ;

#if	! __KB_EMBEDDED
	if (size.width () > 780) size.setWidth  (780) ;
	if (size.height() > 580) size.setHeight (580) ;

	m_partWidget->resize (size.width(), size.height(), true, false) ;
#endif
	m_partWidget->setIcon(getSmallIcon ("query")) ;

	m_showing = KB::ShowAsData ;
	return	KB::ShowRCOK ;
}

/*  KBQueryViewer							*/
/*  startup	: Startup query viewer object				*/
/*  _qryRoot	: KBQuery *	: Query object				*/
/*  showAs	: KB::ShowAs	: Display mode				*/
/*  pError	: KBError &	: Error return				*/
/*  (returns)	: bool		: Success				*/

KB::ShowRC
	KBQueryViewer::startup
	(	KBQuery		*_qryRoot,
		KB::ShowAs	_showAs,
		KBError		&pError
	)
{
	KB::ShowRC rc ;

	m_qryRoot = _qryRoot ;
	m_showing = _showAs  ;

#if	! __KB_RUNTIME
	if (m_showing == KB::ShowAsDesign)
		rc = showDesign (pError) ;
	else
#endif
		rc = showData   (pError) ;

	if (rc != KB::ShowRCCancel)
	{
#if	! __KB_RUNTIME
		if (m_showing == KB::ShowAsDesign)
			setGUI (m_designGUI) ;
		else
#endif
			setGUI (m_dataGUI  ) ;

		m_topWidget ->show () ;
		m_partWidget->show () ;

#if	! __KB_RUNTIME
		if (m_showing == KB::ShowAsDesign)
		{
			m_qryRoot->setChanged    (false) ;
			m_designGUI ->setEnabled (KB::GRDelta, false) ;
		}
#endif
		setCaption (getLocation().title()) ;
	}

	return	rc ;
}


/*  KBQueryViewer							*/
/*  showAs	: Show in specified mode				*/
/*  _showAs	: KB::ShowAs	: Show as ....				*/
/*  (returns)	: void		:					*/

void	KBQueryViewer::showAs
	(	KB::ShowAs	_showAs
	)
{
#if	! __KB_RUNTIME
	KBError		error	;
	KB::ShowRC	rc	;

	if (m_showing == _showAs) return ;

	if ((_showAs == KB::ShowAsData) && m_qryRoot->getChanged())
	{
		TKMessageBox::sorry
		(	0,
			"Query must be saved before entering data view"
		)	;
		return	;
	}

	m_showing = _showAs ;
	if (m_showing == KB::ShowAsDesign)
		rc = showDesign (error) ;
	else	rc = showData   (error) ;

	if (rc != KB::ShowRCOK) error.DISPLAY() ;

	if (m_showing == KB::ShowAsDesign)
		setGUI (m_designGUI) ;
	else	setGUI (m_dataGUI  ) ;

	m_topWidget ->show   () ;
	m_partWidget->show   () ;
	m_topWidget ->resize (m_partWidget->size()) ;

	if (m_showing == KB::ShowAsDesign)
	{
		m_qryRoot  ->setChanged (false) ;
		m_designGUI->setEnabled (KB::GRDelta, false) ;
	}
#endif
}

/*  KBQueryViewer							*/
/*  saveDocumentAs: Save query as a different document			*/
/*  (returns)	  : void	:					*/

void	KBQueryViewer::saveDocumentAs ()
{
#if	! __KB_RUNTIME
	/* This is only meaningful in design mode, and if the current	*/
	/* state is OK.							*/
	if ((m_showing == KB::ShowAsDesign) && m_qryDialog->saveDocument ())
	{
		if (!connectedOK()) return ;

		if (m_objBase->saveDocumentAs ())
		{	m_qryRoot  ->setChanged (false) ;
			setCaption (getLocation().title ()) ;
			m_designGUI->setEnabled (KB::GRDelta, false) ;
		}
	}
#endif
}

/*  KBQueryViewer							*/
/*  connectedOK	: Check whether query tables are all connected		*/
/*  (returns)	: bool		: OK or used confirms OK		*/

bool	KBQueryViewer::connectedOK ()
{
#if	! __KB_RUNTIME
	if (m_showing == KB::ShowAsDesign)
	{
		QString			svName	;	
		QList<KBTable  >	tabList	;
		QList<KBQryExpr>	exprList;
		uint			nLoose	= 0 ;

		m_qryRoot->getQueryInfo (svName, tabList, exprList) ;

		LITER
		(	KBTable,
			tabList,
			table,

			if (table->getParent().isEmpty()) nLoose += 1 ;
		)

		if (nLoose > 1)
			if (TKMessageBox::questionYesNo
				(	0,
					TR
					(	"Not all tables in the query are linked\n"
						"Is this OK?"
					)
				)	!= TKMessageBox::Yes
			   )	return	false ;

		return	true	;
	}
#endif
	return	true	;
}


/*  KBQueryViewer							*/
/*  saveDocument: Save query						*/
/*  (returns)	: void		:					*/

void	KBQueryViewer::saveDocument ()
{
#if	! __KB_RUNTIME
	/* If we are in design mode then this is interpreted as saving	*/
	/* the query design.						*/
	if ((m_showing == KB::ShowAsDesign) && m_qryDialog->saveDocument ())
	{
		if (!connectedOK()) return ;

		if (m_objBase->saveDocument ())
		{	m_qryRoot  ->setChanged (false) ;
			setCaption (getLocation().title ()) ;
			m_designGUI->setEnabled (KB::GRDelta, false) ;
		}
	}
#endif
}

cchar	*KBQueryViewer::getChanged
	(	bool
	)
{
#if	! __KB_RUNTIME
	if (m_showing == KB::ShowAsDesign)
		return	m_qryRoot->getChanged ()      ? "query" : 0 ;
#endif

	if (m_showing == KB::ShowAsData)
		return	m_qryForm->getChanged (false) ? "data"  : 0 ;

	return	0 ;
}

/*  KBQueryViewer							*/
/*  dbaseAction	: Handle database action request			*/
/*  action	: int		: Database action			*/
/*  (returns)	: void		:					*/

void	KBQueryViewer::dbaseAction
	(	int	action
	)
{
	if (m_showing == KB::ShowAsData)
		if (!m_qryForm->formAction ((KB::Action)action))
			m_qryForm->lastError().DISPLAY() ;
}

/*  KBQueryViewer							*/
/*  reload	: Reload table data					*/
/*  (returns)	: void		:					*/

void	KBQueryViewer::reload ()
{
	if (m_showing == KB::ShowAsData)
		if (!m_qryForm->requery ())
			m_qryForm->lastError().DISPLAY() ;
}

