/***************************************************************************
    file	         : kb_reportbase.cpp
    copyright            : (C) 1999,2000,2001,2002,2003 by Mike Richardson
			   (C) 2000,2001,2002,2003 by theKompany.com
			   (C) 2001,2002,2003 by John Dean
    license              : This file is released under the terms of
                           the GNU General Public License, version 2. The
                           copyright holders retain the right to release
                           this code under diffenent non-exclusive licences.
    email                : mike@quaking.demon.co.uk                                     
 ***************************************************************************/

#include	<errno.h>
#include	<time.h>

#include	<qwidget.h>

#include	"kb_classes.h"
#include	"kb_type.h"
#include	"kb_value.h"
#include	"kb_attrdict.h"
#include	"kb_database.h"
#include	"kb_gui.h"
#include	"kb_dbinfo.h"
#include	"kb_dblink.h"
#include	"kb_display.h"
#include	"kb_report.h"
#include	"kb_options.h"
#include	"kb_string.h"
#include	"kb_nodereg.h"
#include	"kb_parse.h"
#include	"kb_docroot.h"
#include	"kb_viewer.h"
#include	"kb_writer.h"
#include	"kb_build.h"

#include	"kb_reportviewer.h"
#include	"kb_objbase.h"

#include	"tk_messagebox.h"

#ifndef 	_WIN32
#include	"kb_reportbase.moc"
#else
#include 	"kb_reportbase.h"
#endif

#include	"kb_reportlist.h"


/*  KBReportBase:							*/
/*  KBReportBase: Constructor for base object for reports		*/
/*  parent	: QObject *	: Parent object				*/
/*  (returns)	: KBForm	:					*/

KBReportBase::KBReportBase
	(	QObject	*parent
	)
	:
	KBObjBase (parent)
{
	m_docRoot = 0 ;
	m_viewer  = 0 ;
}

/*  KBReportBase :							*/
/*  ~KBReportBase: Destructor for base object for forms			*/
/*  (returns)	 :		:					*/

KBReportBase::~KBReportBase ()
{
	DELOBJ (m_docRoot) ;
}

/*  KBReportBase:							*/
/*  build	: Build an instance of an object			*/
/*  _location	: KBLocation &	  : Object location			*/
/*  _create	: bool		  : Creating a new object		*/
/*  pError	: KBError &	  : Error return			*/
/*  (returns)	: bool		  :					*/

bool	KBReportBase::build
	(	KBLocation	&location,
		bool		create,
		KBError		&pError
	)
{
	setLocation (location) ;

#if	! __KB_RUNTIME
	if (create)
	{
		KBAttrDict	aList	;

		aList.addValue ("language", "py"	   ) ;
		aList.addValue ("autosync", "Yes"	   ) ;
		aList.addValue ("rowcount", "1"	  	   ) ;
		aList.addValue ("name",	    "UnnamedReport") ;
		aList.addValue ("w",	    KBOptions::getFormWidth   ()) ;
		aList.addValue ("h",	    KBOptions::getFormHeight  ()) ;
		aList.addValue ("dx",	    KBOptions::getDefaultDX   ()) ;
		aList.addValue ("dy",	    KBOptions::getDefaultDY   ()) ;
		aList.addValue ("lmargin",  KBOptions::getLeftMargin  ()) ;
		aList.addValue ("rmargin",  KBOptions::getRightMargin ()) ;
		aList.addValue ("tmargin",  KBOptions::getTopMargin   ()) ;
		aList.addValue ("bmargin",  KBOptions::getBottomMargin()) ;
		aList.addValue ("modal",    KBOptions::getReportsModal() ? "Yes" : "No") ;

		bool	ok ;
		m_docRoot = new KBReport (getLocation(), aList, ok) ;
		if (!ok)
		{	pError	= KBError
				  (	KBError::Warning,
					TR("User cancel"),
					QString::null,
					__ERRLOCN
				  )	;
			return	false	;
		}
	}
	else
#endif
	{
		QByteArray doc ;
		if (!getLocation().contents (doc, pError))
			return	false	;

		if ((m_docRoot = KBOpenReportText (getLocation(), doc, pError)) == 0)
			return	false	;
	}

	return	true	;
}

/*  KBReportBase:							*/
/*  show	: Show form						*/
/*  embed	: QWidget *	  : Widget into which to embed display	*/
/*  showAs	: KB::ShowAs	  : Display mode			*/
/*  pDict	: QDict<QString> &: Parameter dictionary		*/
/*  pError	: KBError &	  : Error return			*/
/*  key		: const KBValue & : Parent key				*/
/*  rDict	: QDict<QString>* : Results dictionary			*/
/*  (returns)	: KB::ShowRC	  : Startup result			*/

KB::ShowRC
	KBReportBase::show
	(	KB::ShowAs		showAs,
		const QDict<QString>	&pDict,
		QWidget			*embed,
		KBError			&pError,
		const KBValue		&key,
		QDict<QString>		*
	)
{
	/* First check for a __showAs override in the parameter	dict,	*/
	/* in which case we will use that, whatever we were passed as	*/
	/* an argument.							*/
	QString	*override = pDict.find ("__showAs") ;

	if (override != 0)
		showAs = showAsCode (*override, showAs) ;


#if	! __KB_EMBEDDED
	/* Check for the special case, KB::ShowAsReport. This is in	*/
	/* effect a stand-alone operation which will print out the full	*/
	/* report.							*/
	if (showAs == KB::ShowAsReport)
		return	doPrintReport (pDict, key, 0, -1) ; 
#endif

	/* If there is no viewer then this is the first call so create	*/
	/* one and start it.						*/
	if (m_viewer == 0)
	{
		bool	modal	= ((KBAttrBool *)m_docRoot->getAttr("modal"))->getBoolValue() ;

		m_viewer = new KBReportViewer
			       (	this,
					embed,
					pDict,
					modal
			      ) ;

		setPart	(m_viewer, modal) ;

		KB::ShowRC rc = m_viewer->startup
			 	(	m_docRoot,
			 		showAs,
			 		key,
			 		pError
				)	;

		if (rc == KB::ShowRCModal)
		{
			return	rc	;
		}

		if (rc != KB::ShowRCOK)
		{
			delete	m_viewer;
			return	rc	;
		}

		return	KB::ShowRCOK	;
	}

	/* Extant viewer so give it focus and switch to the requested	*/
	/* show mode.							*/
	m_viewer->widget()->setFocus() ;
	m_viewer->showAs(showAs) ;

	return	KB::ShowRCOK ;
}

/*  KBReportBase:							*/
/*  def		: Get the report definition				*/
/*  (returns)	: QString	: Definition				*/

QString	KBReportBase::def ()
{
	QString	text	;
	m_docRoot->printNode (text, 0) ;
	return	text	;
}

/*  KBReportBase 							*/
/*  widgetClosing: Trap close						*/
/*  (returns)	 : void		:					*/

void	KBReportBase::widgetClosing ()
{
	DELOBJ	(m_docRoot) ;
}


#if	! __KB_EMBEDDED

/*  KBReportBase 							*/
/*  doPrintReport: Actually print the report				*/
/*  pDict	 : QDict<QString> & : Paramater distionary		*/
/*  key		 : const KBValue  & : Parent key			*/
/*  extant	 : KBWriter *	    : Extant writer			*/
/*  pageNo	 : int		    : Single page number		*/
/*  (returns)	 : KB::ShowRC	    : Always apparent success		*/

KB::ShowRC KBReportBase::doPrintReport
	(	const QDict<QString>	&pDict,
		const KBValue		&key,
		KBWriter		*extant,
		int			pageNo
	)
{
	QWidget		wrapper ;
	KBWriter	*writer ;
	KB::ShowRC	showRC  ;

	if (extant == 0)
	{
		QSize	   size	  ;

		writer	= new KBWriter (0, getLocation()) ;
		showRC	= m_docRoot->showData (&wrapper, writer, pDict, key, size, true) ;

		if (showRC == KB::ShowRCCancel)
		{	delete	writer	;
			return	KB::ShowRCCancel ;
		}

		if (showRC != KB::ShowRCData)
		{
			delete	writer	;
			TKMessageBox::sorry
			(	0,
				TR("Error printing report"),
				TR("Report print error")
			)	;
			return	showRC	;
		}
	}
	else
	{	if (!extant->setup(true))
			return	KB::ShowRCCancel ;

		writer	= extant ;
	}

	writer->printDoc (QString::null, pageNo) ;
	if (writer != extant) delete writer ;
	return	KB::ShowRCReport ;
}

#endif

/*  ------------------------------------------------------------------  */

KBFACTORYIMPL
(	KBReportFactory,
	reportview,
	"Rekall report viewer",
	"Plugin",
	"0",
	"7",
	"0"
)


QObject	*KBReportFactory::create
	(	QObject		  *parent,
		cchar		  *name,
		cchar		  *className,
		const QStringList &
	)
{
	if ((className != 0) && (strcmp (className, "browser") == 0))
		return	new KBReportList ((QWidget *)parent, (KBDBInfo *)name) ;


	return	new	KBReportBase (parent) ;
}

cchar	*KBReportFactory::ident ()
{
	return	__KB_BUILD_IDENT	;
}
