/***************************************************************************
    file	         : kb_reportbuilder.cpp
    copyright            : (C) 1999,2000,2001,2002,2003 by Mike Richardson
			   (C) 2000,2001,2002,2003 by theKompany.com
			   (C) 2001,2002,2003 by John Dean
    license              : This file is released under the terms of
                           the GNU General Public License, version 2. The
                           copyright holders retain the right to release
                           this code under diffenent non-exclusive licences.
    email                : mike@quaking.demon.co.uk                                     
 ***************************************************************************/

#include	<stdio.h>
#include	<stdlib.h>
#include	<stdarg.h>

#include	<qstring.h>
#include	<qlist.h>

#include	"kb_classes.h"
#include	"kb_location.h"
#include	"kb_type.h"
#include	"kb_value.h"
#include	"kb_database.h"

#include	"kb_dbinfo.h"
#include	"kb_dblink.h"
#include	"kb_nodereg.h"
#include	"kb_parse.h"
#include	"kb_attrdict.h"
#include	"kb_node.h"
#include	"kb_table.h"

#include	"kb_wizreport.h"
#include	"kb_wizfields.h"
#include	"kb_builder.h"

#include	"kb_component.h"
#include	"kb_config.h"
#include	"kb_writer.h"



static	QString	fieldsSeparateLines
	(	KBLocation			&location,
		KBTableInfo			*tabInfo,
		QList<KBFieldSpec>		&fields,
		uint				&width,
		uint				&height,
		KBBuildFieldInfo		&info
	)
{
	uint	x	= width	 ;
	uint	y	= height ;

	QString	text	;

	for (uint idx = 0 ; idx < fields.count() ; idx += 1)
	{
		KBFieldSpec	*fieldSpec = fields.at(idx)	;
		const QString	&fieldName = fieldSpec->m_name	;
		KBAttrDict	labelAttr  ;
		KBAttrDict	fieldAttr  ;
		int		w	   = 0  ;
		int		h	   = 20 ;

		labelAttr.addValue ("x",	x		) ;
		labelAttr.addValue ("y",	y		) ;
		labelAttr.addValue ("w",	100		) ;
		labelAttr.addValue ("h",	20		) ;
		labelAttr.addValue ("text",	fieldName	) ;
		text	+= labelAttr.print ("KBLabel", true, 4	) ;

		text	+= builderMakeField
			   (	location,
				tabInfo,
				fieldSpec,
				x + 100 + 20,
				y,
				w,
				h,
				-1,
				4,
				info
			   )	;

		y	+= 30 ;

		if (x + 100 + 20 + w + 20 > width)
			width	= x + 100 + 20 + w + 20 ;
	}

	height	= y	;
	return	text	;
}

static	QString	fieldsAllOnOneLine
	(	KBLocation			&location,
		KBTableInfo			*tabInfo,
		QList<KBFieldSpec>		&fields,
		uint				&width,
		uint				&height,
		KBBuildFieldInfo		&info
	)
{
	uint	x	= width	 ;
	uint	y	= height ;

	QString	text	;

	for (uint idx = 0 ; idx < fields.count() ; idx += 1)
	{
		KBFieldSpec	*fieldSpec = fields.at(idx) ;
		KBAttrDict	fieldAttr  ;
		int		w	   = builderFieldWidth (fieldSpec) ;
		int		h	   = 20 ;

		text	+= builderMakeField
			   (	location,
				tabInfo,
				fieldSpec,
				x,
				y,
				w,
				h,
				-1,
				4,
				info
			   )	;

		x += w + 20 ;
	}

	width	= x - 20 ;
	height	= y + 30 ;
	return	text	 ;
}

static	QString	labelsAllOnOneLine
	(	QList<KBFieldSpec>		&fields,
		uint				&width,
		uint				&height
	)
{
	uint	x	= width	 ;
	uint	y	= height ;

	QString	text	;

	for (uint idx = 0 ; idx < fields.count() ; idx += 1)
	{
		KBFieldSpec	*fieldSpec = fields.at(idx)	;
		const QString	&fieldName = fieldSpec->m_name	;
		KBAttrDict	labelAttr  ;
		int		w	   = builderFieldWidth (fieldSpec) ;

		labelAttr.addValue ("x",	x		) ;
		labelAttr.addValue ("y",	y		) ;
		labelAttr.addValue ("w",	w		) ;
		labelAttr.addValue ("h",	20		) ;

		if ( (fieldSpec->m_typeIntl == KB::ITFixed) ||
		     (fieldSpec->m_typeIntl == KB::ITFloat) )
		{
			labelAttr.addValue ("align", Qt::AlignRight) ;
		}

		x += w + 20 ;

		labelAttr.addValue ("text",	fieldName	) ;
		text	+= labelAttr.print ("KBLabel", true, 4	) ;
	}

	width	= x - 20 ;
	height	= y + 20 ;
	return	text	 ;
}

QString	kbReportBuilder
	(	KBLocation			&location,
		bool				preview,
		KBWizardReport			&wizard
	)
{
	QString		reportText	;
	QString		headerText	;
	QString		fieldText	;
	QString		labelText	;
	QString		footerText	;
	QString		captionText	;
	QString		queryTag	= "KBQryNull" ;
	uint		fldWidth	= 0  ;
	uint		fldHeight	= 50 ;
	uint		hdrHeight	= 50 ;
	KBTableInfo	*tabInfo	= 0  ;

	int		pixWidth	;
	int		pixHeight	;

	bool		columns		= wizard.layout	   () == 0 ;
	QString		sourceName	= wizard.sourceName() ;

	QList<KBFieldSpec>	fieldList	;
	wizard.fieldList (fieldList)		;

	KBBuildFieldInfo	info		;
	info.setFromWizard (wizard)		;

	if (wizard.sourceType() == KBWizardCtrlDataSource::Table)
		tabInfo = location.dbInfo->findTableInfo
				(	location.docLocn,
					sourceName
				)	;

	getPixelPageSize ("A4", pixWidth, pixHeight) ;
	pixWidth -= (int)((KBOptions::getLeftMargin() + KBOptions::getRightMargin()) * pixelsPerMM()) ;

	if (columns)
	{
		uint	lblWidth	= 0  ;
		uint	lblHeight	= 50 ;

		fldHeight = 70 ;
		hdrHeight = 70 ;

		fieldText = fieldsAllOnOneLine	(location, tabInfo, fieldList, fldWidth, fldHeight, info) ;
		labelText = labelsAllOnOneLine	(		    fieldList, lblWidth, lblHeight) ;
	}
	else	fieldText = fieldsSeparateLines	(location, tabInfo, fieldList, fldWidth, fldHeight, info) ;


	KBAttrDict	reportAttr	;
	KBAttrDict	headerAttr	;
	KBAttrDict	queryAttr	;
	KBAttrDict	footerAttr	;
	KBAttrDict	captionAttr	;
	KBAttrDict	dateAttr	;
	KBAttrDict	pageAttr	;

	reportAttr .addValue	("lmargin",	KBOptions::getLeftMargin  ()) ;
	reportAttr .addValue	("rmargin",	KBOptions::getRightMargin ()) ;
	reportAttr .addValue	("tmargin",	KBOptions::getTopMargin   ()) ;
	reportAttr .addValue	("bmargin",	KBOptions::getBottomMargin()) ;

	reportAttr .addValue	("w",		pixWidth ) ;
	reportAttr .addValue	("h",		fldHeight + 50    ) ;
	reportAttr .addValue	("caption",	wizard.caption  ()) ;
	reportAttr .addValue	("language",	"py"	 ) ;
	reportAttr .addValue	("pthrow",	wizard.pageThrow() == 0 ? 0 : 2) ;

	headerAttr .addValue	("h",		hdrHeight) ;
	headerAttr .addValue	("w",		pixWidth ) ;

	footerAttr .addValue	("h",		50	 ) ;
	footerAttr .addValue	("w",		pixWidth ) ;

	captionAttr.addValue	("x",		20	 ) ;
	captionAttr.addValue	("y",		10	 ) ;
	captionAttr.addValue	("w",		pixWidth - 20) ;
	captionAttr.addValue	("h",		30	 ) ;
	captionAttr.addValue	("text",	wizard.caption	  ()) ;
	captionAttr.addValue	("font",	wizard.fontCaption()) ;

	dateAttr   .addValue	("x",		20	) ;
	dateAttr   .addValue	("y",		20	) ;
	dateAttr   .addValue	("w",		100	) ;
	dateAttr   .addValue	("h",		20	) ;
	dateAttr   .addValue	("font",	wizard.fontPage   ()) ;

	dateAttr   .addValue
	(	"expr",
		"=time.strftime('" + info.m_rawFormatDate + "', time.localtime(time.time()))"
	)	;


	pageAttr   .addValue	("x",		pixWidth - 20 - 100) ;
	pageAttr   .addValue	("y",		20	) ;
	pageAttr   .addValue	("w",		100	) ;
	pageAttr   .addValue	("h",		20	) ;
	pageAttr   .addValue	("font",	wizard.fontPage   ()) ;
	pageAttr   .addValue	("expr",	"='Page %{pageno} of %{pagecount}'") ;

	if (!preview)
		switch (wizard.sourceType())
		{
			case KBWizardCtrlDataSource::Query :
				queryTag = "KBQryQuery"	;
				queryAttr.addValue	("query",	sourceName) ;
				break	;

			case KBWizardCtrlDataSource::Table :
				queryTag = "KBQryTable"	;
				queryAttr.addValue	("server",	"Self"	  ) ;
				queryAttr.addValue	("table",	sourceName) ;
				queryAttr.addValue	("primary",	""    	  ) ;
				queryAttr.addValue	("ptype",	(int)KBTable::Auto) ;
				break	;

			default	:
				break	;
		}

	queryAttr.addValue	("order",	wizard.order().join(", ")) ;

	reportText += reportAttr .print ("KBReport", 	  false) ;
	reportText += " <KBImport module=\"time\"/>\n" ;
	reportText += queryAttr  .print (queryTag, 	  true,  2) ;
	reportText += headerAttr .print ("KBBlockHeader", false, 2) ;
	reportText += captionAttr.print ("KBLabel", 	  true,  4) ;
	reportText += labelText ;
	reportText += "  </KBBlockHeader>\n" ;
	reportText += fieldText	;
	reportText += footerAttr .print ("KBBlockFooter", false, 2) ;
	reportText += dateAttr   .print ("KBField",	  true,  4) ;
	reportText += pageAttr   .print ("KBField",	  true,  4) ;
	reportText += "  </KBBlockFooter>\n" ;
	reportText += "</KBReport>\n" ;

	return	reportText	;
}
