/***************************************************************************
    file	         : kb_reportviewer.h
    copyright            : (C) 1999,2000,2001,2002,2003 by Mike Richardson
			   (C) 2000,2001,2002,2003 by theKompany.com
			   (C) 2001,2002,2003 by John Dean
    license              : This file is released under the terms of
                           the GNU General Public License, version 2. The
                           copyright holders retain the right to release
                           this code under diffenent non-exclusive licences.
    email                : mike@quaking.demon.co.uk                                     
 ***************************************************************************/

#ifndef  _KB_REPORTVIEWER_H
#define  _KB_REPORTVIEWER_H

#include	<qscrollview.h>
#include	<qguardedptr.h>

#include 	"kb_classes.h"
#include	"kb_viewer.h"
#include	"kb_attrdict.h"

#include	"kb_reportbase.h"

class	KBObjTreeViewer	;



/*  KBReportViewer							*/
/*  ------------							*/
/*  This class is the MDI child wrapper for report viewing, in either	*/
/*  data, preview or design mode.					*/

class	KBReportViewer : public KBViewer
{
	Q_OBJECT

	KBReportBase		*m_base		;
	KBAttrDict		m_pDict		;

	QGuardedPtr<KBReport>	m_docRoot 	;
	KBaseGUI		*m_designGUI	;
	KBaseGUI		*m_dataGUI	;

	KBObjTreeViewer		*m_objTree	;
	QScrollView		*m_scroller	;
	KBWriter		*m_writer	;
	KB::ShowAs		m_showing	;

	KBValue			m_parentKey	;
	uint			m_pageno	;
	bool			m_doSetup	;

	QComboBox		*m_gotoPage	;

	void			updateToolBar		(bool)	;

protected slots	:

	void			objTreeViewerDead	()	;

public	:

	KBReportViewer (KBReportBase *, QWidget *, const QDict<QString> &, bool) ;
virtual~KBReportViewer () ;

	virtual	KBReportViewer	*isReportViewer () { return this  ; }
	virtual	cchar		*getChanged     (bool) ;
	virtual	bool		queryClose	()	;

	KB::ShowRC		startup		(KBReport *, KB::ShowAs, const KBValue &, KBError &) ;

public	slots	:

	virtual	void	showAs		(KB::ShowAs)	;

	void		saveDocument	()     		;
	void		saveDocumentAs	()     		;
	void		dbaseAction	(int)		;
	void		reload	        ()		;
	void		doCtrlAlign	(int)		;
	void		doCut		()		;
	void		doCopy		()		;
	void		doPaste		()		;
	void		snapToGrid	()		;
	void		showObjTree	()		;
	void		doMultiProp	()		;
	void		doProperties	()		;
	void		printPage	()		;
	void		gotoPage	(const QString &) ;
}	;

extern	KBReport *KBOpenReport  (KBDBInfo *, const QString &, QDict<QString> *, KBError &) ;

#endif // _KB_REPORTVIEWER_H
