/***************************************************************************
    file	         : kb_wizreport.cpp
    copyright            : (C) 1999,2000,2001,2002,2003 by Mike Richardson
			   (C) 2000,2001,2002,2003 by theKompany.com
			   (C) 2001,2002,2003 by John Dean
    license              : This file is released under the terms of
                           the GNU General Public License, version 2. The
                           copyright holders retain the right to release
                           this code under diffenent non-exclusive licences.
    email                : mike@quaking.demon.co.uk                                     
 ***************************************************************************/

#include	<qapplication.h>
#include	<time.h>

#include	"kb_dbinfo.h"
#include	"kb_serverinfo.h"
#include	"kb_location.h"
#include	"kb_wizreport.h"
#include	"kb_wizsource.h"
#include	"kb_wizfields.h"
#include	"kb_display.h"
#include	"kb_report.h"

#include	"kb_locator.h"


KBWizardReportFrame::KBWizardReportFrame
	(	QWidget		*parent
	)
	:
	QWidget	(parent)
{
}

void	KBWizardReportFrame::setWidget
	(	QWidget		*widget,
		const QSize	&size
	)
{
	QVBoxLayout *lay = new QVBoxLayout(this) ;
	lay->addWidget (widget) ;
	m_size	= size	;
}

QSize	KBWizardReportFrame::sizeHint () const
{
	return	m_size	;
}

/*  ------------------------------------------------------------------  */

/*  KBWizardReportPreview							*/
/*  KBWizardReportPreview							*/
/*		: Constructor for wizard report previewer			*/
/*  text	: const QString &	: Report definition		*/
/*  ok		: bool &		: Return success		*/
/*  (returns)	: KBWizardReportPreview	:				*/

KBWizardReportPreview::KBWizardReportPreview
	(	const QString	&text,
		bool		&ok
	)
	:
	_KBDialog	("Report Preview", true),
	m_frame		(this),
	m_bOK		(this, "ok")
{
	extern	KBReport	*KBOpenReportText (KBLocation &, QByteArray &, KBError &) ;

	/* Convert the report from text into an object tree. If there is	*/
	/* an error then report it, and clear the "ok" flag so that	*/
	/* the user knows not to execute the dialog.			*/
	KBLocation	locn	;
	KBError		error	;
	QByteArray	data	;
	QSize		size	;

	cchar		*raw	= (cchar *)text ;
	data.duplicate	(raw, strlen(raw)) ;

	if ((m_report = KBOpenReportText (locn, data, error)) == 0)
	{
		error.DISPLAY()	;
		ok	= false	;
		return	;
	}

	m_report->showDesign (&m_frame, size) ;
	size	+= QSize (24,24) ;

	m_top	  = m_report->getDisplay()->getTopWidget    () ;
	m_top->resize(size) ;
	m_top->show  ()	;

	m_display = m_report->getDisplay()->getDisplayWidget() ;
	
	m_frame.setWidget (m_top, size) ;

	
	QVBoxLayout	*layMain= new QVBoxLayout (this) ;
	layMain->addWidget (&m_frame)	;
	QHBoxLayout	*layButt= new QHBoxLayout (layMain) ;
	layButt->addStretch()		;
	layButt->addWidget (&m_bOK)	;


	m_bOK.setDefault (true) ;

	qApp->installEventFilter(this) ;

	ok	= true	;
}

/*  KBWizardReportPreview							*/
/*  ~KBWizardReportPreview						*/
/*		: Destructor for wizard report previewer			*/
/*  (returns)	:		:					*/

KBWizardReportPreview::~KBWizardReportPreview ()
{
	if (m_report != 0) delete m_report ;
}

/*  KBWizardReportPreview							*/
/*  focusNextPrevChild							*/
/*		: Handle focus movement					*/
/*  (returns)	: bool		: Next focused widget found		*/

bool	KBWizardReportPreview::focusNextPrevChild
	(	bool
	)
{
	/* Override this as the dialog only has a single button as we	*/
	/* want to keep focus out of the preview			*/
	return	true	;
}

/*  KBWizardReportPreview							*/
/*  eventFilter	: Event filtering					*/
/*  o		: QObject *	: Object receiving event8		*/
/*  e		: QEvent *	: Event in question			*/
/*  (returns)	: bool		: Event consumed			*/

bool	KBWizardReportPreview::eventFilter
	(	QObject		*o,
		QEvent		*e
	)
{
	/* This exists to stop the user actually doing anything with	*/
	/* the "report" ...						*/
	if (o->isWidgetType()) 
		for (QWidget *w = (QWidget *)o ; w != 0 ; w = w->parentWidget())
			if (w == m_display)
				switch (e->type())
				{
					case QEvent::MouseButtonPress    :
					case QEvent::MouseButtonRelease  :
					case QEvent::MouseButtonDblClick :
					case QEvent::ContextMenu	 :
					case QEvent::KeyPress		 :
					case QEvent::KeyRelease		 :
					case QEvent::Wheel		 :
					case QEvent::FocusIn		 :
					case QEvent::FocusOut		 :
						return	true	;

					default	:
						return	false	;
				}

	return	false	;
}


/*  ------------------------------------------------------------------  */

/*  KBWizardReport							*/
/*  KBWizardReport: Constructor for report wizard				*/
/*  location	: KBLocation &	  : Dummy location			*/
/*  server	: const QString & : Server name				*/
/*  (returns)	: KBWizardReport	  :					*/

KBWizardReport::KBWizardReport
	(	KBLocation	&location,
		const QString	&server
	)
	:
	KBWizard   (location.dbInfo, server),
	m_location (location)
{
}

/*  KBWizardReport							*/
/*  exec	: Execute wizard					*/
/*  (returns)	: int		: DIalog exit code			*/

int	KBWizardReport::exec ()
{
	/* Locate the wizard definition and initialise the wizard,	*/
	/* checking for errors, not that there should be any thus far.	*/
	QString	wizXML	= locateFile ("appdata", "wizards/wizReport.wiz") ;
	if (wizXML.isNull())
	{
		KBError::EError
		(	QString(TR("Cannot locate wizard specification")),
			"wizReport.wiz",
			__ERRLOCN
		)	;
		return	0 ;
	}

	if (!init (wizXML))
	{	lastError().DISPLAY() ;
		return	0 ;
	}

	/* The loop below keeps running the wizard so long as the user	*/
	/* finishes with the "preview" option. This allows the user to	*/
	/* preview and return to update the wizard settings.		*/
	bool	first	= true	;
	int	rc	;

	while ((rc = KBWizard::exec (first)) != 0)
	{
		if (ctrlAttribute ("final", "mode", "index" ).toInt() != 2)
			return	rc ;

		first	= false	;

		/* Preview the report. Note that we generate it with	*/
		/* a null query since we don't seem to be able to stop	*/
		/* focus events getting through ....			*/
		KB::ShowAs		showAs	;
		QString			name	;
		bool			ok	;

		KBWizardReportPreview	preview	(create (name, showAs, true), ok) ;
		if (ok) preview.exec	()	;
	}

	return	0 ;
}

QString	KBWizardReport::create
	(	QString		&reportName,
		KB::ShowAs	&showAs,
		bool		preview
	)
{
//	KBWizardCtrlDataSource::Type
//			sourceType	= (KBWizardCtrlDataSource::Type)
//					  ctrlAttribute	("source", "object", "type"  ).toInt	   () ;
//	QString		sourceName	= ctrlValue	("source", "object"	     ) ;
//	QStringList	fields		= ctrlAttribute ("fields", "fields", "fields").toStringList() ;
//	QStringList	order		= ctrlAttribute ("order",  "order",  "order" ).toStringList() ;
//	int		layout		= ctrlAttribute ("layout", "layout", "index" ).toInt	   () ;
//	QString		caption		= ctrlValue	("names",  "caption") ;
//	QString		name		= ctrlValue	("names",  "name"   ) ;
//	int		mode		= ctrlAttribute ("final",  "mode",   "index" ).toInt	   () ;
//
//	QList<KBFieldSpec>
//			fieldList	;
//	((KBWizardCtrlFields *)findCtrl("fields", "fields"))->fields (fieldList) ;

	fprintf
	(	stderr,
		"KBWizardReport::create:\n"
		"	sourceName	: %s\n"
		"	sourceType	: %d\n"
		"	fields		: %s\n"
		"	order		: %s\n"
		"	layout		: %d\n"
		"	caption		: %s\n"
		"	name		: %s\n"
		"	mode		: %d\n",
		(cchar *)sourceName(),
		(int	)sourceType(),
		(cchar *)fields().join(", "),
		(cchar *)order ().join(", "),
		layout(),
		(cchar *)caption(),
		(cchar *)name   (),
		mode()
	)	;

	extern	QString	 kbReportBuilder (KBLocation &, bool, KBWizardReport &) ;
	QString	report = kbReportBuilder (m_location, preview, *this) ;

	fprintf
	(	stderr,
		"KBWizardReport::create[[\n%s\n]]\n",
		(cchar *)report
	)	;

	showAs	   = mode() ? KB::ShowAsDesign : KB::ShowAsData ;
	reportName = name()	;
	return	   report	;
}

		
