/***************************************************************************
    file	         : kb_reportviewer.cpp
    copyright            : (C) 1999,2000,2001,2002,2003 by Mike Richardson
			   (C) 2000,2001,2002,2003 by theKompany.com
			   (C) 2001,2002,2003 by John Dean
    license              : This file is released under the terms of
                           the GNU General Public License, version 2. The
                           copyright holders retain the right to release
                           this code under diffenent non-exclusive licences.
    email                : mike@quaking.demon.co.uk                                     
 ***************************************************************************/

#include	<qwidget.h>
#include	<qobjectlist.h>
#include	<qcombobox.h>

#include	"kb_classes.h"
#include	"kb_type.h"
#include	"kb_value.h"
#include	"kb_database.h"
#include	"kb_gui.h"
#include	"kb_dbinfo.h"
#include	"kb_dblink.h"
#include	"kb_display.h"
#include	"kb_report.h"
#include	"kb_options.h"
#include	"kb_string.h"
#include	"kb_nodereg.h"
#include	"kb_parse.h"
#include	"kb_attrdict.h"
#include	"kb_writer.h"

#include	"tk_icons.h"
#include	"tk_messagebox.h"


#ifndef 	_WIN32
#include	"kb_reportviewer.moc"
#else
#include	"kb_reportviewer.h"
#endif

#include	"kb_objtreeviewer.h"


static	GUIElement reportViewerGUI[] =
{
//	GType		GGroup		Enable	Text			Icon		Accelerator	Slot		    Element name	Code		Tool Tip
{	GTAction,	KB::GRNone,	true,	"Print Page",		"print",	ACCEL(NoAccel),	SLOT(printPage ()), "KB_printPage",	0,		"Print current page"		},
{	GTNone,		KB::GRNone,	false,	0,			0,		ACCEL(NoAccel),	0,		    0,		 	0,		0				}
}	;


/*  KBReportViewer							*/
/*  KBReportViewer							*/
/*		: Constructor for report viewer object			*/
/*  parent	: KBReportBase *  : Parent object			*/
/*  embed	: QWidget *	  : Parent widget			*/
/*  pDict	: QDict<QString>& : Parameter dictionary		*/
/*  modal	: bool		   : Run form modally			*/
/*  (returns)	: KBReportViewer  :					*/

KBReportViewer::KBReportViewer
	(	KBReportBase		*parent,
		QWidget			*embed,
		const QDict<QString>	&pDict,
		bool			modal
	)
	:
	KBViewer (parent, embed, WDestructiveClose|WStyle_NormalBorder, modal),
	m_base	 (parent),
	m_pDict	 (pDict)
{
	m_showing   = KB::ShowAsUnknown ;
	m_docRoot   = 0 ;
	m_writer    = 0 ;

	m_objTree   = 0 ;
	m_doSetup   = true ;

	m_designGUI = new KBaseGUI (this, this, "rekallui.report.design") ;
	m_dataGUI   = new KBaseGUI (this, this, "rekallui.report.data"  ) ;

	setLocalGUISpec	(&reportViewerGUI[0]) ;

	/* Set the page selector tool up by hand since this uses a	*/
	/* widget (specifically, a combo-box) embedded in the toolbar.	*/
	m_gotoPage  = new QComboBox	() ;
	m_gotoPage->setEditable 	(true) ;
	m_gotoPage->setInsertionPolicy	(QComboBox::NoInsertion) ;

	int	cw = QFontMetrics	(m_gotoPage->font()).size (0, "IWX").width() ;
	m_gotoPage->setFixedWidth	(m_gotoPage->sizeHint().width() + cw) ;

#if	(!((KDE_VERSION_MAJOR == 3) && (KDE_VERSION_MINOR == 0))) || __KB_TKC

	m_dataGUI->addAction
	(	"KB_gotoPage",
		new TKWidgetAction (m_gotoPage, this, "gotoPage")
	)	;

	connect
	(	m_gotoPage,
		SIGNAL(activated(const QString &)),
		SLOT  (gotoPage (const QString &))
	)	;
#endif
}

/*  KBReportViewer							*/
/*  ~KBReportViewer: Destructor for report viewer			*/
/*  (returns)	   : void	:					*/

KBReportViewer::~KBReportViewer ()
{
#if	! __KB_RUNTIME
	DELOBJ	(m_objTree) ;
#endif
}


/*  KBReportViewer							*/
/*  startup	: Startup form viewer object				*/
/*  _docRoot	: KBReport *	: Report object				*/
/*  showAs	: KB::ShowAs	: Display mode				*/
/*  key		: const KBValue & : Parent key				*/
/*  pError	: KBError &	: Error return				*/
/*  (returns)	: KB::ShowRC	: Startup success			*/

KB::ShowRC
	KBReportViewer::startup
	(	KBReport	*docRoot,
		KB::ShowAs	showAs,
		const KBValue	&key,
		KBError		&pError
	)
{
	KB::ShowRC	rc	  ;
	QSize		size	  ;

	m_docRoot	= docRoot ;
	m_showing	= showAs  ;
	m_parentKey	= key	  ;

	m_scroller	= new QScrollView (m_partWidget) ; 
	m_writer	= new KBWriter    (m_scroller->viewport(), getLocation()) ;
	m_pageno	= 0	;
	m_scroller->addChild (m_writer) ;
	m_scroller->hide     ()	;
	m_writer  ->show     ()	;

	/* Show the document, either in design or data view. If the	*/
	/* user cancels (which should never happen for design view)	*/	/* then immediately return a false result.			*/
#if	! __KB_RUNTIME
	if (m_showing == KB::ShowAsDesign)
		rc = m_docRoot->showDesign (m_partWidget, size) ;
	else
#endif
		rc = m_docRoot->showData   (m_partWidget, m_writer, m_pDict, m_parentKey, size, false) ;


	switch (rc)
	{
		case KB::ShowRCCancel :
			/* User cancelled, return this at once to the	*/
			/* caller.					*/
			return	KB::ShowRCCancel;

		case KB::ShowRCData   :
			/* Report now shown in data mode. This will be	*/
			/* passed back as being OK.			*/
			break	;

#if	! __KB_RUNTIME
		case KB::ShowRCDesign :
			/* If the user wanted data view then show the	*/
			/* error, but anyways passes back as OK.	*/
			if (m_showing == KB::ShowAsData)
			{	m_docRoot->lastError().DISPLAY() ;
				m_showing = KB::ShowAsDesign	 ;
			}
			break	;
#endif
		default	:
			/* The only other case should be an error ...	*/
			pError	= m_docRoot->lastError() ;
			return	KB::ShowRCError	;
	}

	/* In design mode, the top-level widget is the top-most display	*/
	/* widget, which in data mode it is the writer; in either case	*/
	/* ensure that is is show.					*/
#if	! __KB_RUNTIME
	if (m_showing == KB::ShowAsDesign)
		m_topWidget  = m_docRoot->getDisplay()->getTopWidget () ;
	else
#endif
		m_topWidget  = m_scroller ;

	m_topWidget->show () ;

	KBaseGUI *gui ;
#if	! __KB_RUNTIME
	if (m_showing == KB::ShowAsDesign)
		gui	= m_designGUI ;
	else
#endif
		gui	= m_dataGUI   ;

	setGUI		  (gui) ;
	m_docRoot->setGUI (gui) ;
	updateToolBar	  (true);

	/* The part widget is resized to the size required to display	*/
	/* the form (which depends on whether we are in data or design	*/
	/* mode); set the caption and icon, and show it.		*/
	setCaption (m_docRoot->getAttrVal("caption")) ;

	m_scroller  ->resizeContents (size.width(), size.height()) ;
	m_writer    ->resize 	     (size.width(), size.height()) ;

	m_partWidget->resize 	     (size.width(), size.height(), true, false) ;
	m_partWidget->setIcon	     (getSmallIcon ("document")) ;

	/* Finally show the part, either modally or not as requested.	*/
	return	m_partWidget->show   (false, KB::ShowAuto) ;
}

/*  KBReportViewer							*/
/*  showAs	: Switch between display modes				*/
/*  __showAs	: KB::ShowAs	: New display mode			*/
/*  (returns)	: void		:					*/

void	KBReportViewer::showAs
	(	KB::ShowAs	_showAs
	)
{
#if	!__KB_RUNTIME
	if ((_showAs == KB::ShowAsData) || (_showAs == KB::ShowAsDesign))
	{
		cchar		*cmsg	;
		KB::ShowRC	rc	;
		QSize		size	;

		if (_showAs == m_showing) return ;

		if ((m_showing == KB::ShowAsDesign) && ((cmsg = getChanged (false)) != 0))
			if (TKMessageBox::questionYesNo
				(	0,
					QString(TR("Report %1 changed: switch mode anyway?")).arg(cmsg)
				)	!= TKMessageBox::Yes)
				return	;
		m_showing = _showAs ;
		m_pageno = 0	;

		if (m_showing == KB::ShowAsDesign)
			rc = m_docRoot->showDesign (m_partWidget, size) ;
		else	rc = m_docRoot->showData   (m_partWidget, m_writer, m_pDict, m_parentKey, size, false) ;


		switch (rc)
		{
			case KB::ShowRCCancel :
				/* User cancelled. Must have been a	*/
				/* switch to data mode, so stay in	*/
				/* design.				*/
				m_showing = KB::ShowAsDesign ;
				break	;

			case KB::ShowRCData   :
				/* Report now shown in data mode.	*/
				break	;

			case KB::ShowRCDesign :
				/* If the user wanted data view then	*/
				/* show the error, but otherwise OK.	*/
				if (m_showing == KB::ShowAsData)
				{	m_docRoot->lastError().DISPLAY() ;
					m_showing = KB::ShowAsDesign ;
				}
				break	;

			default	:
				/* The only other case should be an	*/
				/* error, so assume design mode.	*/
				m_docRoot->lastError().DISPLAY() ;
				m_showing = KB::ShowAsDesign ;
				break	;
		}

		m_topWidget->hide () ;

		/* In design mode, the top-level widget is the		*/
		/* top-most display widget, while in data mode it is	*/
		/* the writer; in either case ensure that is is show.	*/
		if (m_showing == KB::ShowAsDesign)
			m_topWidget  = m_docRoot->getDisplay()->getTopWidget () ;
		else	m_topWidget  = m_scroller ;

		m_topWidget->show () ;

		KBaseGUI *g = m_showing == KB::ShowAsDesign ? m_designGUI : m_dataGUI ;
		setGUI		  (g) ;
		m_docRoot->setGUI (g) ;

		setCaption (m_docRoot->getAttrVal("caption")) ;

		m_scroller  ->resizeContents (size.width(), size.height()) ;
		m_writer    ->resize 	     (size.width(), size.height()) ;

		m_partWidget->resize	     (size.width(), size.height(), true, false) ;
		m_partWidget->setIcon	     (getSmallIcon ("document")) ;
		m_partWidget->show	     (true, KB::ShowAuto) ;

		updateToolBar (true) ;
		return	;
	}

	if ((_showAs == KB::ShowAsPrint) && (m_showing == KB::ShowAsDesign))
	{
		KBWriter *writer  = new KBWriter (0, getLocation()) ;

		if (!writer->setup
			(	m_docRoot->getAttrVal("printer" ),
				m_docRoot->getAttrVal("printdlg").toInt(),
				KBOptions::getLeftMargin  (),
				KBOptions::getRightMargin (),
				KBOptions::getTopMargin   (),
				KBOptions::getBottomMargin(),
				true
		   )	)
		{
			delete	writer ;
			return	;
		}

		int extra ;
		m_docRoot->write    (writer, QPoint(0,0), false, extra) ;
		writer   ->printDoc (QString::null, -1) ;

		delete	writer	;
		return	;
	}
#endif
#if	! __KB_EMBEDDED
	if ((_showAs == KB::ShowAsPrint ) && (m_showing == KB::ShowAsData))
	{
		m_base->doPrintReport (m_pDict, m_parentKey, m_writer, -1) ;
		return	;
	}
#endif
}

/*  KBReportViewer							*/
/*  saveDocumentAs: Save document under specified name			*/
/*  (returns)	  : void	:					*/

void	KBReportViewer::saveDocumentAs ()
{
#if	! __KB_RUNTIME
	/* This is only meaningful in design mode ....			*/
	if (m_showing == KB::ShowAsDesign)
		if (m_objBase->saveDocumentAs ())
		{	m_docRoot->isLayout()->setChanged(false) ;
			setCaption (m_docRoot->getAttrVal("caption")) ;
		}
#endif
}

/*  KBReportViewer							*/
/*  saveDocument: Save document						*/
/*  (returns)	: void		:					*/

void	KBReportViewer::saveDocument ()
{
#if	! __KB_RUNTIME
	/* If we are in design mode then this is interpreted as saving	*/
	/* the report design.						*/
	if (m_showing == KB::ShowAsDesign)
		if (m_objBase->saveDocument ())
		{	m_docRoot->isLayout ()->setChanged (false) ;
			setCaption (m_docRoot->getAttrVal("caption")) ;
		}
#endif
}

/*  KBReportViewer							*/
/*  queryClose	: Query whether to close				*/
/*  (returns)	: bool		: True to allow close			*/

bool	KBReportViewer::queryClose ()
{
	cchar	*cmsg	;

	if ((cmsg = getChanged (true)) != 0)
		if (TKMessageBox::questionYesNo
			(	0,
				QString(TR("Form %1 changed: close anyway?")).arg(cmsg)
			)	!= TKMessageBox::Yes
		   )	return	false	;

	return	true	;
}

/*  KBReportViewer							*/
/*  doCtrlAlign	: Handle control alignment request			*/
/*  align	: int		: Aligment operation			*/
/*  (returns)	: void		:					*/

void	KBReportViewer::doCtrlAlign
	(	int	align
	)
{
#if	! __KB_RUNTIME
	if (m_showing == KB::ShowAsDesign)
		m_docRoot->doCtrlAlign ((KB::CtrlAlign)align) ;
#endif
}

/*  KBReportViewer							*/
/*  showObjTree	: Toggle the object tree for the report			*/
/*  (returns)	: void		:					*/

void	KBReportViewer::showObjTree ()
{
#if	! __KB_RUNTIME
	if (m_objTree == 0)
	{
		m_objTree = new KBObjTreeViewer
				(	m_objBase,
					m_embed,
					getLocation(),
					m_docRoot,
					m_docRoot
				)	;

		connect
		(	m_objTree, SIGNAL(destroyed	   ()),
			this,	   SLOT  (objTreeViewerDead())
		)	;

		m_designGUI->setChecked ("KB_showObjTree", true) ;
		m_dataGUI  ->setChecked ("KB_showObjTree", true) ;
	}
	else
	{	DELOBJ	(m_objTree) ;
		objTreeViewerDead() ;
	}
#endif
}

/*  KBReportViewer							*/
/*  doMultiProp	: Invoke multiple-object properties dialog		*/
/*  (returns)	: void		:					*/

void	KBReportViewer::doMultiProp ()
{
#if	! __KB_RUNTIME
	if (m_docRoot) m_docRoot->KBLayout::doMultiProp () ;
#endif
}

/*  KBReportViewer							*/
/*  doProperties: Invoke object properties dialog			*/
/*  (returns)	: void		:					*/

void	KBReportViewer::doProperties ()
{
#if	! __KB_RUNTIME
	if (m_docRoot) m_docRoot->KBLayout::doSingleProp () ;
#endif
}

/*  KBReportViewer							*/
/*  objTreeViewerDead							*/
/*		: Note death of object tree display			*/
/*  (returns)	: void		:					*/

void	KBReportViewer::objTreeViewerDead ()
{
#if	! __KB_RUNTIME
	m_objTree	= 0 ;
	m_designGUI->setChecked ("KB_showObjTree", false) ;
	m_dataGUI  ->setChecked ("KB_showObjTree", false) ;
#endif
}

void	KBReportViewer::updateToolBar
	(	bool		loadPageList
	)
{
	if ((m_showing == KB::ShowAsData) && (m_writer != 0))
	{
		uint	nPages	= m_writer->numPages() ;

		m_dataGUI->setEnabled ("KB_firstPage", m_pageno > 0) ;
		m_dataGUI->setEnabled ("KB_prevPage",  m_pageno > 0) ;
		m_dataGUI->setEnabled ("KB_nextPage",  m_pageno < nPages - 1) ;
		m_dataGUI->setEnabled ("KB_lastPage",  m_pageno < nPages - 1) ;

		if (loadPageList)
		{
			m_gotoPage->clear() ;
			for (uint p = 0 ; p < nPages ; p += 1)
				m_gotoPage->insertItem (QString::number(p + 1)) ;
		}

		m_gotoPage->setCurrentItem (m_pageno) ;
	}
}

/*  KBReportViewer							*/
/*  dbaseAction	: Handle database action request			*/
/*  action	: iint		: Database action			*/
/*  (returns)	: void		:					*/

void	KBReportViewer::dbaseAction
	(	int	action
	)
{
	if (m_showing == KB::ShowAsData)
	{
		uint	nPages	= m_writer->numPages() ;

		switch ((KB::Action)action)
		{
			case KB::First	:
				if (m_pageno == 0) return ;
				m_pageno	= 0 ;
				break	;

			case KB::Previous :
				if (m_pageno == 0) return ;
				m_pageno -= 1 ;
				break	;

			case KB::Next	:
				if (m_pageno >= nPages - 1) return ;
				m_pageno += 1 ;
				break	;

			case KB::Last	:
				if (m_pageno >= nPages - 1) return ;
				m_pageno = nPages - 1 ;
				break	;

			default	:
				return	;
		}

		m_writer ->showPage (m_pageno) ;
		updateToolBar (false) ;
	}
}

/*  KBReportViewer							*/
/*  reload	: Reload table data					*/
/*  (returns)	: void		:					*/

void	KBReportViewer::reload ()
{
	if (m_showing == KB::ShowAsData)
	{
		m_writer->clear () ;

		if (!m_docRoot->requery ())
			m_docRoot->lastError().DISPLAY() ;

		m_pageno = 0 ;
		m_writer->showPage (0) ;
	}
}

/*  KBReportViewer							*/
/*  doCut	: Handle cut request					*/
/*  (returns)	: void		:					*/

void	KBReportViewer::doCut ()
{
#if	! __KB_RUNTIME
	if (m_showing == KB::ShowAsDesign) m_docRoot->doCut () ;
#endif
}

/*  KBReportViewer							*/
/*  doCopy	: Handle copy request					*/
/*  (returns)	: void		:					*/

void	KBReportViewer::doCopy ()
{
#if	! __KB_RUNTIME
	if (m_showing == KB::ShowAsDesign) m_docRoot->doCopy () ;
#endif
}

/*  KBReportViewer							*/
/*  doPaste	: Handle patse request					*/
/*  (returns)	: void		:					*/

void	KBReportViewer::doPaste ()
{
#if	! __KB_RUNTIME
	if (m_showing == KB::ShowAsDesign) m_docRoot->doPaste () ;
#endif
}

/*  KBReportViewer							*/
/*  getChanged	: Report whether there are unsaved changes		*/
/*  both	: bool		: True for both data and design change	*/
/*  (returns)	: cchar *	: Changed message or null if none	*/

cchar	*KBReportViewer::getChanged
	(	bool
	)
{
	return	m_docRoot->getChanged (false) ;
}

/*  KBReportViewer							*/
/*  snapToGrid	: Snap selected controls to the grid			*/
/*  (returns)	: void		:					*/

void	KBReportViewer::snapToGrid ()
{
#if	! __KB_RUNTIME
	if (m_showing == KB::ShowAsDesign) m_docRoot->snapToGrid () ;
#endif
}

void	KBReportViewer::gotoPage
	(	const QString	&page
	)
{
	int	pno	= page.toInt() - 1 ;

//	fprintf
//	(	stderr,
//		"KBReportViewer::gotoPage: [%s]->[%d]\n",
//		(cchar *)page,
//		pno
//	)	;

	if ((pno >= 0) && (pno < (int)m_writer->numPages()))
	{	m_pageno = pno ;
		m_writer ->showPage (pno  ) ;
		updateToolBar	    (false) ;
	}
}

void	KBReportViewer::printPage ()
{
	fprintf
	(	stderr,
		"KBReportViewer::printPage: m_pageno=%d\n",
		m_pageno
	)	;

	m_base->doPrintReport (m_pDict, m_parentKey, m_writer, m_pageno) ;
}
