import  Rekall
import  RekallMain
import  string

dbtype	= ""

#  empty        : See if a value is empty (null or empty string)
#  value        : Value to check
#  (returns)    : Empty

def empty (value) :

    return (value == None) or (value == "")


#  getInfo	: Get column information
#  ctrl		: Control in design form
#  coltype	: Column type
#  (returns)	: Flags

def getInfo (ctrl, coltype) :

    if empty (coltype) : return [ 0, 0, 0 ]

    dbtype = ctrl.getForm().getAttr("dbtype")

    # Error checking .... these cases should not occur
    #
    if not typeMap.has_key(dbtype) :
        RekallMain.messageBox ("Typemap missing [" + dbtype + "]")
        return [0, 0, 0]
    if not typeMap[dbtype].has_key(coltype) :
        RekallMain.messageBox ("Typemap [" + dbtype + "] missing [" + coltype + "]")
        return [0, 0, 0]

    return typeMap[dbtype][coltype]

#  getFlags	: Get column flags
#  ctrl		: Control in design form
#  coltype	: Column type
#  (returns)	: Flags

def getFlags (ctrl, coltype) :

    return getInfo (ctrl, coltype) [0]


#  setAsPrimary : Set specified column as primary key
#  main         : Design form main block
#  inner        : Design form inner block
#  qrow         : Query row, ie., the column number
#  enlen        : Whether the length field is enabled
#  (returns)    : None

def setAsPrimary (main, inner, qrow, enlen) :

    inner.getNamedCtrl("Length" ).setEnabled(0, enlen)
    inner.getNamedCtrl("Prec"   ).setEnabled(0, 0)
    inner.getNamedCtrl("Indexed").setEnabled(0, 0)
    inner.getNamedCtrl("NullOK" ).setEnabled(0, 0)
    main .getNamedCtrl("PKey"   ).setValue  (qrow, "1")

    for srow in range (main.getNumRows()) :

        if srow == qrow :
            main.setRowValue ("PKey", srow, "1")
            continue

        main.setRowValue ("PKey", srow, "0")

        if main.getRowValue ("Type", srow) == "Primary Key" :
            main.setRowValue ("Type", srow, "Integer")



#  onChoiceTypeChange
#               : Type choice control change handler
#  ctrl         : Choice control
#  qrow         : Query row, ie., the column number
#  type         : New type
#  (returns)    : None

def onChoiceTypeChange (ctrl, qrow, type) :

    outer  = ctrl .getBlock    ()
    main   = outer.getNamedCtrl("Main"   )
    inner  = outer.getNamedCtrl("Details") 
    flen   = inner.getNamedCtrl("Length" )
    fprec  = inner.getNamedCtrl("Prec"   )

    if flen .getValue (0) in ["", "0", None] : flen .setValue (0, "0")
    if fprec.getValue (0) in ["", "0", None] : fprec.setValue (0, "0")

    if type == "Primary Key" :
        setAsPrimary (main, inner, qrow, 0)
        return

    info   = getInfo (ctrl, type)
    hasLen = (info[0] & 0x0001) != 0
    hasPrec= (info[0] & 0x0002) != 0

    flen .setEnabled  (0, hasLen )
    fprec.setEnabled  (0, hasPrec)
    inner.getNamedCtrl("Indexed").setEnabled(0, 1)
    inner.getNamedCtrl("NullOK" ).setEnabled(0, 1)

    if hasLen  :
           curLen  = flen .getValue (0)
           if empty (curLen ) or curLen  == '0' :
               flen .setValue (0, info[1])
    else : flen .setValue (0, ''  )

    if hasPrec :
           curPrec = fprec.getValue (0)
           if empty (curPrec) or curPrec == '0' :
               fprec.setValue (0, info[2])
    else : fprec.setValue (0, ''  )


# onCheckPrimaryChange
#               : Primary checkbox control change handler
#  ctrl         : Checkbox control
#  qrow         : Query row, ie., the column number
#  isset        : Checkbox set
#  (returns)    : None

def onCheckPrimaryChange (ctrl, qrow, isset) :

    outer  = ctrl .getBlock    ()
    main   = outer.getNamedCtrl("Main"   ) 
    inner  = outer.getNamedCtrl("Details") 

    if isset :
        setAsPrimary (main, inner, qrow, 1)
        return

    type   = main.getNamedCtrl("Type").getValue(qrow)

    if type == "Primary Key" :
        type = "Integer"
        main.getNamedCtrl("Type").setValue(qrow, type)

    flags  = getFlags (ctrl, type)

    inner.getNamedCtrl("Length" ).setEnabled(0, (flags & 0x0001) != 0)
    inner.getNamedCtrl("Prec"   ).setEnabled(0, (flags & 0x0002) != 0)
    inner.getNamedCtrl("Indexed").setEnabled(0, 1)
    inner.getNamedCtrl("NullOK" ).setEnabled(0, 1)



#  onBlockCurrent
#               : Outer block new current row handler
#  outer        : Outer block
#  qrow         : Query row, ie., the column number
#  (returns)    : None

def onBlockCurrent (outer, qrow) :

    main   = outer.getNamedCtrl("Main"   )
    inner  = outer.getNamedCtrl("Details")
    pk     = main .getNamedCtrl("PKey"   ).getValue(qrow) == "1"
    type   = main .getNamedCtrl("Type"   ).getValue(qrow)

    flags  = getFlags (outer, type)

    inner.getNamedCtrl("Length" ).setEnabled(0, (flags & 0x0001) != 0)
    inner.getNamedCtrl("Prec"   ).setEnabled(0, (flags & 0x0002) != 0)
    inner.getNamedCtrl("Indexed").setEnabled(0, not pk)
    inner.getNamedCtrl("NullOK" ).setEnabled(0, not pk)
    


#  onBlockUnCurrent
#               : Outer block leave row handler
#  outer        : Outer block
#  qrow         : Query row, ie., the column number
#  (returns)    : None

def onBlockUnCurrent (outer, qrow) :

    pass


#  onBlockAction: Inner block action handler
#  inner        : Inner block
#  action       : Requested action
#  (returns)    : True to continue action

def onBlockAction (inner, action) :

    # This is used to map record navigation operations in the inner
    # block to the same operation in the outer block, since the row in
    # the inner block is logically just an extension of that in the
    # outer.
    #
    if action in [ RekallMain.actFirst,
                   RekallMain.actPrevious,
                   RekallMain.actNext,
                   RekallMain.actLast,
                   RekallMain.actAdd,
                   RekallMain.actInsert,
                   RekallMain.actDelete
                 ] :

        inner           .doAction (RekallMain.actStore)
        inner.getBlock().doAction (action)
        return 0

    # Reset and the save operations are allowed through ...
    #
    if action in [ RekallMain.actReset,
		   RekallMain.actSave,
		   RekallMain.actSyncAll,
		   RekallMain.actStore
                 ] :

        return 1

    # ... but anything else, for instance the query operations, are
    # silently ignored
    #
    return 0


#  onItemEnterDesign
#               : Handle entry into a design control
#  ctrl         : Design control
#  qrow         : Query row
#  (returns)    : void

def onItemEnterDesign (ctrl, qrow) :

    info = ctrl.getBlock().getNamedCtrl("Info")
    info.setText (RekallMain.getDictEntry("table", "__TableDesign", ctrl.getName()))


#  onFormLoad	: Handle initial form loading event
#  form		: Form
#  (returns)	: Always non-zero

def onFormLoad (form) :

    dblink   = form  .openServer("Self")
    dbtype   = dblink.getDBType()

    if not typeMap.has_key (dbtype) :

        map             = {}
        typeMap[dbtype] = map

        for pair in string.split (dblink.listTypes(), "|") :
            bits = string.split (pair, ",") + ['50', '2']
            map[bits[0]] = [ int(bits[1]), bits[2], bits[3] ]

    # Save the server type against the form since this will be needed
    # when getting the column type flags
    #
    form.setAttr ("dbtype", dbtype)
    return	1


typeMap = {}
