/***************************************************************************
    file	         : kb_filterdlg.h
    copyright            : (C) 1999,2000,2001,2002,2003 by Mike Richardson
			   (C) 2000,2001,2002,2003 by theKompany.com
			   (C) 2001,2002,2003 by John Dean
    license              : This file is released under the terms of
                           the GNU General Public License, version 2. The
                           copyright holders retain the right to release
                           this code under diffenent non-exclusive licences.
    email                : mike@quaking.demon.co.uk                                     
 ***************************************************************************/

#ifndef	__KB_FILTERDLG_H
#define	__KB_FILTERDLG_H

#include	<qgroupbox.h>
#include	<qlistbox.h>
#include	<qpushbutton.h>

#include	"kb_dialog.h"


class	KBTableInfo	;
class	KBTableSpec	;


/*  KBFilterDlg								*/
/*  -----------								*/
/*  This is the "outer" dialog for filter (sort/select/view) creation	*/
/*  and editing. Displays lists of the available filters, and provides	*/
/*  access to the create, edit and delete functions.			*/

class	KBFilterDlg : public _KBDialog
{
	Q_OBJECT

	QGroupBox	m_sortGroup	;
	QGroupBox	m_selectGroup	;
	QGroupBox	m_viewGroup	;

	QListBox	m_sortNames	;
	QWidget		m_sortWidget	;

	QListBox	m_selectNames	;
	QWidget		m_selectWidget	;

	QListBox	m_viewNames	;
	QWidget		m_viewWidget	;

	QPushButton	m_sortEdit	;
	QPushButton	m_sortNew	;
	QPushButton	m_sortDelete	;

	QPushButton	m_selectEdit	;
	QPushButton	m_selectNew	;
	QPushButton	m_selectDelete	;

	QPushButton	m_viewEdit	;
	QPushButton	m_viewNew	;
	QPushButton	m_viewDelete	;

#if	! __KB_EMBEDDED
	QPushButton	m_bClose	;
#endif
	KBTableSpec	&m_tableSpec	;
	KBTableInfo	*m_tableInfo	;

	void		loadSortList	() ;
	void		loadSelectList	() ;
	void		loadViewList	() ;

protected slots :

	void		slotEditSort	() ;
	void		slotEditSelect	() ;
	void		slotEditView	() ;

	void		slotNewSort	() ;
	void		slotNewSelect	() ;
	void		slotNewView	() ;

	void		slotDeleteSort	() ;
	void		slotDeleteSelect() ;
	void		slotDeleteView	() ;

	void		slotHiliteSort	() ;
	void		slotHiliteSelect() ;
	void		slotHiliteView  () ;

	void		slotClickClose	() ;

public	:

	KBFilterDlg	(KBTableSpec &, KBTableInfo *) ;
}	;

#endif	// __KB_FILTERDLG_H
